/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.table.state;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridEditor;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLCommonStateDBTableManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLConstantDefine;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLContextDefaultValueHashMap;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLContextNameEnum;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSelectionData;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class GLContextTable
extends DATableComposite {
    private static final String STATE_CHANGE = "STATE_CHANGE";
    private boolean isCheckedBox = true;
    private String selectedSeq = "";
    private List<Object> stateValueList = null;
    private String selectedStateName = "";
    private Composite naviButtonLeftComposite;
    private Composite naviButtonRightComposite;
    private DACustomButton buttonLeftLeft;
    private DACustomButton buttonRightRight;
    private DACustomButtonClickEventListener NavigationPreSelectionListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            GLDataManager.getInstance().setSelectedAPIAtTable("");
            int contextDBIndex = GLContextTable.this.getSelectedStateIndex();
            if (contextDBIndex < 0) {
                return;
            }
            List<Object> searchInfo = GLDataManager.getInstance().getStateHistoryDBTableManage().selectLastChangedSeq(GLDataManager.getInstance().getSelectedContextID(), contextDBIndex, Long.parseLong(GLContextTable.this.selectedSeq));
            GLContextTable.this.updateCurrentPage(searchInfo);
        }
    };
    private DACustomButtonClickEventListener NavigationNextSelectionListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            GLDataManager.getInstance().setSelectedAPIAtTable("");
            int contextDBIndex = GLContextTable.this.getSelectedStateIndex();
            if (contextDBIndex < 0) {
                return;
            }
            List<Object> searchInfo = GLDataManager.getInstance().getStateHistoryDBTableManage().selectNextChangedSeq(GLDataManager.getInstance().getSelectedContextID(), contextDBIndex, Long.parseLong(GLContextTable.this.selectedSeq));
            GLContextTable.this.updateCurrentPage(searchInfo);
        }
    };

    public GLContextTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = GLContextTable.this.table.getSelection();
                if (items.length <= 0) {
                    return;
                }
                GLSelectionData selData = new GLSelectionData(GLPage.contextViewID, -1L, -1L, items, (Control)GLContextTable.this.table, -1, -1L);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                GridItem gridItem = GLContextTable.this.table.getItem(new Point(e.x, e.y));
                if (gridItem == null) {
                    GLContextTable.this.disposeNaviButtons();
                    return;
                }
                int secondeColumnStartX = GLContextTable.this.table.getColumn(0).getWidth();
                int secondeColumnEndX = secondeColumnStartX + GLContextTable.this.table.getColumn(1).getWidth();
                if (secondeColumnStartX <= e.x && e.x <= secondeColumnEndX && gridItem.getText(3).equals(GLContextTable.STATE_CHANGE)) {
                    String stateName = gridItem.getText(0);
                    GLContextTable.this.createNaviButtons(gridItem, stateName);
                } else {
                    GLContextTable.this.disposeNaviButtons();
                }
            }
        });
    }

    public void setSelectedSeq(boolean isCheckedBox, String selectedSeq, List<Object> stateValueList) {
        this.isCheckedBox = isCheckedBox;
        this.selectedSeq = selectedSeq;
        this.stateValueList = stateValueList;
    }

    @Override
    protected List<TableInput> makeTableInput() {
        if (this.stateValueList == null) {
            return null;
        }
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        GLCommonStateDBTableManager dbManager = GLDataManager.getInstance().getContextDBTableManage();
        int size = dbManager.getColumnSize();
        int i = 0;
        while (i < size) {
            if (i != GLContextNameEnum.RID.ordinal() && i != GLContextNameEnum.SEQ.ordinal() && i != GLContextNameEnum.CONTEXT_ID.ordinal() && i != GLContextNameEnum.TEXTURE_ACTIVE.ordinal()) {
                ArrayList<String> text = new ArrayList<String>();
                DATableDataFormat tableData = new DATableDataFormat(Long.parseLong(this.selectedSeq));
                String stateName = dbManager.getColumnName()[i];
                Object defaultValue = GLContextDefaultValueHashMap.getDefaultValue(stateName);
                Object currentValue = this.stateValueList.get(i);
                String defatueState = "";
                String currenteState = "";
                if (GLDataManager.getInstance().getContextDBTableManage().isIntegerType(i)) {
                    defatueState = Integer.toString((Integer)defaultValue);
                    currenteState = currentValue == null ? defatueState : Integer.toString((Integer)currentValue);
                } else if (GLDataManager.getInstance().getContextDBTableManage().isLongType(i)) {
                    defatueState = Long.toString((Long)defaultValue);
                    currenteState = currentValue == null ? defatueState : Long.toString((Long)currentValue);
                } else if (GLDataManager.getInstance().getContextDBTableManage().isBooleans(i)) {
                    defatueState = Boolean.toString((Boolean)defaultValue);
                    currenteState = currentValue == null ? defatueState : Boolean.toString((Boolean)currentValue);
                } else if (GLDataManager.getInstance().getContextDBTableManage().isStringType(i)) {
                    defatueState = (String)defaultValue;
                    currenteState = currentValue == null ? defatueState : (String)currentValue;
                } else if (GLDataManager.getInstance().getContextDBTableManage().isBooleanArray(i) || GLDataManager.getInstance().getContextDBTableManage().isIntegerArray(i) || GLDataManager.getInstance().getContextDBTableManage().isLongArray(i)) {
                    defatueState = "null";
                    currenteState = currentValue == null ? defatueState : currentValue.toString();
                } else {
                    Logger.error((Object)("undefine column : " + i));
                }
                if (!this.isCheckedBox || this.isChangeStateValue(defatueState, currenteState)) {
                    text.add(stateName);
                    text.add(GLConstantDefine.convertEnumValue(defatueState, ",", new String[]{"[", "]"}));
                    text.add(GLConstantDefine.convertEnumValue(currenteState, ",", new String[]{"[", "]"}));
                    if (this.isChangeStateValue(defatueState, currenteState)) {
                        text.add(STATE_CHANGE);
                    } else {
                        text.add("");
                    }
                    TableInput tableInput = new TableInput();
                    tableInput.setText(text);
                    tableInput.setData(tableData);
                    input.add(tableInput);
                    if (this.isChangeStateValue(defatueState, currenteState)) {
                        tableInput.setInRange(true);
                    }
                }
            }
            ++i;
        }
        return input;
    }

    private boolean isChangeStateValue(String defaultValue, String currentValue) {
        String removeOpenBracket = currentValue.replace("[", "");
        String removeCloseBracket = removeOpenBracket.replace("]", "");
        return !defaultValue.equals(removeCloseBracket.trim());
    }

    private void disposeNaviButtons() {
        if (this.naviButtonLeftComposite != null) {
            this.naviButtonLeftComposite.dispose();
        }
        if (this.naviButtonRightComposite != null) {
            this.naviButtonRightComposite.dispose();
        }
        if (this.buttonLeftLeft != null) {
            this.buttonLeftLeft.dispose();
        }
        if (this.buttonRightRight != null) {
            this.buttonRightRight.dispose();
        }
    }

    private void createNaviButtons(GridItem gridItem, String stateName) {
        this.disposeNaviButtons();
        Color bgColor = this.table.isSelected(gridItem) ? ColorResources.TABLE_CONTENTS_SELECTED_END : gridItem.getBackground();
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = -1;
        formLayout.marginWidth = -1;
        this.naviButtonLeftComposite = new Composite((Composite)this.table, 0);
        this.naviButtonLeftComposite.setLayout((Layout)formLayout);
        this.naviButtonLeftComposite.setBackground(bgColor);
        this.buttonLeftLeft = new DACustomButton(this.naviButtonLeftComposite, ImageResources.OPEN_GL_PRE_NAVI_NORMAL, ImageResources.OPEN_GL_PRE_NAVI_PUSH, ImageResources.OPEN_GL_PRE_NAVI_HOVER, ImageResources.OPEN_GL_PRE_NAVI_NORMAL);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 2);
        formData.left = new FormAttachment(0, 2);
        formData.right = new FormAttachment(100, -1);
        formData.width = ImageResources.OPEN_GL_PRE_NAVI_NORMAL.getBounds().width;
        formData.height = ImageResources.OPEN_GL_PRE_NAVI_NORMAL.getBounds().height;
        this.buttonLeftLeft.setLayoutData((Object)formData);
        this.naviButtonLeftComposite.pack();
        GridEditor editor = new GridEditor(this.table);
        editor.minimumWidth = this.naviButtonLeftComposite.getSize().x;
        editor.horizontalAlignment = 16384;
        editor.setEditor((Control)this.naviButtonLeftComposite, gridItem, 1);
        this.naviButtonRightComposite = new Composite((Composite)this.table, 0);
        this.naviButtonRightComposite.setLayout((Layout)formLayout);
        this.naviButtonRightComposite.setBackground(bgColor);
        this.buttonRightRight = new DACustomButton(this.naviButtonRightComposite, ImageResources.OPEN_GL_NEXT_NAVI_NORMAL, ImageResources.OPEN_GL_NEXT_NAVI_PUSH, ImageResources.OPEN_GL_NEXT_NAVI_HOVER, ImageResources.OPEN_GL_NEXT_NAVI_NORMAL);
        formData = new FormData();
        formData.top = new FormAttachment(0, 2);
        formData.left = new FormAttachment(0, 1);
        formData.right = new FormAttachment(100, -2);
        formData.width = ImageResources.OPEN_GL_PRE_NAVI_NORMAL.getBounds().width;
        formData.height = ImageResources.OPEN_GL_PRE_NAVI_NORMAL.getBounds().height;
        this.buttonRightRight.setLayoutData((Object)formData);
        this.naviButtonRightComposite.pack();
        editor = new GridEditor(this.table);
        editor.minimumWidth = this.naviButtonRightComposite.getSize().x;
        editor.horizontalAlignment = 131072;
        editor.setEditor((Control)this.naviButtonRightComposite, gridItem, 1);
        this.selectedStateName = stateName;
        this.buttonLeftLeft.addClickListener(this.NavigationPreSelectionListener);
        this.buttonRightRight.addClickListener(this.NavigationNextSelectionListener);
    }

    private int getSelectedStateIndex() {
        if (this.selectedSeq == null) {
            return -1;
        }
        int contextDBIndex = -1;
        GLContextNameEnum[] glContextDBEnum = GLContextNameEnum.values();
        int i = 0;
        while (i < glContextDBEnum.length) {
            if (glContextDBEnum[i].getcolumnName().equals(this.selectedStateName)) {
                contextDBIndex = i;
                return contextDBIndex;
            }
            ++i;
        }
        return -1;
    }

    private void updateCurrentPage(List<Object> searchInfo) {
        if (searchInfo == null || searchInfo.size() == 0) {
            return;
        }
        long seq = (Long)searchInfo.get(2);
        int frameRateIndex = (Integer)searchInfo.get(3);
        int frameTimeIndex = (Integer)searchInfo.get(4);
        GLSelectionData selData = new GLSelectionData("contextHistoryID.id", null, frameTimeIndex, frameRateIndex, seq);
        AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
        this.disposeNaviButtons();
    }
}

