/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.nl.TargetDialogLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.TargetDialogAppListPage;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.TargetDialogInfoPage;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.TargetDialogTargetPage;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class TargetDialog
extends DAMessageBox {
    private static boolean opened = false;
    private final int WINDOW_WIDTH = 960;
    private final int WINDOW_HEIGHT = 620;
    private final int CONTENT_HEIGHT = 489;
    private final int TITLE_HEIGTH = 38;
    private final int LINE = 1;
    private final int BUTTONCOMP_HEIGHT = 60;
    private final int TARGET_COMP_WIDTH = 180;
    private final int TARGET_COMP_HEIGHT = 489;
    private final int APPLIST_WIDTH = 280;
    private final int APPLIST_HEIGHT = 489;
    private final int INFO_HEIGHT = 489;
    private final int BUTTON_WIDTH = 86;
    private final int BUTTON_HEIGHT = 24;
    private Button okButton = null;
    private TargetDialogTargetPage targetDialogTargetPage = null;
    private TargetDialogAppListPage targetDialogAppListPage = null;
    private TargetDialogInfoPage targetDialogInfoPage = null;
    private ShellListener shellListener = new ShellListener(){

        public void shellActivated(ShellEvent e) {
        }

        public void shellClosed(ShellEvent e) {
        }

        public void shellDeactivated(ShellEvent e) {
        }

        public void shellDeiconified(ShellEvent e) {
        }

        public void shellIconified(ShellEvent e) {
        }
    };

    public TargetDialog(Shell parentShell) {
        super(parentShell);
    }

    protected boolean run() {
        DeviceInfo selecedDev;
        if (opened) {
            return false;
        }
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 960) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - 620) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setSize(960, 620);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(TargetDialogLabels.TITLE);
        this.shell.setBackground(ColorResources.DIALOG_MIDDLE_LINE_COLOR);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                opened = false;
                ShortCutManager.getInstance().setEnabled(!opened);
            }
        });
        Composite topMarginComp = new Composite((Composite)this.shell, 0);
        FormData compData = new FormData();
        compData.top = new FormAttachment(0, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.height = 1;
        topMarginComp.setLayoutData((Object)compData);
        topMarginComp.setLayout((Layout)new FillLayout());
        topMarginComp.setBackground(ColorResources.DIALOG_TOP_LINE_COLOR);
        Composite textComp = new Composite((Composite)this.shell, 0);
        textComp.setLayout((Layout)new FormLayout());
        compData = new FormData();
        compData.top = new FormAttachment(0, 1);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.height = 38;
        textComp.setLayoutData((Object)compData);
        textComp.setLayout((Layout)new FormLayout());
        textComp.setBackground(ColorResources.FEATURE_TITLE_BACKGROUND);
        Composite contentsComp = new Composite((Composite)this.shell, 0);
        compData = new FormData();
        compData.top = new FormAttachment((Control)textComp, 1);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.height = 489;
        contentsComp.setLayoutData((Object)compData);
        contentsComp.setLayout((Layout)new FormLayout());
        contentsComp.setBackground(ColorResources.DIALOG_MIDDLE_LINE_COLOR);
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        compData = new FormData();
        compData.top = new FormAttachment((Control)contentsComp, 1);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        buttonComp.setLayoutData((Object)compData);
        buttonComp.setLayout((Layout)new FormLayout());
        buttonComp.setBackground(ColorResources.WHITE);
        this.createTextComp(textComp);
        this.createContentComp(contentsComp);
        this.createButtonComp(buttonComp);
        if (Global.getCurrentDeviceInfo() != null && this.targetDialogTargetPage.selectDevice(selecedDev = Global.getCurrentDeviceInfo()) && Global.getCurrentApplication() != null) {
            AppInfo selecedApp = Global.getCurrentApplication();
            this.targetDialogAppListPage.selectApp(selecedApp);
        }
        opened = true;
        ShortCutManager.getInstance().setEnabled(!opened);
        this.shell.addShellListener(this.shellListener);
        this.shell.open();
        return true;
    }

    private void createTextComp(Composite textComp) {
        int labelY = 10;
        int labelX = 20;
        Label device = new Label(textComp, 0);
        FormData compData = new FormData();
        compData.top = new FormAttachment(0, labelY);
        compData.left = new FormAttachment(0, labelX);
        compData.bottom = new FormAttachment(100, 0);
        compData.width = 180 - labelX;
        device.setLayoutData((Object)compData);
        device.setBackground(ColorResources.FEATURE_TITLE_BACKGROUND);
        device.setText(TargetDialogLabels.DEVICE);
        Label application = new Label(textComp, 0);
        compData = new FormData();
        compData.top = new FormAttachment(0, labelY);
        compData.left = new FormAttachment((Control)device, labelX);
        compData.bottom = new FormAttachment(100, 0);
        compData.width = 280 - labelX;
        application.setLayoutData((Object)compData);
        application.setBackground(ColorResources.FEATURE_TITLE_BACKGROUND);
        application.setText(TargetDialogLabels.APPLICATION);
        Label description = new Label(textComp, 0);
        compData = new FormData();
        compData.top = new FormAttachment(0, labelY);
        compData.left = new FormAttachment((Control)application, labelX);
        compData.bottom = new FormAttachment(100, 0);
        compData.right = new FormAttachment(100, 0);
        description.setLayoutData((Object)compData);
        description.setBackground(ColorResources.FEATURE_TITLE_BACKGROUND);
        description.setText(TargetDialogLabels.DESCRIPTION);
    }

    private void createContentComp(Composite contentsComp) {
        Composite targetComp = new Composite(contentsComp, 0);
        FormData compData = new FormData();
        compData.top = new FormAttachment(0, 0);
        compData.left = new FormAttachment(0, 0);
        compData.width = 180;
        compData.height = 489;
        targetComp.setLayoutData((Object)compData);
        targetComp.setLayout((Layout)new FormLayout());
        targetComp.setBackground(ColorResources.FEATURE_TARGETCOMP_BACKGROUND);
        Composite appListComp = new Composite(contentsComp, 0);
        compData = new FormData();
        compData.top = new FormAttachment(0, 0);
        compData.left = new FormAttachment((Control)targetComp, 1);
        compData.width = 280;
        compData.height = 489;
        appListComp.setLayoutData((Object)compData);
        appListComp.setLayout((Layout)new FormLayout());
        appListComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        Composite infoComp = new Composite(contentsComp, 0);
        compData = new FormData();
        compData.top = new FormAttachment(0, 0);
        compData.left = new FormAttachment((Control)appListComp, 1);
        compData.right = new FormAttachment(100, 0);
        compData.height = 489;
        infoComp.setLayoutData((Object)compData);
        infoComp.setLayout((Layout)new FormLayout());
        infoComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        this.targetDialogTargetPage = new TargetDialogTargetPage(targetComp, this, 0x40000000);
        this.targetDialogAppListPage = new TargetDialogAppListPage(appListComp, this, 0x40000000);
        this.targetDialogInfoPage = new TargetDialogInfoPage(infoComp, 0x40000000);
    }

    private void createButtonComp(Composite buttonComp) {
        int buttonposition = 18;
        this.okButton = new Button(buttonComp, 8);
        this.okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TargetDialog.this.updateToolBar();
                TargetDialog.this.shell.close();
            }
        });
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment(0, buttonposition);
        buttonData.right = new FormAttachment(100, -15);
        buttonData.width = 86;
        buttonData.height = 24;
        this.okButton.setLayoutData((Object)buttonData);
        this.okButton.setEnabled(false);
        Button cancelButton = new Button(buttonComp, 8);
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TargetDialog.this.shell.close();
            }
        });
        cancelButton.setText(WidgetLabels.CANCEL);
        cancelButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        buttonData = new FormData();
        buttonData.top = new FormAttachment(0, buttonposition);
        buttonData.right = new FormAttachment((Control)this.okButton, -8);
        buttonData.width = 86;
        buttonData.height = 24;
        cancelButton.setLayoutData((Object)buttonData);
        Button refershButton = new Button(buttonComp, 8);
        refershButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TargetDialog.this.targetDialogTargetPage != null) {
                    TargetDialog.this.targetDialogTargetPage.drawTarageData();
                    TargetDialog.this.targetDialogAppListPage.drawAppList(null);
                    TargetDialog.this.targetDialogInfoPage.drawDeviceInfoPage(null);
                    TargetDialog.this.targetDialogInfoPage.drawAppInfoPage(null);
                    TargetDialog.this.setOKButtonEnable(false);
                }
            }
        });
        refershButton.setText(TargetDialogLabels.REFRESH);
        refershButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        buttonData = new FormData();
        buttonData.top = new FormAttachment(0, buttonposition);
        buttonData.right = new FormAttachment((Control)cancelButton, -8);
        buttonData.width = 86;
        buttonData.height = 24;
        refershButton.setLayoutData((Object)buttonData);
    }

    public TargetDialogTargetPage getTargetPage() {
        return this.targetDialogTargetPage;
    }

    public TargetDialogAppListPage getAppListPage() {
        return this.targetDialogAppListPage;
    }

    public TargetDialogInfoPage getInfoPage() {
        return this.targetDialogInfoPage;
    }

    public void setOKButtonEnable(boolean enable) {
        if (this.okButton != null) {
            this.okButton.setEnabled(enable);
        }
    }

    private void updateToolBar() {
        final DeviceInfo curDev = this.targetDialogInfoPage.getSelectedDevice();
        final AppInfo curApp = this.targetDialogInfoPage.getSelectedApp();
        if (curDev == null || curApp == null) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String devName = curDev.getIDevice().getSerialNumber();
                if (Toolbar.INSTANCE.setDevice(devName)) {
                    Global.setCurrentDeviceInfo(curDev);
                    String appID = curApp.getAppID();
                    if (Toolbar.INSTANCE.setApplicationByID(appID)) {
                        Global.setCurrentApplication(curApp);
                        Toolbar.INSTANCE.changeUIState(DAState.INIT);
                    } else {
                        Logger.warning((Object)("Failed to set application to toolbar - " + appID));
                    }
                } else {
                    Logger.warning((Object)("Failed to set device to toolbar - " + devName));
                }
            }
        });
    }
}

