/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli;

import java.rmi.ConnectException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.dynamicanalyzer.cli.manager.ClientUtils;
import org.tizen.dynamicanalyzer.cli.manager.ProcessManagerMBean;
import org.tizen.dynamicanalyzer.cli.manager.TracingProcessContext;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArguments;
import org.tizen.dynamicanalyzer.cli.utils.HumanReadableTimeFormat;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.UIMode;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.communicator.DeviceManager;
import org.tizen.dynamicanalyzer.handlers.CommandAction;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.PrimitiveFeature;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.setting.UILayoutDataManager;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.sdblib.IDevice;

public final class CliInternals {
    private static final String ipV4Pattern = "(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}):(\\d+)";
    private static final String ipV6Pattern = "\\[([a-fA-F0-9:]+)\\]:(\\d+)";
    private static final Pattern p = Pattern.compile("(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}):(\\d+)|\\[([a-fA-F0-9:]+)\\]:(\\d+)");
    private static volatile boolean isSdbBridgeInitiated = false;
    private static volatile ProcessManagerMBean PM_PROXY_INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ProcessManagerMBean getPMProxyInstance() throws ConnectException {
        if (PM_PROXY_INSTANCE != null) return PM_PROXY_INSTANCE;
        Class<CliInternals> clazz = CliInternals.class;
        synchronized (CliInternals.class) {
            if (PM_PROXY_INSTANCE != null) return PM_PROXY_INSTANCE;
            PM_PROXY_INSTANCE = ClientUtils.getProcessManagerProxy(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return PM_PROXY_INSTANCE;
        }
    }

    private static void initDevices() {
        if (!isSdbBridgeInitiated) {
            DeviceManager.init();
            isSdbBridgeInitiated = true;
        }
    }

    public static List<DeviceInfo> getDevices() {
        CliInternals.initDevices();
        List devices = DeviceManager.getDevicesOnSdb();
        return devices;
    }

    public static String getDeviceName(DeviceInfo devInfo) {
        return devInfo.getIDevice().getDeviceName();
    }

    public static String getSerialNumber(DeviceInfo devInfo) {
        return devInfo.getIDevice().getSerialNumber();
    }

    public static IDevice getDeviceBySerial(String serial) {
        List<DeviceInfo> devices = CliInternals.getDevices();
        for (DeviceInfo devInfo : devices) {
            IDevice dev = devInfo.getIDevice();
            if (!dev.getSerialNumber().equals(serial)) continue;
            return dev;
        }
        return null;
    }

    public static boolean isDeviceExist(String device) {
        return CliInternals.getDeviceBySerial(device) != null || CliInternals.getDeviceByIp(device) != null;
    }

    public static IDevice getDeviceByIp(String ip) {
        Matcher m = p.matcher(ip);
        if (!m.matches()) {
            return null;
        }
        String host = null;
        int port = -1;
        if (m.group(1) != null) {
            host = m.group(1);
            port = Integer.parseInt(m.group(2));
        } else {
            host = m.group(3);
            port = Integer.parseInt(m.group(4));
        }
        CliInternals.initDevices();
        List devices = DeviceManager.getDevices();
        for (DeviceInfo devInfo : devices) {
            IDevice dev = devInfo.getIDevice();
            if (!dev.getIp().equals(host) || dev.getBasePort() != port) continue;
            return dev;
        }
        return null;
    }

    public static boolean isIp(String ip) {
        return p.matcher(ip).matches();
    }

    private static void loadConnectedDevices() {
        CliInternals.initDevices();
        DeviceManager.addDeviceListener();
        DeviceManager.loadDevices();
    }

    public static boolean selectDevice(String serial) {
        CliInternals.initDevices();
        return DeviceManager.onDeviceSelected((String)serial);
    }

    public static DAResult.ErrorCode selectApp(String appID) {
        DeviceInfo devInfo = Global.getCurrentDeviceInfo();
        if (devInfo == null) {
            Logger.warning((Object)("DA failed to set device for " + appID + " application"));
            return DAResult.ErrorCode.ERR_NO_DEVICE;
        }
        DACommunicator.updatePkgMapFromTarget();
        AppInfo appInfo = devInfo.getAppInfoByAppID(appID);
        if (appInfo == null) {
            Logger.warning((Object)("DA failed to set application " + appID));
            return DAResult.ErrorCode.ERR_NO_APP;
        }
        Global.setCurrentApplication((AppInfo)appInfo);
        List binPaths = appInfo.getProcessInformation();
        DAResult.ErrorCode code = appInfo.getBinaryInformation(binPaths);
        if (code != DAResult.ErrorCode.SUCCESS) {
            Logger.warning((Object)("DA is not able to trace application " + appID));
            return code;
        }
        return DAResult.ErrorCode.SUCCESS;
    }

    private static boolean selectFeatures(TracingArguments args) {
        UILayoutDataManager.INSTANCE.setSelectedChartSet(new HashSet());
        TargetData target = SettingDataManager.INSTANCE.getTarget(null);
        target.setSelectedFlatFeatures(new HashSet());
        CliInternals.selectScreenshotFeature(args.getScreenshotPeriod(), args.getScreenshotOnSceneTransition());
        args.getFeatures().remove(PrimitiveFeature.SCREENSHOT);
        for (PrimitiveFeature feature : args.getFeatures()) {
            target.addSelectedFlatFeature(feature.getName());
            UILayoutDataManager.INSTANCE.addSelectedChart(feature.getChart());
        }
        SettingDataManager.INSTANCE.setPreferenceSelected(FlatPreferences.LEAK_SANITIZER, args.getLSanPreference());
        return true;
    }

    private static void selectScreenshotFeature(int period, boolean onSceneTransition) {
        if (!onSceneTransition && period <= 0) {
            Logger.debug((Object)"Screenshots are not captured.");
            return;
        }
        TargetData target = SettingDataManager.INSTANCE.getTarget(null);
        target.addSelectedFlatFeature(ConfigureLabels.FEATURE_NAME_SCREENSHOT);
        if (onSceneTransition) {
            SettingDataManager.INSTANCE.setPreferenceValue(FlatPreferences.SCREENSHOT_ON_SCENE_TRANSITION, 1);
            Logger.debug((Object)"Screenshots are captured on scene transition.");
        } else {
            SettingDataManager.INSTANCE.deletePreference(FlatPreferences.SCREENSHOT_ON_SCENE_TRANSITION);
        }
        if (period > 0) {
            SettingDataManager.INSTANCE.setPreferenceValue(FlatPreferences.SCREENSHOT_PERIODICALLY, period);
            Logger.debug((Object)("Screenshots are captured every " + period + " sec."));
        } else {
            SettingDataManager.INSTANCE.deletePreference(FlatPreferences.SCREENSHOT_PERIODICALLY);
        }
        UILayoutDataManager.INSTANCE.addSelectedChart(TimelineChartLabels.SCREENSHOT_CHART_TITLE);
    }

    public static Map<String, PackageInfo> getPackageList(IDevice dev) {
        Map packages = DACommunicator.updatePkgMapFromTarget((DeviceInfo)new DeviceInfo(dev));
        if (packages == null) {
            return null;
        }
        packages.remove("da.id.dummy.app.running");
        packages.remove("da.id.dummy.app.systemwide");
        packages.remove("da.id.dummy.app.executable");
        return packages;
    }

    public static Map<String, AppInfo> getApplicationMap(IDevice dev) {
        DeviceInfo deviceInfo = new DeviceInfo(dev);
        DACommunicator.updatePkgMapFromTarget((DeviceInfo)deviceInfo);
        Map apps = deviceInfo.getAppInfoMap();
        if (apps == null) {
            return null;
        }
        apps.remove("da.id.dummy.app.running");
        apps.remove("da.id.dummy.app.systemwide");
        apps.remove("da.id.dummy.app.executable");
        return apps;
    }

    public static DAResult startTracingProcess(TracingArguments args) throws ConnectException {
        ProcessManagerMBean pmProxy = CliInternals.getPMProxyInstance();
        Logger.info((Object)(args.getApplicationID() + " is launching on target device."));
        Logger.info((Object)"It may take up to 60 seconds. Please wait.");
        return pmProxy.startTracing(args);
    }

    public static DAResult stopTracingProcess(String device) throws ConnectException {
        ProcessManagerMBean pmProxy = CliInternals.getPMProxyInstance();
        return pmProxy.stopTracing(device);
    }

    public static HumanReadableTimeFormat getTracingTime(String device) throws ConnectException {
        ProcessManagerMBean pmProxy = CliInternals.getPMProxyInstance();
        return pmProxy.getTracingTime(device);
    }

    public static TracingProcessContext getContext(String device) throws ConnectException {
        ProcessManagerMBean pmProxy = CliInternals.getPMProxyInstance();
        return pmProxy.getContext(device);
    }

    public static List<DeviceInfo> getCurrentlyTracingDevices() throws ConnectException {
        ProcessManagerMBean pmProxy = CliInternals.getPMProxyInstance();
        String[] tracingDevicesSerials = pmProxy.getTracedDevices();
        List<DeviceInfo> connectedDevices = CliInternals.getDevices();
        LinkedList<DeviceInfo> tracingDevices = new LinkedList<DeviceInfo>();
        block0: for (DeviceInfo devInfo : connectedDevices) {
            String conDevSerial = devInfo.getIDevice().getSerialNumber();
            for (String devSerial : tracingDevicesSerials) {
                if (!conDevSerial.equals(devSerial)) continue;
                tracingDevices.add(devInfo);
                continue block0;
            }
        }
        return tracingDevices;
    }

    public static DAResult.ErrorCode startTracing(TracingArguments args) {
        Logger.info((Object)"Starting tracing...");
        Logger.info((Object)"Create temp directory");
        PathManager.createDATempDir();
        CliInternals.initDevices();
        CliInternals.loadConnectedDevices();
        if (!CliInternals.selectDevice(args.getDevice())) {
            Logger.debug((Object)"Failed to select device");
            return DAResult.ErrorCode.ERR_NO_DEVICE;
        }
        Logger.debug((Object)("Set current device: " + args.getDevice()));
        DAResult.ErrorCode code = CliInternals.selectApp(args.getApplicationID());
        if (code != DAResult.ErrorCode.SUCCESS) {
            Logger.debug((Object)"Failed to select application");
            return code;
        }
        Logger.debug((Object)("Set current app: " + args.getApplicationID()));
        if (!CliInternals.selectFeatures(args)) {
            Logger.debug((Object)"Failed to select features");
            return DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED;
        }
        Logger.debug((Object)("Set features: " + Arrays.asList(args.getFeatures().toArray())));
        UIActionHolder.getUIAction().setUIElementsBySetting();
        CommonAction.configure();
        CommandAction.startTrace();
        Logger.debug((Object)"Tracing started");
        return DAResult.ErrorCode.SUCCESS;
    }

    public static void stopTracing() {
        CommandAction.stopTrace((DAResult)new DAResult(DAResult.ErrorCode.SUCCESS), (boolean)false);
        Logger.debug((Object)"Stopping tracing threads...");
    }

    public static boolean saveTrace(String file) {
        Logger.debug((Object)("Saving tracing results to " + file));
        return CommandAction.saveToZip((String)file);
    }

    public static boolean isApllicationInstalled(String appID, String device) {
        IDevice dev = CliInternals.isIp(device) ? CliInternals.getDeviceByIp(device) : CliInternals.getDeviceBySerial(device);
        Map<String, AppInfo> apps = CliInternals.getApplicationMap(dev);
        if (apps == null) {
            return false;
        }
        return apps.containsKey(appID);
    }

    static {
        Logger.init((int)4);
        Global.setCurrentUIMode((UIMode)UIMode.CLI);
        AnalyzerUtil.setPlatformSDK();
        String selectedTarget = SettingDataManager.INSTANCE.getConnectedTargetOrSelected().getTargetName();
        SettingDataManager.INSTANCE.setSelectedTarget(selectedTarget);
        PM_PROXY_INSTANCE = null;
    }
}

