/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.communicator;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.DeviceManager;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.control.ApplistManager;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.UserErrorWarningLabels;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingData;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.RpmUtil;
import org.tizen.dynamicanalyzer.workbench.SingletonFocusManager;

public class IDECommunicator
implements Runnable {
    private static final String IDE_DA_COMMUNICATION_TYPE_1 = "STATUS";
    private static final String IDE_DA_COMMUNICATION_TYPE_2 = "RUN";
    private static final String IDE_DA_COMMUNICATION_TYPE_3 = "SOURCE";
    private static final String IDE_DA_COMMUNICATION_TYPE_1_RECORD = "record";
    private static final String IDE_DA_COMMUNICATION_TYPE_1_STOP = "stop";
    private final String IDE_DA_COMMUNICATION_PROJECT_TYPE_NATIVE = "native";
    private final String IDE_DA_COMMUNICATION_PROJECT_TYPE_PLATFORM = "platform";
    private final String IDE_DA_COMMUNICATION_PROJECT_TYPE_WEB = "web";
    private static final int MSG_INDEX_DEVICE = 1;
    private static final int MSG_INDEX_PROJECT_TYPE = 2;
    private static final int MSG_INDEX_BINARY_OF_TARGET = 3;
    private static final int MSG_INDEX_EXECUTABLE_PATH = 4;
    private static final int MSG_INDEX_LOCAL_PACKAGE_PATH = 5;
    private static final int MSG_DEFAULT_LENGTH = 5;
    private static final String PROJECT_TYPE_OSP = "1";
    private static final String PROJECT_TYPE_EFL = "2";
    private static final String PROJECT_TYPE_WEBAPP = "3";
    private static final String PROJECT_TYPE_LIBRARY = "4";
    private static final int APPNAME_LENGTH = 20;
    private FileChannel fchannel = null;
    private static BufferedWriter writer = null;
    private static Thread instance;
    private static Boolean openWelcomeDlg;
    private static final Object waitingWelcomeDlg;
    private ServerSocket daServerSocket = null;
    private static Socket nativeIdeSocket;
    private static ArrayList<Socket> ideClientSocketArray;
    private int serverPort = 0;

    static {
        openWelcomeDlg = Boolean.FALSE;
        waitingWelcomeDlg = new Object();
        nativeIdeSocket = null;
        ideClientSocketArray = new ArrayList();
    }

    @Override
    public void run() {
        this.daServerSocket = this.setServePort();
        if (this.daServerSocket != null) {
            if (!this.savePortToFile()) {
                Logger.debug((Object)"failed Save Server port");
                this.errorMessageBox();
                return;
            }
            if (!this.setCheckFileLock()) {
                Logger.debug((Object)"failed socket File Lock");
                this.errorMessageBox();
                return;
            }
            try {
                while (true) {
                    Logger.debug((Object)("Waiting IDE Client : " + ideClientSocketArray.size()));
                    Socket clientSocket = this.daServerSocket.accept();
                    ideClientSocketArray.add(clientSocket);
                    Logger.debug((Object)("Connected IDE : " + ideClientSocketArray.size()));
                    Logger.debug((Object)("accept clientSocket : " + clientSocket.getPort()));
                    Thread acceptThread = this.createReceiveThread(clientSocket);
                    acceptThread.start();
                    Logger.debug((Object)"Start IDE AcceptThread");
                }
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
                this.errorMessageBox();
            }
        }
    }

    private Thread createReceiveThread(final Socket clientSocket) {
        return new Thread("IDEAcceptThread"){
            DataInputStream in;
            {
                super($anonymous0);
                this.in = null;
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        this.in = new DataInputStream(clientSocket.getInputStream());
                        Logger.debug((Object)("IDE recvMessage Wait : " + ideClientSocketArray.size()));
                        Logger.debug((Object)("thread clientSocket : " + clientSocket.getPort()));
                        String msg = this.in.readUTF();
                        Logger.debug((Object)msg);
                        IDECommunicator.this.parsingReceiveMessage(msg, clientSocket);
                    }
                }
                catch (IOException e) {
                    Logger.debug((Object)("Disconnected IDE : " + ideClientSocketArray.size()));
                    try {
                        clientSocket.close();
                    }
                    catch (IOException e1) {
                        Logger.exception((Throwable)e1);
                    }
                    ideClientSocketArray.remove(clientSocket);
                    Logger.exception((Throwable)e);
                    return;
                }
            }
        };
    }

    private void errorMessageBox() {
        UIActionHolder.getUIAction().showWarning(AnalyzerLabels.IDE_DA_COMMUNICATION_ERROR_MESSAGE);
    }

    public static synchronized void startIDECommunicatorThread() {
        if (instance == null || !instance.isAlive()) {
            instance = new Thread(null, new IDECommunicator(), "IDE Communicator thread");
            instance.start();
        }
    }

    public static void stopIDEcommunicatorThread() {
        if (instance != null && instance.isAlive()) {
            instance.interrupt();
        }
    }

    public static boolean isConnected() {
        return ideClientSocketArray.size() >= 1;
    }

    public static void sendCodeInfoToIDE(String path, String line) {
        if (nativeIdeSocket != null) {
            Logger.debug((Object)"Source Link : sending message to native ide");
            IDECommunicator.sendMessageToIDE(nativeIdeSocket, IDECommunicator.sendMessageString(IDE_DA_COMMUNICATION_TYPE_3, path, line));
        } else {
            Logger.debug((Object)"Source Link : native ide socket is null");
        }
    }

    public static boolean sendMessageToIDE(Socket clientSocket, String message) {
        try {
            if (clientSocket != null) {
                writer = new BufferedWriter(new OutputStreamWriter(clientSocket.getOutputStream()));
                writer.write(message);
                writer.flush();
            }
        }
        catch (IOException e) {
            Logger.exception((Throwable)e);
            return false;
        }
        return true;
    }

    private void parsingReceiveMessage(String msg, Socket clientSocket) {
        String[] strMsg = msg.split("`,");
        if (strMsg[0].equals(IDE_DA_COMMUNICATION_TYPE_1)) {
            if (strMsg[1].equals("native") || strMsg[1].equals("platform")) {
                nativeIdeSocket = clientSocket;
            }
            this.sendDAStatus(clientSocket);
        } else if (strMsg[0].equals(IDE_DA_COMMUNICATION_TYPE_2)) {
            if (this.isDAReadyStatus(clientSocket)) {
                this.autoStartApplication(strMsg);
            }
        } else {
            Logger.debug((Object)" wrong receive message ");
        }
    }

    private void sendDAStatus(Socket clientSocket) {
        if (this.isDAReadyStatus(clientSocket)) {
            IDECommunicator.sendMessageToIDE(clientSocket, IDECommunicator.sendMessageString(IDE_DA_COMMUNICATION_TYPE_1, IDE_DA_COMMUNICATION_TYPE_1_STOP, ""));
        } else {
            IDECommunicator.sendMessageToIDE(clientSocket, IDECommunicator.sendMessageString(IDE_DA_COMMUNICATION_TYPE_1, IDE_DA_COMMUNICATION_TYPE_1_RECORD, ""));
        }
    }

    private boolean isDAReadyStatus(Socket clientSocket) {
        if (!DAState.isStartable()) {
            IDECommunicator.sendMessageToIDE(clientSocket, IDECommunicator.sendMessageString(IDE_DA_COMMUNICATION_TYPE_1, IDE_DA_COMMUNICATION_TYPE_1_RECORD, ""));
            SingletonFocusManager.setFocusToDA();
            UIActionHolder.getUIAction().showWarning(AnalyzerLabels.RE_TRACE_FORM_IDE);
            return false;
        }
        return true;
    }

    private static String sendMessageString(String first, String second, String third) {
        StringBuffer sendMsg = new StringBuffer();
        sendMsg.append(first).append("`,").append(second).append("`,").append(third);
        return sendMsg.toString();
    }

    private String binarySettingWithRPM(String mainrpm, String debugrpm, String srcrpm) {
        if (mainrpm == null) {
            return String.valueOf(UserErrorWarningLabels.ERROR_LIBTRACE_START) + CommonConstants.NEW_LINE + UserErrorWarningLabels.ERROR_RPM_NOT_FOUND;
        }
        ArrayList<String> libfilelist = new ArrayList<String>();
        List<String> filelist = RpmUtil.getFileListInRpm(mainrpm);
        if (filelist != null) {
            int filecount = filelist.size();
            int i = 0;
            while (i < filecount) {
                int index;
                String filepath = filelist.get(i);
                String filename = filepath.substring((index = filepath.lastIndexOf("/")) + 1);
                if (filename.endsWith(".so") || filename.contains(".so.")) {
                    libfilelist.add(filepath);
                }
                ++i;
            }
        }
        if (libfilelist.size() == 0) {
            return String.valueOf(UserErrorWarningLabels.ERROR_LIBTRACE_START) + CommonConstants.NEW_LINE + UserErrorWarningLabels.ERROR_LIB_NOT_FOUND_INRPM;
        }
        Collections.sort(libfilelist);
        ArrayList<String> finallist = new ArrayList<String>();
        int size = libfilelist.size();
        String prev = (String)libfilelist.get(0);
        int i = 1;
        while (i < size) {
            if (!((String)libfilelist.get(i)).startsWith(prev)) {
                finallist.add(prev);
            }
            prev = (String)libfilelist.get(i);
            ++i;
        }
        finallist.add(prev);
        ArrayList<String> addBinPath = new ArrayList<String>();
        ArrayList<BinarySettingData> addBinData = new ArrayList<BinarySettingData>();
        for (String binPath : finallist) {
            BinarySettingData binaryData = new BinarySettingData();
            binaryData.setBinaryPath(binPath);
            if (debugrpm != null) {
                binaryData.setDebugRpmPath(debugrpm);
            }
            if (srcrpm != null) {
                binaryData.setSourceRpmPath(srcrpm);
            }
            addBinPath.add(binPath);
            addBinData.add(binaryData);
        }
        BinarySettingManager.getInstance().addBinarySettingData(addBinData);
        BinarySettingManager.getInstance().checkSourcePath(addBinData);
        DAResult result = new DAResult(DAResult.ErrorCode.ERR_BIN_INFO_GET_FAIL);
        try {
            result = DACommunicator.getBinaryInformation(addBinPath);
            DACommunicator.addInstrumentation(addBinPath);
        }
        catch (InterruptedException interruptedException) {
            Logger.warning((Object)"Sending message by communicator is interrupted");
            return String.valueOf(UserErrorWarningLabels.ERROR_LIBTRACE_START) + CommonConstants.NEW_LINE + UserErrorWarningLabels.ERROR_BY_UNKNOWN_REASON;
        }
        catch (UnsupportedProtocolException unsupportedProtocolException) {
            Logger.warning((Object)"Sending message is not supported by communicator");
            return String.valueOf(UserErrorWarningLabels.ERROR_LIBTRACE_START) + CommonConstants.NEW_LINE + UserErrorWarningLabels.ERROR_UNSUPPORTED_PROTOCOL;
        }
        if (!result.isSuccess()) {
            return result.getMessage();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void autoStartApplication(String[] strMsg) {
        block20: {
            block21: {
                block19: {
                    if (strMsg.length < 5) {
                        Logger.debug((Object)"wrong message format!!");
                        return;
                    }
                    Toolbar.INSTANCE.setAllControlState(false);
                    deviceName = new String(strMsg[1].trim());
                    projectType = new String(strMsg[2].trim());
                    binaryOfTarget = new String(strMsg[3].trim());
                    executablePath = new String(strMsg[4].trim());
                    localPackagePathList = new ArrayList<String>();
                    msgIndex = 5;
                    while (msgIndex < strMsg.length) {
                        if (AnalyzerUtil.isInteger(strMsg[msgIndex].trim())) break;
                        localPackagePathList.add(new String(strMsg[msgIndex].trim()));
                        ++msgIndex;
                    }
                    UIActionHolder.getUIAction().setPageBySetting();
                    Logger.debug((Object)("auto start : " + binaryOfTarget));
                    device = DeviceManager.getDeviceByName(deviceName);
                    Global.setCurrentDeviceInfo(device);
                    if (device == null) {
                        UIActionHolder.getUIAction().showWarning(UserErrorWarningLabels.ERROR_DEVICE_CONNECTION);
                        Toolbar.INSTANCE.setAllControlState(true);
                        return;
                    }
                    DACommunicator.updatePkgMapFromTarget();
                    appInfo = null;
                    if (!projectType.equals("1") && !projectType.equals("2") && !projectType.equals("3")) break block19;
                    appInfo = device.getAppInfoByAppID(binaryOfTarget);
                    if (appInfo == null) {
                        this.popupMessageWithAppname(binaryOfTarget, UserErrorWarningLabels.ERROR_NONEXIST_APPLICATION);
                        Toolbar.INSTANCE.setAllControlState(true);
                        return;
                    }
                    if (ApplistManager.isInBlackList(appInfo)) {
                        this.popupMessageWithAppname(binaryOfTarget, UserErrorWarningLabels.ERROR_UNSUPPORTED_APPLICATION);
                        Toolbar.INSTANCE.setAllControlState(true);
                        return;
                    }
                    if (localPackagePathList.size() > 0) {
                        appInfo.setLocalPackagePath(localPackagePathList);
                    }
                    break block20;
                }
                if (!projectType.equals("4")) break block21;
                if (localPackagePathList.size() == 0) {
                    Logger.error((Object)"rpm package for library is not set");
                    UIActionHolder.getUIAction().showWarning(String.valueOf(UserErrorWarningLabels.ERROR_LIBTRACE_START) + CommonConstants.NEW_LINE + UserErrorWarningLabels.ERROR_RPM_NOT_FOUND);
                    Toolbar.INSTANCE.setAllControlState(true);
                    return;
                }
                mainrpm = null;
                debugrpm = null;
                srcrpm = null;
                i = 0;
                while (i < localPackagePathList.size()) {
                    path = (String)localPackagePathList.get(i);
                    if (path.endsWith(".rpm")) {
                        if (path.contains("debuginfo")) {
                            debugrpm = path;
                        } else if (path.contains("debugsource")) {
                            srcrpm = path;
                        } else if (!path.contains("devel")) {
                            mainrpm = path;
                        }
                    }
                    ++i;
                }
                errormsg = this.binarySettingWithRPM(mainrpm, debugrpm, srcrpm);
                if (errormsg != null) {
                    Logger.error((Object)"error during binary setting wit rpm");
                    UIActionHolder.getUIAction().showWarning(errormsg);
                    Toolbar.INSTANCE.setAllControlState(true);
                    return;
                }
                if (!executablePath.contains("launch_app")) ** GOTO lbl85
                index = executablePath.indexOf("launch_app") + "launch_app".length() + 1;
                if (index < executablePath.length()) {
                    appID = executablePath.substring(index).trim();
                    appInfo = device.getAppInfoByAppID(appID);
                    if (appInfo == null) {
                        this.popupMessageWithAppname(appID, UserErrorWarningLabels.ERROR_NONEXIST_APPLICATION);
                        Toolbar.INSTANCE.setAllControlState(true);
                        return;
                    }
                } else {
                    Logger.error((Object)"there is no appid for library tracing");
                    UIActionHolder.getUIAction().showWarning(String.valueOf(UserErrorWarningLabels.ERROR_LIBTRACE_START) + CommonConstants.NEW_LINE + UserErrorWarningLabels.ERROR_NO_APPID_FOR_LAUNCHPAD);
                    Toolbar.INSTANCE.setAllControlState(true);
                    return;
lbl85:
                    // 1 sources

                    appInfo = device.getAppInfoByAppID("da.id.dummy.app.executable");
                    appInfo.setInfo(AppInfo.PROPERTY.EXEC.index, executablePath);
                }
                break block20;
            }
            this.popupMessageWithAppname(executablePath, UserErrorWarningLabels.ERROR_UNSUPPORTED_APPLICATION);
            Toolbar.INSTANCE.setAllControlState(true);
        }
        if (appInfo != null) {
            appID = appInfo.getAppID();
            Logger.debug((Object)("IDE recv - deviceName: " + deviceName + " appId : " + appID));
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (Toolbar.INSTANCE.setDevice(deviceName)) {
                        if (!Toolbar.INSTANCE.setApplicationByID(appID)) {
                            Logger.warning((Object)"Failed to set application to toolbar");
                        }
                    } else {
                        Logger.warning((Object)"Failed to set device to toolbar");
                    }
                }
            });
            SingletonFocusManager.setFocusToDA();
        }
        Toolbar.INSTANCE.setAllControlState(true);
    }

    private void popupMessageWithAppname(String appName, String postfix) {
        String name = appName;
        if (name.length() > 20) {
            name = String.valueOf(appName.substring(0, 19)) + "...";
        }
        UIActionHolder.getUIAction().showWarning(String.valueOf(name) + " " + postfix);
    }

    public static synchronized Boolean isOpenWelcomeDlg() {
        return openWelcomeDlg;
    }

    public static void setOpenWelcomeDlg(boolean data) {
        openWelcomeDlg = data ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object getWaitingWelcomeDlg() {
        return waitingWelcomeDlg;
    }

    private ServerSocket setServePort() {
        ServerSocket serverSocket = null;
        serverSocket = this.getServerSocket(0);
        if (serverSocket != null) {
            this.serverPort = serverSocket.getLocalPort();
            Logger.debug((Object)("IDE-DA Server port " + this.serverPort));
            return serverSocket;
        }
        Logger.debug((Object)"failed Set Serve Socket");
        return serverSocket;
    }

    private ServerSocket getServerSocket(int port) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            serverSocket = null;
            Logger.exception((Throwable)e);
        }
        return serverSocket;
    }

    public boolean savePortToFile() {
        boolean bSuccess;
        block6: {
            bSuccess = true;
            FileOutputStream fos = null;
            DataOutputStream dos = null;
            try {
                File file = new File(PathManager.IDE_ACTIVE_SAVE_PORT_PATH);
                fos = new FileOutputStream(file);
                dos = new DataOutputStream(fos);
                dos.writeInt(this.serverPort);
                dos.flush();
                bSuccess = true;
            }
            catch (FileNotFoundException e) {
                bSuccess = false;
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{fos, dos});
                break block6;
            }
            catch (IOException e) {
                try {
                    bSuccess = false;
                    Logger.exception((Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{fos, dos});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{fos, dos});
                break block6;
            }
            CommonUtil.tryClose((Object[])new Object[]{fos, dos});
        }
        return bSuccess;
    }

    public boolean setCheckFileLock() {
        File file = null;
        FileLock fileLock = null;
        boolean setFileLock = false;
        try {
            try {
                file = new File(PathManager.IDE_ACTIVE_PORT_PATH);
                this.fchannel = new RandomAccessFile(file, "rw").getChannel();
                fileLock = this.fchannel.tryLock();
            }
            catch (FileNotFoundException e1) {
                Logger.exception((Throwable)e1);
                this.errorMessageBox();
                setFileLock = fileLock != null;
                return false;
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
                this.errorMessageBox();
                setFileLock = fileLock != null;
            }
        }
        finally {
            setFileLock = fileLock != null;
        }
        return setFileLock;
    }
}

