/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.memory.HeapChartsSelectionListener;
import org.tizen.dynamicanalyzer.ui.memory.MemoryCallStackView;
import org.tizen.dynamicanalyzer.ui.memory.MemoryChartView;
import org.tizen.dynamicanalyzer.ui.memory.MemoryDetailsTableView;
import org.tizen.dynamicanalyzer.ui.memory.MemoryMapView;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPersistentAllocationsTableView;
import org.tizen.dynamicanalyzer.ui.memory.MemoryRangeAnalysisView;
import org.tizen.dynamicanalyzer.ui.memory.MemoryStatisticsTableView;
import org.tizen.dynamicanalyzer.ui.memory.PersistentAllocationsSelectionListener;
import org.tizen.dynamicanalyzer.ui.memory.StatisticsSelectionListener;
import org.tizen.dynamicanalyzer.ui.memory.StatisticsSortListener;
import org.tizen.dynamicanalyzer.ui.memory.chart.MemoryChartBoard;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryPersistentAllocationsTable;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryStatisticsTable;
import org.tizen.dynamicanalyzer.ui.page.MenuBar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DABaseDataPageComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;

public class MemoryPage
extends DABaseDataPageComposite {
    public static final String pageID = MemoryPage.class.getName();
    public static final String chartViewID = MemoryChartView.class.getName();
    public static final String detailsViewID = MemoryDetailsTableView.class.getName();
    public static final String mapViewID = MemoryMapView.class.getName();
    public static final String persistentAllocsViewID = String.valueOf(MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_TITLE) + "View";
    public static final String leaksViewID = String.valueOf(MemoryPageLabels.MEMORY_LEAKS_VIEW_TITLE) + "View";
    public static final String callstackViewID = MemoryCallStackView.class.getName();
    private DATabComposite memoryTabView = null;
    private DATabComposite memoryRightTabView = null;
    MemoryChartView memoryChartView;
    MemoryDetailsTableView memoryDetailsTableView;
    MemoryRangeAnalysisView memoryRangeAnalysisView;
    MemoryStatisticsTableView memoryStatisticsTableView;
    MemoryPersistentAllocationsTableView memoryPersistentAllocationsTableView;
    MemoryPersistentAllocationsTableView memoryLeaksTableView;
    MemoryMapView memoryMapView;
    MemoryCallStackView memoryCallStackView;

    public MemoryPage(Composite parent, int style) {
        super(parent, style);
        this.setTitle(AnalyzerLabels.COOLBAR_AREA_MEMORY);
        this.setData("tooltip", ShortCutManager.COOLBAR_AREA_MEMORY_TOOLTIP);
        this.setBackground(ColorResources.WHITE);
        this.setLayout((Layout)new FillLayout());
        this.memoryChartView = new MemoryChartView((Composite)this.topForm, 0);
        this.addView((DABaseComposite)this.memoryChartView);
        this.memoryTabView = new DATabComposite((Composite)this.bottomLeftForm, 0, false, true);
        this.memoryTabView.setID(AnalyzerLabels.LEFT_TABLE_VIEW_ID);
        this.memoryDetailsTableView = new MemoryDetailsTableView(this.memoryTabView.getContentComposite(), 0);
        this.memoryTabView.addView((DABaseComposite)this.memoryDetailsTableView, false);
        this.memoryRangeAnalysisView = new MemoryRangeAnalysisView(this.memoryTabView.getContentComposite(), 0);
        this.memoryTabView.addView((DABaseComposite)this.memoryRangeAnalysisView, true);
        this.memoryStatisticsTableView = new MemoryStatisticsTableView(this.memoryTabView.getContentComposite(), 0);
        this.memoryTabView.addView((DABaseComposite)this.memoryStatisticsTableView, false);
        PersistentAllocationsSelectionListener persistentAllocsListener = new PersistentAllocationsSelectionListener(this);
        this.memoryPersistentAllocationsTableView = new MemoryPersistentAllocationsTableView(this.memoryTabView.getContentComposite(), 0, false);
        ((MemoryPersistentAllocationsTable)this.memoryPersistentAllocationsTableView.getControl()).getTable().addSelectionListener((SelectionListener)persistentAllocsListener);
        this.showView(this.memoryTabView, (DABaseComposite)this.memoryPersistentAllocationsTableView, MenuBar.getInstance().getPersistentAllocationsSelection());
        this.memoryLeaksTableView = new MemoryPersistentAllocationsTableView(this.memoryTabView.getContentComposite(), 0, true);
        ((MemoryPersistentAllocationsTable)this.memoryLeaksTableView.getControl()).getTable().addSelectionListener((SelectionListener)persistentAllocsListener);
        this.showView(this.memoryTabView, (DABaseComposite)this.memoryLeaksTableView, SettingDataManager.INSTANCE.isPreferenceSelected(FlatPreferences.LEAK_SANITIZER));
        this.addView((DABaseComposite)this.memoryTabView);
        this.memoryRightTabView = new DATabComposite((Composite)this.bottomRightForm, 0, false, true);
        this.memoryRightTabView.setID(AnalyzerLabels.RIGHT_TABLE_VIEW_ID);
        this.memoryMapView = new MemoryMapView(this.memoryRightTabView.getContentComposite(), 0);
        this.memoryRightTabView.addView((DABaseComposite)this.memoryMapView, false);
        this.memoryCallStackView = new MemoryCallStackView(this.memoryRightTabView.getContentComposite(), 0);
        this.showView(this.memoryRightTabView, (DABaseComposite)this.memoryCallStackView, MenuBar.getInstance().getPersistentAllocationsSelection() || SettingDataManager.INSTANCE.isPreferenceSelected(FlatPreferences.LEAK_SANITIZER));
        this.addView((DABaseComposite)this.memoryRightTabView);
        MemoryChartBoard chartBoard = (MemoryChartBoard)this.memoryChartView.getChartBoard();
        Grid statisticsGrid = ((MemoryStatisticsTable)this.memoryStatisticsTableView.getControl()).getTable();
        MemoryStatisticsTable statisticsTable = (MemoryStatisticsTable)this.memoryStatisticsTableView.getControl();
        chartBoard.addSelectionListener(new HeapChartsSelectionListener(statisticsGrid));
        StatisticsSelectionListener statisticsSelectionListener = new StatisticsSelectionListener(chartBoard);
        StatisticsSortListener statisticsSortListener = new StatisticsSortListener(chartBoard);
        statisticsGrid.addSelectionListener((SelectionListener)statisticsSelectionListener);
        statisticsTable.addListener(1001, statisticsSortListener);
        this.memoryRangeAnalysisView.setStatisticsSelectionListener(statisticsSelectionListener);
        this.memoryRangeAnalysisView.setStatisticsSortListener(statisticsSortListener);
    }

    private void showView(DATabComposite tab, DABaseComposite view, boolean show) {
        if (show) {
            tab.addView(view);
        } else {
            tab.removeView(view.getID(), false);
        }
        this.resizeTableButton();
    }

    public void showPersistentAllocationsView(boolean show) {
        this.showView(this.memoryTabView, (DABaseComposite)this.memoryPersistentAllocationsTableView, show);
        this.showView(this.memoryRightTabView, (DABaseComposite)this.memoryCallStackView, MenuBar.getInstance().getPersistentAllocationsSelection() || SettingDataManager.INSTANCE.isPreferenceSelected(FlatPreferences.LEAK_SANITIZER));
        if (!show) {
            this.memoryPersistentAllocationsTableView.hide();
        }
    }

    public void showLeaksView(boolean show) {
        this.showView(this.memoryTabView, (DABaseComposite)this.memoryLeaksTableView, show);
        this.showView(this.memoryRightTabView, (DABaseComposite)this.memoryCallStackView, MenuBar.getInstance().getPersistentAllocationsSelection() || SettingDataManager.INSTANCE.isPreferenceSelected(FlatPreferences.LEAK_SANITIZER));
        if (!show) {
            this.memoryLeaksTableView.hide();
        }
    }

    public void clear() {
        super.clear();
    }
}

