/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.ui.memory.data.LsanDataManager;
import org.tizen.dynamicanalyzer.ui.memory.data.MemAllocDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.util.PersistentAllocationsQuerySerializer;
import org.tizen.dynamicanalyzer.ui.memory.data.util.Query;
import org.tizen.dynamicanalyzer.ui.memory.data.util.QuerySerializer;
import org.tizen.dynamicanalyzer.ui.memory.data.util.StatisticsQuerySerializer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;

public class HeapDataProcessor {
    private static HeapDataProcessor instance = new HeapDataProcessor();
    private static final int TOTAL_PID = -1;
    private static final int MAX_LIBRARIES_PER_PID = 500;
    private PersistentAllocationsQuerySerializer persistentSerializer = new PersistentAllocationsQuerySerializer();
    private StatisticsQuerySerializer statisticsSerializer = new StatisticsQuerySerializer();
    private Query lastCachedLeaksQuery = null;
    private Query lastCachedPersistentQuery = null;
    private Query lastCachedStatisticsQuery = null;
    private List<List<Object>> leaksCacheData = null;
    private List<List<Object>> persistentCacheData = null;
    private Map<Integer, Map<Integer, List<Object>>> statisticsCacheData = null;

    public static HeapDataProcessor getInstance() {
        return instance;
    }

    public List<TableInput> getTableInputPersistentAllocsData(Query query) {
        List<List<Object>> allocDataList = null;
        ArrayList<TableInput> output = new ArrayList<TableInput>();
        allocDataList = this.remainedAllocatedListForRange(query);
        if (allocDataList == null || allocDataList.size() == 0) {
            return output;
        }
        int index = 0;
        int j = 0;
        while (j < allocDataList.size()) {
            List<Object> iAllocData = allocDataList.get(j);
            TableInput input = this.makePersistentAllocsTableInput(iAllocData, index++, query.onlyLeaks);
            if (input != null) {
                output.add(input);
            }
            ++j;
        }
        return output;
    }

    public List<TreeInput> getTreeInputStatisticsData(Query query) {
        Map<Integer, Map<Integer, List<Object>>> staticdatas = this.remainedAllocStaticData(query);
        int index = 0;
        ArrayList<TreeInput> output = new ArrayList<TreeInput>();
        for (Map.Entry<Integer, Map<Integer, List<Object>>> elem : staticdatas.entrySet()) {
            long allocCountForPid = 0L;
            long freeCountForPid = 0L;
            long persistentCountForPid = 0L;
            long totalSizeForPid = 0L;
            long persistentSizeForPid = 0L;
            ArrayList<TreeInput> children = new ArrayList<TreeInput>();
            index = elem.getKey() == -1 ? 0 : elem.getKey() * 500;
            int parentIndex = index++;
            for (Map.Entry<Integer, List<Object>> libEntry : elem.getValue().entrySet()) {
                String apiName = Global.getLibraryName(libEntry.getKey());
                TreeInput staticInput = this.makeTreeInputForStatistics(apiName, false, libEntry.getValue(), index++);
                if (staticInput == null) continue;
                children.add(staticInput);
                allocCountForPid += ((Long)libEntry.getValue().get(0)).longValue();
                freeCountForPid += ((Long)libEntry.getValue().get(1)).longValue();
                persistentCountForPid += ((Long)libEntry.getValue().get(2)).longValue();
                totalSizeForPid += ((Long)libEntry.getValue().get(3)).longValue();
                persistentSizeForPid += ((Long)libEntry.getValue().get(4)).longValue();
            }
            ArrayList<Object> total = new ArrayList<Object>();
            total.add(allocCountForPid);
            total.add(freeCountForPid);
            total.add(persistentCountForPid);
            total.add(totalSizeForPid);
            total.add(persistentSizeForPid);
            TreeInput parent = elem.getKey() == -1 ? this.makeTreeInputForStatistics("Total", false, total, parentIndex) : this.makeTreeInputForStatistics(elem.getKey().toString(), true, total, parentIndex);
            if (parent == null) continue;
            parent.getChildren().addAll(children);
            output.add(parent);
        }
        return output;
    }

    private Map<Integer, Map<Integer, List<Object>>> remainedAllocStaticData(Query query) {
        if (query.equals(this.lastCachedStatisticsQuery)) {
            return this.statisticsCacheData;
        }
        this.lastCachedStatisticsQuery = query;
        this.statisticsCacheData = this.makeRemainedAllocatedStatic(this.executeQuery(this.statisticsSerializer, query));
        return this.statisticsCacheData;
    }

    public List<List<Object>> remainedAllocatedListForRange(Query query) {
        if (query.onlyLeaks) {
            if (query.equals(this.lastCachedLeaksQuery)) {
                return this.leaksCacheData;
            }
            this.lastCachedLeaksQuery = query;
            this.leaksCacheData = this.executeQuery(this.persistentSerializer, query);
            return this.leaksCacheData;
        }
        if (query.equals(this.lastCachedPersistentQuery)) {
            return this.persistentCacheData;
        }
        this.lastCachedPersistentQuery = query;
        this.persistentCacheData = this.executeQuery(this.persistentSerializer, query);
        return this.persistentCacheData;
    }

    private List<List<Object>> executeQuery(QuerySerializer serializer, Query query) {
        List<List<Object>> result = SqlConnectionManager.executeQuery(serializer.toSqlString(query));
        return result != null ? result : Collections.emptyList();
    }

    private Map<Integer, Map<Integer, List<Object>>> makeRemainedAllocatedStatic(List<List<Object>> statisticsData) {
        HashMap<Integer, Map<Integer, List<Object>>> pidStatisticMap = new HashMap<Integer, Map<Integer, List<Object>>>();
        HashMap libStatisticMapTotal = new HashMap();
        pidStatisticMap.put(-1, libStatisticMapTotal);
        for (List<Object> row : statisticsData) {
            if (row == null || row.size() != 7) continue;
            int pid = (Integer)row.get(0);
            int binaryId = (Integer)row.get(1);
            ArrayList<Long> tableData = new ArrayList<Long>();
            tableData.add((Long)row.get(2));
            tableData.add((Long)row.get(3));
            tableData.add((Long)row.get(4));
            tableData.add((Long)row.get(5));
            tableData.add((Long)row.get(6));
            if (!pidStatisticMap.containsKey(pid)) {
                pidStatisticMap.put(pid, new HashMap());
            }
            ((Map)pidStatisticMap.get(pid)).put(binaryId, tableData);
            libStatisticMapTotal.put(binaryId, tableData);
        }
        return pidStatisticMap;
    }

    private String getDisplayedEntryName(String apiName, boolean isProcess) {
        if (isProcess) {
            return "PID #" + apiName;
        }
        if (apiName.equals(Global.getProject().getApplicationInfo().getExecPath())) {
            return MemoryPageLabels.MEMORY_MAIN_EXCUTABLE;
        }
        return apiName;
    }

    private TreeInput makeTreeInputForStatistics(String apiName, boolean isProcess, List<Object> statisticsData, int index) {
        DATableDataFormat tableData = new DATableDataFormat(index);
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        if (statisticsData == null) {
            Logger.error((String)"No statistics data for '%d' entry!", (Object[])new Object[]{apiName});
            return null;
        }
        String entryName = this.getDisplayedEntryName(apiName, isProcess);
        Long TotalCount = (Long)statisticsData.get(0);
        Long FCount = (Long)statisticsData.get(1);
        Long PCount = (Long)statisticsData.get(2);
        Long TotalByte = (Long)statisticsData.get(3);
        Long PByte = (Long)statisticsData.get(4);
        text.add(entryName);
        data.add(apiName);
        text.add(String.format("%,d", TotalCount));
        data.add(TotalCount);
        text.add(String.format("%,d", FCount));
        data.add(FCount);
        text.add(String.format("%,d", PCount));
        data.add(PCount);
        text.add(Formatter.toByteFormat(TotalByte));
        data.add(TotalByte);
        text.add(Formatter.toByteFormat(PByte));
        data.add(PByte);
        tableData.getData().addAll(data);
        tableData.setObject(entryName);
        TreeInput output = new TreeInput();
        output.setText(text);
        output.setData(tableData);
        return output;
    }

    public TableInput makePersistentAllocsTableInput(List<Object> allocData, int index, boolean onlyLeaks) {
        Project project;
        boolean isMainBinary;
        DATableDataFormat tableData = new DATableDataFormat(index);
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        if (allocData == null) {
            Logger.error((Object)"very strange case !!");
            return null;
        }
        Long seq = (Long)allocData.get(MemAllocDBTable.BASIC_COLUMN.SEQUENCE_NUMBER.index);
        text.add(Long.toString(seq));
        data.add(seq);
        long time = (Long)allocData.get(MemAllocDBTable.BASIC_COLUMN.ALLOCATED_TIME.index);
        data.add(time);
        try {
            text.add(Formatter.toTimeFormat(time));
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
            text.add(Long.toString(time));
        }
        int pid = (Integer)allocData.get(MemAllocDBTable.BASIC_COLUMN.PID.index);
        text.add(Integer.toString(pid));
        data.add(pid);
        int tid = (Integer)allocData.get(MemAllocDBTable.BASIC_COLUMN.TID.index);
        text.add(Integer.toString(tid));
        data.add(tid);
        Long address = (Long)allocData.get(MemAllocDBTable.BASIC_COLUMN.ALLOCATED_ADDRESS.index);
        text.add("0x" + Long.toHexString(address));
        data.add(address);
        Long size = (Long)allocData.get(MemAllocDBTable.BASIC_COLUMN.ALLOCATED_MEMORY_SIZE.index);
        text.add(Long.toString(size));
        data.add(size);
        String libName = Global.getLibraryName((Integer)allocData.get(MemAllocDBTable.BASIC_COLUMN.CALLER_LIBRARY_ID.index));
        if (libName == null || libName.isEmpty()) {
            libName = "unknown";
        }
        boolean bl = isMainBinary = (project = Global.getProject()) != null && project.getApplicationInfo() != null && project.getApplicationInfo().getExecBinaryPath().equals(libName);
        if (onlyLeaks && !isMainBinary) {
            return null;
        }
        text.add(libName);
        data.add(libName);
        int apiId = (Integer)allocData.get(MemAllocDBTable.BASIC_COLUMN.API_ID.index);
        String apiName = Global.getFunctionName(apiId);
        text.add(apiName);
        data.add(apiName);
        if (!onlyLeaks) {
            boolean leak = false;
            if (isMainBinary && SettingDataManager.INSTANCE.isPreferenceSelected(FlatPreferences.LEAK_SANITIZER)) {
                leak = LsanDataManager.getInstance().getLeaksMap().containsKey(address);
            }
            text.add(leak ? "Yes" : "");
            data.add(leak ? "Yes" : "");
        }
        tableData.setType(4099);
        TreeInput output = new TreeInput();
        output.setText(text);
        tableData.getData().addAll(data);
        output.setData(tableData);
        return output;
    }
}

