/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.chart;

import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.ui.common.TimeLineChartKeyListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.chart.GLChartBoard;
import org.tizen.dynamicanalyzer.ui.opengl.chart.GLFrameTimeChart;
import org.tizen.dynamicanalyzer.ui.opengl.chart.listener.GLFrameTimeBoundMouseListener;
import org.tizen.dynamicanalyzer.ui.opengl.chart.listener.GLFrameTimeMouseListener;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class GLFrameTimeChartBoard
extends GLChartBoard {
    public GLFrameTimeChartBoard(Composite parent, String title, int boardStyle) {
        super(parent, title, boardStyle);
    }

    public void updateView() {
        long totalEndTime = (long)GLDataManager.getInstance().getFrameSize() * 1000000L;
        if (AnalyzerUtil.isLatestTraceMode(GLPage.pageID)) {
            this.updateVisibleStartTime();
            this.setTotalEndTime(totalEndTime, true);
        } else {
            this.setTotalEndTime(totalEndTime, false);
        }
        this.updateViewFromDBData();
    }

    public void initializeCharts() {
        this.initIntervalMarkers();
        GLFrameTimeChart frameTimeChart = GLFrameTimeChart.getInstance();
        DAChartBoardItem frameTimeChartItem = frameTimeChart.createBoardItem(this);
        DAChart frameTimeChartWidget = frameTimeChartItem.getChart();
        GLFrameTimeMouseListener glFrameChartMouseEventListener = new GLFrameTimeMouseListener(frameTimeChart.getPopupMenu(), this.getTimeline());
        frameTimeChartWidget.getPlot().setMarkers(this.getMarkers());
        frameTimeChartWidget.addMouseListener((MouseListener)glFrameChartMouseEventListener);
        frameTimeChartWidget.addMouseMoveListener((MouseMoveListener)glFrameChartMouseEventListener);
        frameTimeChartWidget.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.getTimeline()));
        GLFrameTimeBoundMouseListener upperBoundLineEventListener = new GLFrameTimeBoundMouseListener(frameTimeChartWidget, DAChartPlot.BoundType.UPPER);
        frameTimeChartWidget.addMouseListener((MouseListener)upperBoundLineEventListener);
        frameTimeChartWidget.addMouseMoveListener((MouseMoveListener)upperBoundLineEventListener);
        frameTimeChartWidget.addMouseTrackListener((MouseTrackListener)upperBoundLineEventListener);
        TimeLineChartKeyListener timelineKeyListener = new TimeLineChartKeyListener(this);
        frameTimeChartWidget.addKeyListener((KeyListener)timelineKeyListener);
    }

    @Override
    protected void updateViewFromDBData() {
        GLFrameTimeChart.getInstance().updateView(this.getVisibleStartTime(), this.getVisibleEndTime());
    }
}

