/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.chart;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.model.data.LogDataFactory;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.thread.ThreadPage;
import org.tizen.dynamicanalyzer.ui.thread.chart.SyncChartBoard;
import org.tizen.dynamicanalyzer.ui.thread.chart.ThreadChartBoard;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageThreadData;
import org.tizen.dynamicanalyzer.ui.timeline.logparser.LifecycleLogParser;
import org.tizen.dynamicanalyzer.ui.toolbar.DAToolBarCustomCombo;
import org.tizen.dynamicanalyzer.ui.toolbar.ToolBarComboListener;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardSelectionListener;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomCombo;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleSelectionListener;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;

public class ThreadChartView
extends DAViewComposite {
    public static final String ID = ThreadChartView.class.getName();
    public static final int THREAD_CHART_HEIGHT = 64;
    private final Composite contents;
    private ThreadChartBoard threadChartBoard;
    private SyncChartBoard syncChartBoard;
    private DACustomCombo threadCombo;
    private DACustomCombo syncCombo;
    private final StackLayout stackLayout;
    private DAToolBarCustomCombo threadProcessCombo;
    private DAToolBarCustomCombo syncProcessCombo;

    public ThreadChartView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        AnalyzerUtil.setLatestTraceMode(ThreadPage.pageID, true);
        this.setTitle(ThreadPageLabels.THREAD_CHART_TITLE);
        this.contents = this.getContentArea();
        this.contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        this.stackLayout = new StackLayout();
        this.contents.setLayout((Layout)this.stackLayout);
        this.initThreadChart();
        this.initSyncChart();
        this.stackLayout.topControl = this.threadChartBoard;
        this.syncChartBoard.setSelectable(true);
        this.threadChartBoard.setSelectable(true);
        this.initializeCharts();
        this.threadChartBoard.getTitleComp().setLayout((Layout)new FormLayout());
        this.syncChartBoard.getTitleComp().setLayout((Layout)new FormLayout());
        this.threadProcessCombo = this.makeDACustomCombo(this.threadChartBoard.getTitleComp());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.width = 192;
        data.height = 25;
        this.threadProcessCombo.setLayoutData(data);
        this.syncProcessCombo = this.makeDACustomCombo(this.syncChartBoard.getTitleComp());
        this.syncProcessCombo.setLayoutData(data);
        this.initProcessCombo(this.threadProcessCombo);
        this.initProcessCombo(this.syncProcessCombo);
        this.updateScale();
        this.threadChartBoard.getScale().addSelectionListener(new DAScaleSelectionListener(){

            public void widgetSelected() {
                Toolbar.INSTANCE.setScaleSelection(ThreadChartView.this.threadChartBoard.getScale().getSelection());
                ThreadChartView.this.updateScale();
            }
        });
        this.threadChartBoard.getListComposite().addListener(37, new Listener(){

            public void handleEvent(Event event) {
                Toolbar.INSTANCE.setScaleSelection(ThreadChartView.this.threadChartBoard.getScale().getSelection());
            }
        });
        this.syncChartBoard.getScale().addSelectionListener(new DAScaleSelectionListener(){

            public void widgetSelected() {
                Toolbar.INSTANCE.setScaleSelection(ThreadChartView.this.syncChartBoard.getScale().getSelection());
                ThreadChartView.this.updateScale();
            }
        });
        this.syncChartBoard.getListComposite().addListener(37, new Listener(){

            public void handleEvent(Event event) {
                Toolbar.INSTANCE.setScaleSelection(ThreadChartView.this.syncChartBoard.getScale().getSelection());
            }
        });
    }

    private DAToolBarCustomCombo makeDACustomCombo(Composite parent) {
        int PROCESS_COMBO = 2;
        DAToolBarCustomCombo returnCombo = new DAToolBarCustomCombo(parent, 0);
        returnCombo.setComboGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setOutlineColors(ColorResources.GRAY_170, ColorResources.GRAY_170, ColorResources.GRAY_170, ColorResources.GRAY_170);
        returnCombo.setComboImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        returnCombo.setComboImagePoint(new Point(160, 9));
        returnCombo.setComboButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        returnCombo.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        returnCombo.setFontPoint(new Point(5, 5));
        returnCombo.setEnabled(true);
        returnCombo.setComboFont(FontResources.COMBO);
        returnCombo.setItemFont(FontResources.DROPDOWN);
        returnCombo.setFontColors(ColorResources.BLACK, ColorResources.BLACK, ColorResources.BLACK, ColorResources.GRAY_170);
        returnCombo.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        returnCombo.setDeviceCombo(PROCESS_COMBO);
        return returnCombo;
    }

    public void initProcessCombo(final DAToolBarCustomCombo combo) {
        combo.initCombo();
        combo.add("All Processes");
        combo.select(0);
        combo.addSelectionListener(new ToolBarComboListener(){

            @Override
            public void selectionEvent(DAToolBarCustomCombo combo) {
                int i = 0;
                while (i < Toolbar.INSTANCE.getProcessCombo().getItems().size()) {
                    if (combo.getText().equals(Toolbar.INSTANCE.getProcessCombo().getItem(i))) {
                        Toolbar.INSTANCE.getProcessCombo().select(i);
                    }
                    ++i;
                }
                BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                baseView.getTopComposite().updateView();
            }
        });
        combo.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Project project = Global.getProject();
                if (project == null) {
                    return;
                }
                combo.initCombo();
                combo.add("All Processes");
                Toolbar.INSTANCE.getProcessCombo().initCombo();
                Toolbar.INSTANCE.getProcessCombo().add("All Processes");
                int[] pids = project.getProcessIDs();
                int pcount = pids.length;
                int i = 0;
                while (i < pcount) {
                    ProcessMemoryMap map;
                    ProcessInformation process = project.getProcessInformation(pids[i]);
                    String binName = process.getProcessName();
                    if ((binName == null || binName.isEmpty()) && (map = process.getLastProcessMemoryMap()) != null) {
                        int bid = map.getMainbinary().getBinaryID();
                        String binPath = project.getDeviceStatusInfo().getBinaryInfo(bid).getTargetBinaryPath();
                        if (binPath != null && !binPath.isEmpty()) {
                            int index = binPath.lastIndexOf("/");
                            binName = binPath.substring(index + 1, binPath.length());
                        }
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(process.getPid()).append(" : ");
                    buffer.append(binName);
                    combo.add(buffer.toString());
                    Toolbar.INSTANCE.getProcessCombo().add(buffer.toString());
                    ++i;
                }
            }
        });
    }

    private void updateScale() {
        int scaleSelection = Toolbar.INSTANCE.getScaleSelection();
        this.threadChartBoard.getBoardManager().scaleChanged(scaleSelection);
        this.threadChartBoard.setScaleVal(scaleSelection);
        this.syncChartBoard.getBoardManager().scaleChanged(scaleSelection);
        this.syncChartBoard.setScaleVal(scaleSelection);
    }

    private void initSyncChart() {
        this.syncChartBoard = new SyncChartBoard(this.contents, ThreadPageLabels.THREAD_CHART_SYNC, 0);
        this.syncChartBoard.setNameFont(FontResources.CHART_NAME_FONT);
        this.syncChartBoard.addSelectionListener(new DAChartBoardSelectionListener(){

            public void handleSelectionEvent(DAChartBoardItem item) {
                ThreadChartView.this.callUpdatePage(item);
            }
        });
        ScrollBar hScrollBar = this.syncChartBoard.getHScrollBar();
        hScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ThreadChartView.this.syncChartBoard.isMaximumScrolled()) {
                    AnalyzerUtil.setLatestTraceMode(ThreadPage.pageID, true);
                } else {
                    AnalyzerUtil.setLatestTraceMode(ThreadPage.pageID, false);
                }
            }
        });
    }

    private void initThreadChart() {
        this.threadChartBoard = new ThreadChartBoard(this.contents, ThreadPageLabels.THREAD_CHART_THREAD, 0);
        this.threadChartBoard.setNameFont(FontResources.CHART_NAME_FONT);
        this.threadChartBoard.addSelectionListener(new DAChartBoardSelectionListener(){

            public void handleSelectionEvent(DAChartBoardItem item) {
                ThreadChartView.this.callUpdatePage(item);
            }
        });
        ScrollBar hScrollBar = this.threadChartBoard.getHScrollBar();
        hScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ThreadChartView.this.threadChartBoard.isMaximumScrolled()) {
                    AnalyzerUtil.setLatestTraceMode(ThreadPage.pageID, true);
                } else {
                    AnalyzerUtil.setLatestTraceMode(ThreadPage.pageID, false);
                }
            }
        });
    }

    public void callUpdatePage(DAChartBoardItem selectItem) {
        if (selectItem == null) {
            AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(ThreadPage.chartViewID, (long)(((DAChartPlotIntervalMarker)this.threadChartBoard.getMarkers().get(0)).getStartVal() * 1000000.0), (long)(((DAChartPlotIntervalMarker)this.threadChartBoard.getMarkers().get(0)).getEndVal() * 1000000.0), new Integer(0), null));
        } else {
            AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(ThreadPage.chartViewID, (long)(((DAChartPlotIntervalMarker)this.threadChartBoard.getMarkers().get(0)).getStartVal() * 1000000.0), (long)(((DAChartPlotIntervalMarker)this.threadChartBoard.getMarkers().get(0)).getEndVal() * 1000000.0), selectItem.getData(), null));
        }
    }

    private void changeComboThreadToSync() {
        this.stackLayout.topControl = this.syncChartBoard;
        this.syncCombo.setText(ThreadPageLabels.THREAD_CHART_SYNC);
        this.syncChartBoard.setScaleVal(this.threadChartBoard.getScaleVal());
        this.syncChartBoard.setVisibleStart(this.threadChartBoard.getVisibleStart());
        this.syncChartBoard.setItemsHeightMode(this.threadChartBoard.isItemMinimized());
        this.contents.layout();
        this.updateView();
    }

    private void changeComboSyncToThread() {
        this.stackLayout.topControl = this.threadChartBoard;
        this.threadCombo.setText(ThreadPageLabels.THREAD_CHART_THREAD);
        this.threadChartBoard.setScaleVal(this.syncChartBoard.getScaleVal());
        this.threadChartBoard.setVisibleStart(this.syncChartBoard.getVisibleStart());
        this.threadChartBoard.setItemsHeightMode(this.syncChartBoard.isItemMinimized());
        this.contents.layout();
        this.updateView();
    }

    private void changeBoardThreadToSync() {
        this.stackLayout.topControl = this.syncChartBoard;
        this.syncChartBoard.setScaleVal(this.threadChartBoard.getScaleVal());
        this.syncChartBoard.setVisibleStart(this.threadChartBoard.getVisibleStart());
        this.syncChartBoard.setItemsHeightMode(this.threadChartBoard.isItemMinimized());
        this.contents.layout();
        this.updateView();
    }

    private void changeBoardSyncToThread() {
        this.stackLayout.topControl = this.threadChartBoard;
        this.threadChartBoard.setScaleVal(this.syncChartBoard.getScaleVal());
        this.threadChartBoard.setVisibleStart(this.syncChartBoard.getVisibleStart());
        this.threadChartBoard.setItemsHeightMode(this.syncChartBoard.isItemMinimized());
        this.contents.layout();
        this.updateView();
    }

    private void updateProcessCombo() {
        int index = Toolbar.INSTANCE.getProcessCombo().getSelectionIndex();
        if (index + 1 > this.threadProcessCombo.getItems().size()) {
            this.addProcessListToProcessCombo();
        }
        this.threadProcessCombo.select(index);
    }

    private void addProcessListToProcessCombo() {
        Project project = Global.getProject();
        if (project == null) {
            return;
        }
        int[] pids = project.getProcessIDs();
        int pcount = pids.length;
        int i = 0;
        while (i < pcount) {
            ProcessMemoryMap map;
            ProcessInformation process = project.getProcessInformation(pids[i]);
            String binName = process.getProcessName();
            if ((binName == null || binName.isEmpty()) && (map = process.getLastProcessMemoryMap()) != null) {
                int bid = map.getMainbinary().getBinaryID();
                String binPath = project.getDeviceStatusInfo().getBinaryInfo(bid).getTargetBinaryPath();
                if (binPath != null && !binPath.isEmpty()) {
                    int index = binPath.lastIndexOf("/");
                    binName = binPath.substring(index + 1, binPath.length());
                }
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(process.getPid()).append(" : ");
            buffer.append(binName);
            this.threadProcessCombo.add(buffer.toString());
            Toolbar.INSTANCE.getProcessCombo().add(buffer.toString());
            ++i;
        }
    }

    public void updateView() {
        this.updateScale();
        this.updateProcessCombo();
        if (this.stackLayout.topControl == this.syncChartBoard) {
            this.updateTimeLine(this.syncChartBoard);
            this.syncChartBoard.updateChart();
        } else {
            this.updateTimeLine(this.threadChartBoard);
            this.threadChartBoard.updateChart();
        }
    }

    private void updateTimeLine(DAChartBoard chartBoard) {
        if (AnalyzerUtil.isLatestTraceMode(ThreadPage.pageID)) {
            chartBoard.updateVisibleStartTime();
            chartBoard.setTotalEndTime(Toolbar.INSTANCE.getTime(), true);
        } else {
            chartBoard.setTotalEndTime(Toolbar.INSTANCE.getTime(), false);
        }
    }

    public void updateView(DAViewData data) {
        this.updateScale();
        this.updateProcessCombo();
        if (!(data instanceof DASelectionData)) {
            return;
        }
        DASelectionData selData = (DASelectionData)data;
        if (selData.isLogData()) {
            this.selectionFromSummary(selData);
        } else {
            this.selectionFromAPITable(selData);
        }
    }

    private void selectionFromSummary(DASelectionData selData) {
        Object odata = selData.getData();
        String category = LogDataFactory.getLogFormatName(((ProbeCommonData)odata).getMsgID());
        if (category == null) {
            return;
        }
        String selectTid = Integer.toString(((ProbeCommonData)odata).getTid());
        if (category.equals(ThreadPageLabels.THREAD_CHART_THREAD)) {
            this.changeComboSyncToThread();
            this.threadChartBoard.selectItem(this.threadChartBoard.getThreadChartIndexByTID(selectTid));
        } else {
            this.changeComboThreadToSync();
            this.syncChartBoard.selectItem(this.getSyncChartIndexOfSelected(selectTid));
        }
        DAChartBoard chartBoard = (DAChartBoard)this.stackLayout.topControl;
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)chartBoard.getMarkers().get(0);
        long start = ((ProbeCommonData)odata).getTime();
        long end = ((ProbeCommonData)odata).getTime();
        double startTime = (double)start / 1000000.0;
        double endTime = (double)end / 1000000.0;
        intervalMarker.setInterval(startTime, endTime);
        this.moveSelectTime(startTime);
    }

    private void selectionFromAPITable(DASelectionData selData) {
        DAChartBoard chartBoard = (DAChartBoard)this.stackLayout.topControl;
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)chartBoard.getMarkers().get(0);
        long start = selData.getStartTime();
        long end = selData.getEndTime();
        double startTime = (double)start / 1000000.0;
        double endTime = (double)end / 1000000.0;
        intervalMarker.setInterval(startTime, endTime);
        this.moveSelectTime(startTime);
    }

    private void moveSelectTime(double time) {
        if (this.stackLayout.topControl == this.syncChartBoard) {
            this.syncChartBoard.setVisibleMiddleTime(time);
            this.syncChartBoard.updateChart();
        } else {
            this.threadChartBoard.setVisibleMiddleTime(time);
            this.threadChartBoard.updateChart();
        }
    }

    private int getSyncChartIndexOfSelected(String tID) {
        int itemSize = this.threadChartBoard.getItemList().getItemSize();
        if (tID == null || itemSize == 0) {
            return 0;
        }
        int i = 0;
        while (i < itemSize) {
            DAChartBoardItem item = this.threadChartBoard.getItemList().get(i);
            ThreadPageThreadData pageData = (ThreadPageThreadData)item.getData();
            if (pageData.getTid() == Integer.parseInt(tID)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void clear() {
        this.syncChartBoard.contentsClear();
        this.syncChartBoard.clear();
        this.threadChartBoard.contentsClear();
        this.threadChartBoard.clear();
        this.initializeCharts();
    }

    private void initializeCharts() {
        this.threadChartBoard.initIntervalMarkers();
        this.syncChartBoard.initIntervalMarkers();
        this.initTimeline();
    }

    private void initTimeline() {
        DATimeline threadTimeline = this.threadChartBoard.getTimeline();
        DATimeline syncTimeline = this.syncChartBoard.getTimeline();
        threadTimeline.setTimeTickFont(FontResources.TIMELINE_TICK_FONT);
        threadTimeline.setTimeBalloonFont(FontResources.TIMELINE_BALLOON_FONT);
        syncTimeline.setTimeTickFont(FontResources.TIMELINE_TICK_FONT);
        syncTimeline.setTimeBalloonFont(FontResources.TIMELINE_BALLOON_FONT);
        LifecycleLogParser.getInstance().registerLifecycleBar(this.threadChartBoard.getLifecycleBar());
        LifecycleLogParser.getInstance().registerTimeline(threadTimeline);
        LifecycleLogParser.getInstance().registerLifecycleBar(this.syncChartBoard.getLifecycleBar());
        LifecycleLogParser.getInstance().registerTimeline(syncTimeline);
    }

    public DAChartBoard getChartBoard() {
        return this.threadChartBoard;
    }
}

