/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.ChartPopupMenu;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.timeline.SystemDataDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.helper.Formatter;

public class EnergyChart
extends TimelineChart {
    private static final String UNIT = "A";
    private DAChartSeries energyUsageSeries;
    private List<DAChartSeries> deviceUsageSeriesList;
    private List<DAChartSeries> deviceUsagePerAppSeriesList;
    private DAChartBoardItem appUsageItem;

    public EnergyChart(String pageID) {
        super(pageID);
        this.chartType = -113;
        this.probeType = 5;
        this.chartName = TimelineChartLabels.ENERGY_CHART_TITLE;
        this.chartDescriptor = TimelineChartLabels.ENERGY_CHART_DESCRIPTOR;
        this.chartIcon = ImageResources.FEATURE_ENERGY_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_ENERGY_SMALL_NOR;
        Logger.check((Object)"This line was comment.(//FIXME)");
        this.energyUsageSeries = new DAChartSeries(TimelineChartLabels.ENERGY_CHART_SERIES, 1, ColorResources.RED);
        this.deviceUsageSeriesList = new ArrayList<DAChartSeries>();
        this.deviceUsagePerAppSeriesList = new ArrayList<DAChartSeries>();
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard board) {
        DAChartBoardItem item = super.createBoardItem(board);
        this.chart.getPlot().setAxisUnit(UNIT);
        this.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.MICRO_DECIMAL);
        this.chart.getPlot().setShowAxis(true);
        this.appUsageItem = new DAChartBoardItem(item, "App usage");
        DAChart appUsageChart = this.appUsageItem.getChart();
        DAChartPlot appUsageChartPlot = appUsageChart.getPlot();
        DAChartPlotTooltip tooltip = new DAChartPlotTooltip(-1.0);
        appUsageChartPlot.setBackgroundImage(ImageResources.BG_GRADIENT);
        appUsageChartPlot.setAutoHeightRange(DAChartPlot.AutoRangeType.SEMI_AUTO);
        tooltip.setFont(FontResources.CHART_TOOLTIP_FONT);
        appUsageChartPlot.setTooltip(tooltip);
        appUsageChartPlot.setAxisUnit(UNIT);
        appUsageChartPlot.setAxisUnitType(DAChartPlot.UnitType.MICRO_DECIMAL);
        appUsageChartPlot.setShowAxis(true);
        appUsageChartPlot.setMarkers(board.getMarkers());
        ChartPopupMenu appUsageChartPopupMenu = new ChartPopupMenu(appUsageChart);
        TimelineChartMouseEventListener timelineChartMouseEventListener = new TimelineChartMouseEventListener(appUsageChartPopupMenu, board.getTimeline(), this.pageID);
        appUsageChart.addMouseListener((MouseListener)timelineChartMouseEventListener);
        appUsageChart.addMouseMoveListener((MouseMoveListener)timelineChartMouseEventListener);
        appUsageChart.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(board.getTimeline()));
        return item;
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        this.energyUsageSeries.clear();
        int i = 0;
        while (i < this.deviceUsageSeriesList.size()) {
            this.deviceUsageSeriesList.get(i).clear();
            ++i;
        }
        i = 0;
        while (i < this.deviceUsagePerAppSeriesList.size()) {
            this.deviceUsagePerAppSeriesList.get(i).clear();
            ++i;
        }
        try {
            if (this.chart.getSeriesList().isEmpty()) {
                String[] deviceList;
                if (Global.getProject() == null) {
                    return;
                }
                this.chart.addSeries(this.energyUsageSeries);
                String[] stringArray = deviceList = Global.getProject().getDeviceStatusInfo().getDevices().split(",");
                int n = deviceList.length;
                int n2 = 0;
                while (n2 < n) {
                    String device = stringArray[n2];
                    this.deviceUsageSeriesList.add(new DAChartSeries(device, 1));
                    this.deviceUsagePerAppSeriesList.add(new DAChartSeries(device, 1));
                    ++n2;
                }
                for (DAChartSeries series : this.deviceUsageSeriesList) {
                    this.chart.addSeries(series);
                }
                for (DAChartSeries series : this.deviceUsagePerAppSeriesList) {
                    this.appUsageItem.getChart().addSeries(series);
                }
            }
            List systemData = (List)dataList.get(0);
            int i2 = 0;
            while (i2 < systemData.size()) {
                List row = (List)systemData.get(i2);
                double time = (double)((Long)row.get(SystemDataDBTable.COLUMN.SAMPLING_TIME.ordinal())).longValue() / 1000000.0;
                try {
                    long energyUsage = (Long)row.get(SystemDataDBTable.COLUMN.ENERGY_USAGE.ordinal());
                    this.energyUsageSeries.addSeriesItem(new DAChartSeriesItem(time, (double)energyUsage, String.valueOf(Formatter.convertMicroDecimalPrefix((double)energyUsage)) + UNIT));
                    List deviceUsageList = (List)row.get(SystemDataDBTable.COLUMN.ENERGY_USAGE_DEVICE.ordinal());
                    List appUsageList = (List)row.get(SystemDataDBTable.COLUMN.ENERGY_USAGE_APP.ordinal());
                    int ii = 0;
                    while (ii < deviceUsageList.size()) {
                        long usage = (Long)deviceUsageList.get(ii);
                        long usageApp = (Long)appUsageList.get(ii);
                        DAChartSeries deviceUsageSeries = this.deviceUsageSeriesList.get(ii);
                        DAChartSeries deviceAppUsageSeries = this.deviceUsagePerAppSeriesList.get(ii);
                        deviceUsageSeries.addSeriesItem(new DAChartSeriesItem(time, (double)usage, String.valueOf(Formatter.convertMicroDecimalPrefix((double)usage)) + UNIT));
                        deviceAppUsageSeries.addSeriesItem(new DAChartSeriesItem(time, (double)usageApp, String.valueOf(Formatter.convertMicroDecimalPrefix((double)usageApp)) + UNIT));
                        ++ii;
                    }
                }
                catch (NumberFormatException ne) {
                    Logger.exception((Throwable)ne);
                }
                ++i2;
            }
        }
        catch (NumberFormatException ne) {
            Logger.exception((Throwable)ne);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.deviceUsageSeriesList.clear();
        this.deviceUsagePerAppSeriesList.clear();
    }
}

