/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets.table;

import java.util.Map;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAContainerComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;

public class DABaseDataPageComposite
extends DAContainerComposite {
    public static final double DEFAULT_BOTTOM_FORM_HEIGHT = 235.0;
    protected SashForm baseForm = new SashForm((Composite)this, 512);
    protected SashForm topForm;
    protected SashForm bottomForm;
    protected SashForm bottomRightForm;
    protected SashForm bottomLeftForm;
    int tableWeight = 65;
    int tableHeight = -1;
    protected static boolean isDetailMode = true;
    protected boolean lastDetailMode = true;

    public DABaseDataPageComposite(Composite parent, int style) {
        super(parent, style);
        this.baseForm.setLayout((Layout)new FillLayout());
        this.baseForm.setForeground(ColorResources.WHITE);
        this.baseForm.setBackground(ColorResources.WHITE);
        this.topForm = new SashForm((Composite)this.baseForm, 512);
        this.bottomForm = new SashForm((Composite)this.baseForm, 256);
        this.bottomLeftForm = new SashForm((Composite)this.bottomForm, 0);
        this.bottomLeftForm.setForeground(ColorResources.WHITE);
        this.bottomLeftForm.setLayout((Layout)new FillLayout());
        this.bottomRightForm = new SashForm((Composite)this.bottomForm, 0);
        this.bottomRightForm.setForeground(ColorResources.WHITE);
        this.bottomRightForm.setLayout((Layout)new FillLayout());
        this.baseForm.setSashWidth(2);
        this.bottomForm.setSashWidth(2);
        this.bottomLeftForm.setSashWidth(2);
        this.bottomRightForm.setSashWidth(2);
        this.bottomForm.setWeights(new int[]{this.tableWeight, 100 - this.tableWeight});
        this.addTableWeightListener();
    }

    protected void onResized(int width, int height) {
        this.addHeightWeightListener(height);
        if (!isDetailMode) {
            int[] nArray = new int[2];
            nArray[0] = 100;
            this.baseForm.setWeights(nArray);
        } else {
            int hrate;
            int n = hrate = this.tableHeight == -1 ? (int)(23500.0 / (double)height) : this.tableHeight * 100 / height;
            if (hrate > 100) {
                return;
            }
            this.baseForm.setWeights(new int[]{100 - hrate, hrate});
        }
        this.resizeTableButton();
    }

    private void addHeightWeightListener(int pageHeight) {
        if (this.baseForm.getChildren().length > 2) {
            ((Sash)this.baseForm.getChildren()[2]).addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    DABaseDataPageComposite.this.tableHeight = DABaseDataPageComposite.this.baseForm.getWeights()[1] * DABaseDataPageComposite.this.baseForm.getSize().y / 1000;
                }
            });
        }
    }

    private void addTableWeightListener() {
        ((SashForm)this.bottomForm.getChildren()[0]).addListener(11, new Listener(){

            public void handleEvent(Event event) {
                DABaseDataPageComposite.this.resizeTableButton();
            }
        });
    }

    public Composite getActiveTable() {
        if (this.activeTabComposite != null) {
            return (Composite)((DAViewComposite)this.activeTabComposite.getTopComposite()).getControl();
        }
        return null;
    }

    public SashForm getBaseForm() {
        return this.baseForm;
    }

    public SashForm getTopForm() {
        return this.topForm;
    }

    public SashForm getBottomForm() {
        return this.bottomForm;
    }

    public SashForm getBottomRightForm() {
        return this.bottomRightForm;
    }

    public SashForm getBottomLeftForm() {
        return this.bottomLeftForm;
    }

    public void setTableWeight(int weight) {
        if (weight >= 0 && weight <= 100) {
            this.tableWeight = weight;
        }
    }

    private void resizeTablesColumns(Composite parent, int width) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control comp = controlArray[n2];
            if (comp instanceof DATableComposite) {
                ((DATableComposite)comp).resizeColumns(width);
            } else if (comp instanceof Composite) {
                this.resizeTablesColumns((Composite)comp, width);
            }
            ++n2;
        }
    }

    public void resizeTableButton() {
        this.resizeTableButtonInForm(this.bottomLeftForm, 0);
        this.resizeTableButtonInForm(this.bottomRightForm, 1);
    }

    private void resizeTableButtonInForm(SashForm form, int index) {
        if (form.getChildren().length > 0 && form.getChildren()[0] instanceof DATabComposite) {
            double weight = (double)this.bottomForm.getWeights()[index] / 1000.0;
            int width = (int)((double)WorkbenchUtil.getWorkbenchWindow().getShell().getBounds().width * weight);
            ((DATabComposite)form.getChildren()[0]).resizeTableButton(width);
            this.resizeTablesColumns((Composite)((DATabComposite)form.getChildren()[0]), width);
        }
    }

    public void updateView() {
        for (Map.Entry entry : this.childMap.entrySet()) {
            ((DABaseComposite)entry.getValue()).updateView();
        }
        if (this.lastDetailMode != isDetailMode) {
            this.lastDetailMode = isDetailMode;
            if (!this.lastDetailMode) {
                if (this.baseForm.getChildren().length > 2) {
                    ((Sash)this.baseForm.getChildren()[2]).setVisible(false);
                }
            } else if (this.baseForm.getChildren().length > 2) {
                ((Sash)this.baseForm.getChildren()[2]).setVisible(true);
            }
            Point size = this.getSize();
            this.onResized(size.x, size.y);
        }
    }

    public static void setDetailMode(boolean isDetail) {
        isDetailMode = isDetail;
    }
}

