/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.progress;

import java.util.ArrayList;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.widgets.animation.DAAnimationIcon;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressManager;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.progress.BarProgress;

public class ProgressHolder {
    static final Color barStartBgColor = ColorResources.GRAY_245;
    static final Color barEndBgColor = ColorResources.GRAY_245;
    static final Color barOutlineColor = ColorResources.POINT;
    public static final int HEIGHT = 66;
    static Font percentageFont = FontResources.PROGRESS_PERCENTAGE_FONT;
    static Color fontColor = org.tizen.dynamicanalyzer.resources.ColorResources.PROGRESS_PERCENTAGE_FONT_COLOR;
    private int value;
    private String upperText = "";
    private String bottomText = "";
    private Label upperLabel;
    private Label bottomLabel;
    BarProgress barProgress;
    private int progressStyle;
    private SelectionListener cancelListener;
    private Composite progress;

    public ProgressHolder(int style, String upperText, String bottomText, SelectionListener cancelListener) {
        this.progressStyle = style;
        this.upperText = upperText;
        this.bottomText = bottomText;
        this.cancelListener = cancelListener;
    }

    public void createProgress(Composite parent, int swtStyle) {
        if (this.progress != null && !this.progress.isDisposed()) {
            this.progress.dispose();
        }
        this.progress = new Composite(parent, swtStyle);
        this.progress.setLayout((Layout)new FormLayout());
        this.progress.setBackground(ColorResources.WHITE);
        this.upperLabel = new Label(this.progress, 0);
        this.upperLabel.setText(this.upperText);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.upperLabel.setLayoutData((Object)data);
        Composite progressComposite = new Composite(this.progress, 0);
        switch (this.progressStyle) {
            case 0: 
            case 1: {
                this.barProgress = new BarProgress(progressComposite, 0);
                break;
            }
            case 2: {
                DAAnimationIcon progressIcon = this.createProgressIcon(progressComposite);
                progressIcon.start();
                break;
            }
        }
        data = new FormData();
        data.top = new FormAttachment(0, 20);
        data.left = new FormAttachment(0, 0);
        data.height = 22;
        data.width = 276;
        progressComposite.setLayoutData((Object)data);
        progressComposite.setLayout((Layout)new FillLayout());
        this.bottomLabel = new Label(this.progress, 0);
        this.bottomLabel.setText(this.bottomText);
        data = new FormData();
        data.top = new FormAttachment((Control)progressComposite, 3);
        data.left = new FormAttachment(0, 0);
        this.bottomLabel.setLayoutData((Object)data);
        if (this.barProgress != null) {
            this.barProgress.setValue(this.value);
        }
    }

    public void setValue(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > 100) {
            value = 100;
        }
        this.value = value;
        if (this.barProgress != null) {
            this.barProgress.setValue(value);
        }
        ProgressManager.INSTANCE.updateValue();
    }

    public void setValues(String progressMessage, int value) {
        this.setUpperText(progressMessage);
        this.setValue(value);
    }

    public void errorOccured(String message, String bottomMessage) {
        this.barProgress.barStartColor = ColorResources.RED;
        this.barProgress.barEndColor = ColorResources.WHITE;
        this.upperLabel.setText(message);
        this.bottomLabel.setText(bottomMessage);
    }

    public void setLayoutData(Object layout) {
        this.progress.setLayoutData(layout);
    }

    public void dispose() {
        this.progress.dispose();
    }

    public boolean isVisible() {
        return this.progress != null && !this.progress.isDisposed() && this.progress.isVisible();
    }

    public int getValue() {
        return this.value;
    }

    public String getUpperText() {
        return this.upperText;
    }

    public void setUpperText(String progressMessage) {
        this.upperText = progressMessage;
    }

    private DAAnimationIcon createProgressIcon(Composite comp) {
        ArrayList<Image> progressImage = new ArrayList<Image>();
        progressImage.add(ImageResources.INDETERMINATE_PROGRESS_01);
        progressImage.add(ImageResources.INDETERMINATE_PROGRESS_02);
        return new DAAnimationIcon(comp, 0, progressImage);
    }

    public String getBottomText() {
        return this.bottomText;
    }

    public SelectionListener getCancelListener() {
        return this.cancelListener;
    }
}

