/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.chart.listener;

import org.eclipse.swt.events.MouseEvent;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.chart.listener.GLChartMouseListener;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLFrameRateInfo;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSelectionData;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;
import org.tizen.dynamicanalyzer.widgets.timeline.MarkerManager;

public class GLFrameRateMouseListener
extends GLChartMouseListener {
    public GLFrameRateMouseListener(DAPopupMenu menu, DATimeline timeline) {
        super(menu, timeline);
    }

    public void mouseDown(MouseEvent e) {
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartPlotMarker marker = (DAChartPlotMarker)plot.getMarkers().get(0);
        if (!(marker instanceof DAChartPlotIntervalMarker)) {
            return;
        }
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)marker;
        double eventTime = plot.getXFromXPixel(e.x);
        if (e.button == 3) {
            if (this.menu != null) {
                this.menu.getItems().forEach(item -> item.setDoubleData(eventTime));
            }
            return;
        }
        boolean bShift = false;
        if ((e.stateMask & 0x20000) != 0) {
            bShift = true;
        }
        if (bShift && intervalMarker.getStartVal() != -1.0) {
            if (this.baseTime > eventTime) {
                intervalMarker.setInterval(eventTime, this.baseTime);
            } else {
                intervalMarker.setInterval(this.baseTime, eventTime);
            }
        } else {
            intervalMarker.setInterval(eventTime, eventTime);
            this.baseTime = eventTime;
        }
        chart.redraw();
        this.clickChartIndex = ((DAChartSeries)chart.getSeriesList().get(0)).getPrevIndexByXvalue(plot.getXFromXPixel(e.x));
        if (this.clickChartIndex < 0) {
            return;
        }
    }

    @Override
    public void mouseUp(MouseEvent e) {
        double markerEndVal;
        double markerStartVal;
        if (e.button == 3) {
            return;
        }
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartPlotMarker marker = (DAChartPlotMarker)plot.getMarkers().get(0);
        if (!(marker instanceof DAChartPlotIntervalMarker)) {
            return;
        }
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)marker;
        double eventFrameIndex = plot.getXFromXPixel(e.x);
        if (intervalMarker.getStartVal() >= eventFrameIndex) {
            markerStartVal = eventFrameIndex;
            markerEndVal = intervalMarker.getEndVal();
        } else {
            markerStartVal = intervalMarker.getStartVal();
            markerEndVal = eventFrameIndex;
        }
        int lastFrame = GLDataManager.getInstance().getFrameSize();
        if (markerStartVal < 0.0) {
            markerStartVal = 0.0;
        } else if (markerStartVal > (double)lastFrame) {
            markerStartVal = lastFrame;
        }
        if (markerEndVal > (double)lastFrame) {
            markerEndVal = lastFrame;
        } else if (markerEndVal < 0.0) {
            markerEndVal = 0.0;
        }
        int startIndex = 0;
        int endIndex = 0;
        if (markerEndVal <= plot.getVisibleEndX()) {
            intervalMarker.setInterval(markerStartVal, markerEndVal);
            startIndex = (int)markerStartVal;
            endIndex = (int)markerEndVal;
        } else {
            intervalMarker.setInterval(markerStartVal, plot.getVisibleEndX());
            startIndex = (int)markerStartVal;
            endIndex = (int)plot.getVisibleEndX();
        }
        GLFrameRateInfo selectionFrameCountInfo = GLDataManager.getInstance().getFrameRateStartIndex(startIndex, endIndex);
        if (selectionFrameCountInfo == null) {
            return;
        }
        AnalyzerManager.getCurrentPage().updateView((DAViewData)new GLSelectionData(GLPage.chartViewID, selectionFrameCountInfo.getStartFrameIndex(), selectionFrameCountInfo.getEndFrameIndex(), null));
    }

    public void mouseDoubleClick(MouseEvent e) {
        DAChart daChart = (DAChart)e.widget;
        DAChartPlot plot = daChart.getPlot();
        double time = plot.getXFromXPixel(e.x);
        long longTime = (long)(time * 1000000.0);
        if (longTime <= Toolbar.INSTANCE.getTime()) {
            MarkerManager.INSTANCE.addMarker(time);
        }
    }
}

