/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.button.toggle;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonAttribute;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomToggleButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class DACustomExtendButtonRenderer
extends DACustomToggleButtonRenderer {
    @Override
    public void draw(GC gc, Canvas canvas, int state, DACustomButtonAttribute attr) {
        Rectangle rect = canvas.getClientArea();
        if (attr.getDrawType() == 0) {
            this.drawButtonToggleImage(gc, rect, attr, state);
            this.drawButtonText(gc, rect, attr, state);
        }
    }

    private void drawButtonToggleImage(GC gc, Rectangle rect, DACustomButtonAttribute attr, int state) {
        Image img = attr.getImage(state);
        Point p = null;
        if (img != null) {
            Rectangle imgRect = img.getBounds();
            int x = 0;
            int y = 0;
            p = attr.getButtonImagePoint();
            if (p == null) {
                int width = rect.width - imgRect.width;
                int height = rect.height - imgRect.height;
                if (width > 0) {
                    x = width / 2;
                } else {
                    Logger.debug((Object)("width size : " + width));
                }
                if (height > 0) {
                    y = height / 2;
                } else {
                    Logger.debug((Object)("height size : " + height));
                }
            } else {
                x = p.x;
                y = p.y;
            }
            if (state == 1) {
                ++x;
                ++y;
            }
            gc.drawImage(img, x, y);
        }
    }

    @Override
    protected void drawButtonText(GC gc, Rectangle rect, DACustomButtonAttribute attr, int state) {
        String text = null;
        Font font = null;
        Point p = null;
        Rectangle textRect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        if (attr.getIcon() != null) {
            Rectangle iconRect = attr.getIcon().getBounds();
            textRect.x += iconRect.width;
            textRect.width -= iconRect.width;
        }
        if ((text = attr.getText()) != null) {
            font = attr.getFont();
            if (font == null) {
                font = new Font((Device)Display.getCurrent(), "Arial", this.computeFontSize(textRect), 0);
                attr.setFont(font);
            }
            gc.setFont(font);
            int x = 0;
            int y = 0;
            int offset = 0;
            p = attr.getFontPoint();
            if (p == null) {
                p = gc.textExtent(text, 8);
                if (attr.getAlign() == 0x1000000) {
                    x = (textRect.width - p.x) / 2 + textRect.x;
                    x = x < 0 ? 0 : x;
                    offset = -2;
                } else {
                    x = textRect.x;
                    offset = 2;
                }
                y = (textRect.height - p.y) / 2;
            } else {
                x = p.x;
                y = p.y;
            }
            if (attr.getFontColor(state) != null) {
                gc.setForeground(attr.getFontColor(state));
            } else {
                gc.setForeground(ColorResources.BLACK);
            }
            if (state == 1) {
                ++x;
                ++y;
            }
            gc.drawString(text, x + offset, y, true);
        }
    }
}

