/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.base;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressManager;
import org.tizen.dynamicanalyzer.widgets.progress.CircleProgress;
import org.tizen.dynamicanalyzer.widgets.progress.ProgressHolder;

public class ProgressDialog {
    private static final int WIDTH = 300;
    private static final int HEIGHT = 86;
    public static final int PROGRESS_STYLE_DEFAULT = 0;
    public static final int PROGRESS_STYLE_CANCEL = 1;
    public static final int PROGRESS_STYLE_INDETERMINATE = 2;
    private Shell parent = null;
    private Shell shell = null;
    private Composite baseComposite = null;
    Composite progressComposite;
    private Composite progressDialogComposite = null;
    private Label header = null;
    String headerText = "Time consuming process(es) is(are) in progress";
    Button cancelButton = null;
    private Button runInBackgroundButton = null;
    private SelectionListener defaultCancelButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ProgressDialog.this.close();
        }
    };
    private Listener shellMouseListener = new Listener(){
        boolean down = false;
        Point downPoint = new Point(0, 0);

        public void handleEvent(Event event) {
            int id = event.type;
            if (event.widget instanceof Shell) {
                this.down = false;
            } else {
                switch (id) {
                    case 3: {
                        this.downPoint.x = event.x;
                        this.downPoint.y = event.y;
                        this.down = true;
                        break;
                    }
                    case 4: {
                        this.down = false;
                        break;
                    }
                    case 5: {
                        if (!this.down || ProgressDialog.this.shell == null) break;
                        Point p = ProgressDialog.this.shell.getLocation();
                        p.x += event.x - this.downPoint.x;
                        p.y += event.y - this.downPoint.y;
                        ProgressDialog.this.shell.setLocation(p);
                        break;
                    }
                }
            }
        }
    };
    private boolean backgroundOnly = false;

    ProgressDialog(Shell parent, Composite base) {
        this.parent = parent;
        this.baseComposite = base;
    }

    public void open() {
        if (this.shell == null) {
            this.createProgressDialog();
            this.createProgressesFromUI();
        }
        this.shell.notifyListeners(4, new Event());
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ProgressDialog.this.shell == null) {
                    return;
                }
                Rectangle rect = ProgressDialog.this.shell.getClientArea();
                e.gc.setForeground(ColorResources.STOP_PROGRESS_LINE2_COLOR);
                e.gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
                e.gc.setForeground(ColorResources.STOP_PROGRESS_LINE1_COLOR);
                e.gc.drawRectangle(rect.x + 1, rect.y + 1, rect.width - 3, rect.height - 3);
            }
        });
        this.shell.getDisplay().addFilter(3, this.shellMouseListener);
        this.shell.getDisplay().addFilter(4, this.shellMouseListener);
        this.shell.getDisplay().addFilter(5, this.shellMouseListener);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    event.doit = false;
                }
            }
        });
        if (this.cancelButton.getListeners(13).length == 0) {
            this.cancelButton.addSelectionListener(this.defaultCancelButtonListener);
        }
        if (!ProgressManager.INSTANCE.isBackgroundOnly()) {
            this.shell.open();
            this.baseComposite.setEnabled(false);
        }
        CircleProgress.getCircleProgress().setVisible(true);
    }

    public void draw() {
        if (this.shell == null) {
            this.createProgressDialog();
        }
        this.createProgressesFromUI();
        this.open();
    }

    public void close() {
        CircleProgress.getCircleProgress().setVisible(false);
        if (this.shell != null) {
            this.shell.close();
            this.shell = null;
        }
        this.baseComposite.setEnabled(true);
    }

    public void setHeaderMessage(String message) {
        this.headerText = message != null && !message.isEmpty() ? message : "Time consuming process(es) is(are) in progress";
        if (this.header != null) {
            this.header.setText(this.headerText);
        }
    }

    public void setCancelEnabled(final boolean enable) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.cancelButton.setEnabled(enable);
                ProgressDialog.this.cancelButton.redraw();
            }
        });
    }

    public boolean isBackgroundOnly() {
        return this.backgroundOnly;
    }

    public void setBackgroundOnly(boolean backgroundOnly) {
        this.backgroundOnly = backgroundOnly;
        if (backgroundOnly) {
            CircleProgress.getCircleProgress().setVisible(true);
            if (this.shell != null) {
                this.shell.close();
                this.shell = null;
            }
            this.baseComposite.setEnabled(true);
        } else {
            this.open();
        }
    }

    private void createProgressDialog() {
        this.shell = new Shell(this.parent, 65544);
        int height = 86 + 66 * ProgressManager.INSTANCE.progresses.size();
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 300) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - height) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setSize(300, height);
        this.progressDialogComposite = new Composite((Composite)this.shell, 0);
        this.progressDialogComposite.setLayout((Layout)new FormLayout());
        this.progressDialogComposite.setBackground(ColorResources.WHITE);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(0, 2);
        data.right = new FormAttachment(100, -2);
        data.bottom = new FormAttachment(100, -2);
        this.progressDialogComposite.setLayoutData((Object)data);
        this.createHeader();
        this.progressComposite = new Composite(this.progressDialogComposite, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.header, 10);
        data.left = new FormAttachment(0, 10);
        data.width = 276;
        data.height = 66;
        this.progressComposite.setLayoutData((Object)data);
        this.progressComposite.setLayout((Layout)new FormLayout());
        this.createButtons();
    }

    private void createProgressesFromUI() {
        int i = 0;
        while (i < ProgressManager.INSTANCE.progresses.size()) {
            ProgressHolder progress = ProgressManager.INSTANCE.progresses.get(i);
            if (!progress.isVisible()) {
                progress.createProgress(this.progressComposite, 0);
                FormData data = new FormData();
                data.top = new FormAttachment(0, 66 * i);
                data.left = new FormAttachment(0, 0);
                data.width = 276;
                data.height = 66;
                progress.setLayoutData(data);
                if (progress.getCancelListener() != null) {
                    this.cancelButton.addSelectionListener(progress.getCancelListener());
                }
            }
            ++i;
        }
    }

    private void createHeader() {
        this.header = new Label(this.progressDialogComposite, 0x40004000);
        this.header.setText(this.headerText);
        this.header.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        this.header.setForeground(ColorResources.BLACK);
        this.header.setBackground(ColorResources.WHITE);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 17);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(95, 0);
        this.header.setLayoutData((Object)data);
    }

    private void createButtons() {
        FormData cancelData = new FormData();
        cancelData.top = new FormAttachment((Control)this.progressComposite, 10);
        cancelData.right = new FormAttachment(100, -8);
        cancelData.width = 88;
        cancelData.height = 22;
        this.cancelButton = this.createButton(this.progressDialogComposite, "Cancel", cancelData);
        this.cancelButton.setLayoutData((Object)cancelData);
        FormData runInBackgroundData = new FormData();
        runInBackgroundData.top = new FormAttachment((Control)this.progressComposite, 10);
        runInBackgroundData.right = new FormAttachment((Control)this.cancelButton, -8);
        runInBackgroundData.width = 138;
        runInBackgroundData.height = 22;
        this.runInBackgroundButton = this.createButton(this.progressDialogComposite, "Run in Background", runInBackgroundData);
        this.runInBackgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressManager.INSTANCE.setBackgroundOnly(true);
            }
        });
    }

    private Button createButton(Composite comp, String text, FormData data) {
        Button button = new Button(comp, 0);
        button.setText(text);
        button.setLayoutData((Object)data);
        button.setFont(FontResources.DIALOG_BUTTON_FONT);
        return button;
    }
}

