/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.timeline;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimelineRenderer;

public class DATimelineFrameRenderer
extends DATimelineRenderer {
    public static final int DEFAULT_INTERVAL = 1;
    public static final int DRAW_FRAME_INTERVAL = 10;
    private final Image balloon = ImageResources.TIMELINE_DETAILED_TIME_BALLOON;
    private final int balloonHalfWidth;
    private final int balloonHalfHeight;
    protected static final int TIME_STRING_PIXEL_Y = 4;
    protected static final int TIME_BALLOON_PIXEL_Y = 18;

    public DATimelineFrameRenderer() {
        this.balloonHalfWidth = this.balloon.getBounds().width / 2;
        this.balloonHalfHeight = this.balloon.getBounds().height / 2;
    }

    private void drawTimeString(GC gc, int totalSecond, int pixelX, int pixelY) {
        String timeString = String.valueOf(totalSecond);
        Point p = gc.textExtent(timeString, 8);
        gc.setForeground(ColorResources.TIMELINE_NUMBER_COLOR);
        gc.drawText(timeString, pixelX - p.x / 2, pixelY, true);
        gc.setForeground(ColorResources.TIMELINE_TICK_COLOR);
    }

    @Override
    public void draw(GC gc, DATimeline timeline) {
        Rectangle rt = timeline.getClientArea();
        gc.setFont(this.timeTickFont);
        gc.setBackground(ColorResources.TIMELINE_BG_COLOR);
        gc.fillRectangle(rt);
        gc.setForeground(ColorResources.TIMELINE_TICK_COLOR);
        gc.drawLine(0, rt.height - 1, rt.width, rt.height - 1);
        int scale = timeline.getScale();
        int frameInterval = scale * 1;
        double startMargin = timeline.getStartTime();
        int startFrame = (int)startMargin;
        int current = 10 - startFrame % 10;
        int pixelX = (int)(((double)(current %= 10) - (startMargin -= (double)startFrame)) * (double)frameInterval);
        while (pixelX < rt.width) {
            pixelX = (int)(((double)current - startMargin) * (double)frameInterval);
            gc.drawLine(pixelX, rt.height - 5, pixelX, rt.height - 1);
            if (scale >= 8) {
                this.drawTimeString(gc, current + startFrame, pixelX, 4);
            } else if (scale >= 4) {
                if ((current + startFrame) % 20 == 0) {
                    this.drawTimeString(gc, current + startFrame, pixelX, 4);
                }
            } else if ((current + startFrame) % 50 == 0) {
                this.drawTimeString(gc, current + startFrame, pixelX, 4);
            }
            current += 10;
        }
        int detailedFrame = timeline.getDetailedFrame();
        if (-1 != detailedFrame) {
            int detailedX = (int)(((double)(detailedFrame - startFrame) - startMargin + 0.5) * (double)frameInterval);
            gc.drawImage(this.balloon, 0, 0, this.balloon.getBounds().width, this.balloon.getBounds().height, detailedX - this.balloonHalfWidth, 0, this.balloon.getBounds().width, timeline.getBounds().height - 1);
            String time = String.valueOf(detailedFrame);
            gc.setForeground(ColorResources.BLACK);
            gc.setFont(this.timeBalloonFont);
            gc.drawString(time, detailedX - gc.stringExtent((String)time).x / 2, this.balloonHalfHeight - gc.stringExtent((String)time).y / 2 - 4, true);
        }
        if (timeline.getDrawDetailedTime()) {
            gc.drawImage(this.balloon, 0, 0, this.balloon.getBounds().width, this.balloon.getBounds().height, timeline.getDetailedTimePosition() - this.balloonHalfWidth, 2, this.balloon.getBounds().width, 18);
            String time = String.valueOf((int)timeline.getDetailedTime());
            gc.setForeground(ColorResources.BLACK);
            gc.setFont(this.timeBalloonFont);
            gc.drawString(time, timeline.getDetailedTimePosition() - gc.stringExtent((String)time).x / 2, 4, true);
        }
    }
}

