/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.timeline;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimelineMarker;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.IEventListener;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.MarkerAddEvent;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.MarkerEvent;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.MarkerEventType;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.MarkerPositionUpdateEvent;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.MarkerRemoveEvent;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.MarkerTimeUpdateEvent;

public class MarkerManager {
    public static final double MEGA_DOUBLE = 1000000.0;
    public static final MarkerManager INSTANCE = new MarkerManager();
    private List<DATimelineMarker> markerList = new ArrayList<DATimelineMarker>();
    private List<Double> markerTimeList = new ArrayList<Double>();
    private List<Long> markerTimeListLong = new ArrayList<Long>();
    private List<IEventListener> listeners = new ArrayList<IEventListener>();

    private int findNewMarkerPosition(double time) {
        int idx = 0;
        while (idx < this.markerTimeList.size() && this.markerTimeList.get(idx) < time) {
            ++idx;
        }
        return idx;
    }

    private void insertMarker(DATimelineMarker marker) {
        int idx = this.findNewMarkerPosition(marker.getTime());
        this.markerList.add(idx, marker);
        this.markerTimeList.add(idx, marker.getTime());
        this.markerTimeListLong.add(idx, (long)(marker.getTime() * 1000000.0));
        this.notifyListeners(new MarkerAddEvent(idx, marker.getTime()));
    }

    public void addMarker(long time) {
        this.addMarker((double)time / 1000000.0);
    }

    public void addMarker(double time) {
        if (!this.markerTimeList.contains(time)) {
            DATimelineMarker tmp = new DATimelineMarker(ImageResources.MARKER_NOR, ImageResources.MARKER, ImageResources.MARKER_NOR);
            tmp.setTime(time);
            this.insertMarker(tmp);
        }
    }

    public void weakUpdateMarkerTime(int idx, double time) {
        double oldTime = this.markerTimeList.get(idx);
        this.markerList.get(idx).setTime(time);
        this.markerTimeList.set(idx, time);
        this.markerTimeListLong.set(idx, (long)(time * 1000000.0));
        this.notifyListeners(new MarkerTimeUpdateEvent(idx, oldTime, time));
    }

    public void removeMarker(int idx) {
        double time = this.markerTimeList.get(idx);
        this.markerList.remove(idx);
        this.markerTimeList.remove(idx);
        this.markerTimeListLong.remove(idx);
        this.notifyListeners(new MarkerRemoveEvent(idx, time));
    }

    public int getMarkerCount() {
        return this.markerList.size();
    }

    public List<DATimelineMarker> getMarkerList() {
        return this.markerList;
    }

    public List<Double> getMarkerTimeList() {
        return this.markerTimeList;
    }

    public List<Long> getMarkerTimeListLong() {
        return this.markerTimeListLong;
    }

    public void clearMarkerList() {
        this.markerList.clear();
        this.markerTimeList.clear();
        this.markerTimeListLong.clear();
        this.notifyListeners(new MarkerEvent(MarkerEventType.MARKER_CLEAR));
    }

    public void updateOrder(int idx) {
        DATimelineMarker tmp = this.markerList.get(idx);
        Double tmpTime = this.markerTimeList.get(idx);
        Long tmpTimeLong = this.markerTimeListLong.get(idx);
        this.markerList.remove(idx);
        this.markerTimeList.remove(idx);
        this.markerTimeListLong.remove(idx);
        int newIdx = this.findNewMarkerPosition(tmpTime);
        this.markerList.add(newIdx, tmp);
        this.markerTimeList.add(newIdx, tmpTime);
        this.markerTimeListLong.add(newIdx, tmpTimeLong);
        this.notifyListeners(new MarkerPositionUpdateEvent(idx, newIdx, tmpTime));
    }

    public void addEventListener(IEventListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners(MarkerEvent event) {
        for (IEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }
}

