/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalScope;

class NamespaceTypeCollector
extends ASTVisitor {
    private final ICPPASTInternalScope fScope;

    public NamespaceTypeCollector(ICPPASTInternalScope scope) {
        this.fScope = scope;
        this.shouldVisitDeclarations = true;
        this.shouldVisitStatements = true;
        this.shouldVisitParameterDeclarations = true;
    }

    public int visit(IASTDeclaration declaration) {
        if (declaration instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simpleDeclaration = (IASTSimpleDeclaration)declaration;
            ICPPASTDeclSpecifier declSpec = (ICPPASTDeclSpecifier)simpleDeclaration.getDeclSpecifier();
            if (declSpec.isFriend()) {
                IASTDeclarator[] declarators;
                IASTDeclarator[] iASTDeclaratorArray = declarators = simpleDeclaration.getDeclarators();
                int n = declarators.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTDeclarator declarator = iASTDeclaratorArray[n2];
                    IASTDeclarator innermost = null;
                    while (declarator != null) {
                        if (declarator instanceof IASTAmbiguousDeclarator) {
                            innermost = null;
                            break;
                        }
                        innermost = declarator;
                        declarator = declarator.getNestedDeclarator();
                    }
                    if (innermost != null) {
                        IASTName declaratorName = innermost.getName();
                        ASTInternal.addName(this.fScope, declaratorName);
                    }
                    ++n2;
                }
            } else if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && simpleDeclaration.getDeclarators().length != 0) {
                this.addNonSimpleElabSpec((ICPPASTElaboratedTypeSpecifier)declSpec);
            }
            return 3;
        }
        if (declaration instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition funcDefinition = (IASTFunctionDefinition)declaration;
            ICPPASTDeclSpecifier declSpec = (ICPPASTDeclSpecifier)funcDefinition.getDeclSpecifier();
            if (declSpec.isFriend()) {
                IASTFunctionDeclarator declarator = funcDefinition.getDeclarator();
                ASTInternal.addName(this.fScope, declarator.getName());
            } else if (declSpec instanceof ICPPASTElaboratedTypeSpecifier) {
                this.addNonSimpleElabSpec((ICPPASTElaboratedTypeSpecifier)declSpec);
            }
            return 3;
        }
        return 1;
    }

    public int visit(IASTParameterDeclaration declaration) {
        IASTDeclSpecifier declSpec = declaration.getDeclSpecifier();
        if (declSpec instanceof ICPPASTElaboratedTypeSpecifier) {
            this.addNonSimpleElabSpec((ICPPASTElaboratedTypeSpecifier)declSpec);
        }
        return 1;
    }

    private void addNonSimpleElabSpec(ICPPASTElaboratedTypeSpecifier elabSpec) {
        IASTName name;
        if (elabSpec.getKind() != 0 && !((name = elabSpec.getName()) instanceof ICPPASTQualifiedName)) {
            ASTInternal.addName(this.fScope, name);
        }
    }

    public int visit(IASTStatement statement) {
        return 1;
    }
}

