/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.table;

import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackUnit;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPage;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataManager;
import org.tizen.dynamicanalyzer.ui.memory.data.MemAllocDBTable;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryPersistentAllocationsTableIndex;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceDataManager;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class MemoryCallStackTable
extends DATableComposite {
    private String UNKNOWN = "<unknown>";
    private String UNKNOWN_LIBRARY = "<unknown library>";
    GridItem lastItem;

    public MemoryCallStackTable(Composite parent, int style) {
        super(parent, style);
    }

    public MemoryCallStackTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AnalyzerManager.getCurrentPage().updateView(new DAViewData(MemoryPage.callstackViewID, null));
                GridItem[] sels = MemoryCallStackTable.this.table.getSelection();
                if (sels.length <= 0) {
                    return;
                }
                MemoryCallStackTable.this.table.setFocusItem(sels[0]);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setContextMenu(2);
        this.applyFilterImage();
    }

    public void updateCallstackTable(DASelectionData selData) {
        this.table.removeAll();
        if (!this.isSelectionValid(selData)) {
            return;
        }
        DATableDataFormat tableData = (DATableDataFormat)((GridItem[])selData.getData())[0].getData();
        List<Object> memAllocationData = tableData.getData();
        long seqNum = (Long)this.getMemAllocationDataByColumnIndex(memAllocationData, MemoryPersistentAllocationsTableIndex.SEQ.getIndex());
        long time = (Long)this.getMemAllocationDataByColumnIndex(memAllocationData, MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
        long allocCallerAddr = this.getCallerAddr(memAllocationData, seqNum);
        int pid = (Integer)this.getMemAllocationDataByColumnIndex(memAllocationData, MemoryPersistentAllocationsTableIndex.PID.getIndex());
        int tid = (Integer)this.getMemAllocationDataByColumnIndex(memAllocationData, MemoryPersistentAllocationsTableIndex.TID.getIndex());
        String allocCallerPath = (String)this.getMemAllocationDataByColumnIndex(memAllocationData, MemoryPersistentAllocationsTableIndex.LIBRARY.getIndex());
        String allocName = (String)this.getMemAllocationDataByColumnIndex(memAllocationData, MemoryPersistentAllocationsTableIndex.CALLED.getIndex());
        long allocAddr = HeapDataManager.getInstance().getAllocatorAddrBySeqFromDB(seqNum);
        String allocPath = Global.getLibraryName(Global.getBinaryID(pid, time, allocAddr));
        this.fillAllocationFields(allocName, allocCallerAddr, allocCallerPath, allocAddr, allocPath, pid, tid, time);
        List<CallStackUnit> callStack = CallTraceDataManager.getInstance().getCallstackForTable(pid, tid, time);
        if (callStack == null || callStack.isEmpty()) {
            return;
        }
        if (allocCallerPath != null && allocCallerPath.equals(callStack.get(0).getPath())) {
            this.lastItem.setText(0, callStack.get(0).getFunctionName());
            this.lastItem.setData("caller address", (Object)callStack.get(0).getCallerAddress());
            this.lastItem.setData("address", (Object)callStack.get(0).getAddr());
            callStack.remove(0);
        }
        if (!callStack.isEmpty()) {
            this.fillCallstackFields(callStack);
        }
    }

    private boolean isSelectionValid(DASelectionData selData) {
        if (selData == null) {
            return false;
        }
        String viewId = selData.getViewID();
        if (!viewId.equals(MemoryPage.persistentAllocsViewID) && !viewId.equals(MemoryPage.leaksViewID)) {
            return false;
        }
        Object obj = selData.getData();
        if (!(obj instanceof GridItem[])) {
            return false;
        }
        GridItem[] items = (GridItem[])obj;
        if (items.length <= 0) {
            return false;
        }
        DATableDataFormat tableData = (DATableDataFormat)items[0].getData();
        return tableData.getType() == 4099;
    }

    private void fillAllocationFields(String allocName, long allocCallerAddr, String allocCallerPath, long allocAddr, String allocPath, int pid, int tid, long time) {
        DATableDataFormat callstackTableData = new DATableDataFormat(allocCallerAddr);
        callstackTableData.setType(4100);
        callstackTableData.setObject(allocCallerAddr);
        GridItem gridItem = this.createGridItem(callstackTableData, new CallStackUnit(allocAddr, allocCallerAddr, pid, tid, time, 0));
        gridItem.setText(0, allocName);
        gridItem.setText(1, allocAddr == 0L ? this.UNKNOWN : this.formatLongAddr(allocAddr));
        gridItem.setText(2, allocPath.isEmpty() ? this.UNKNOWN_LIBRARY : allocPath);
        gridItem = this.createGridItem(callstackTableData, new CallStackUnit(allocAddr, allocCallerAddr, pid, tid, time, 0));
        gridItem.setText(0, this.UNKNOWN);
        String addrInput = allocCallerAddr == 0L ? this.UNKNOWN : this.formatLongAddr(allocCallerAddr);
        gridItem.setText(1, addrInput);
        gridItem.setText(2, allocCallerPath);
    }

    private void fillCallstackFields(List<CallStackUnit> callStack) {
        int i = 0;
        while (i < callStack.size()) {
            String hexAddr = Formatter.toHexString("" + callStack.get(i).getAddr());
            CallStackUnit api = callStack.get(i);
            if (api == null) {
                Logger.debug((Object)("callstackunit for addr : " + hexAddr + " not found"));
                break;
            }
            if (api.getPath() == null) {
                Logger.debug((Object)("callstackunit for addr : " + hexAddr + " not filled"));
                break;
            }
            long address = api.getAddr();
            DATableDataFormat callstackTableData = new DATableDataFormat(address);
            callstackTableData.setType(4100);
            callstackTableData.setObject(address);
            GridItem gridItem = this.createGridItem(callstackTableData, api);
            String addrInput = address == 0L ? this.UNKNOWN : hexAddr;
            gridItem.setText(1, addrInput.toLowerCase());
            gridItem.setText(0, api.getFunctionName());
            gridItem.setText(2, api.getPath());
            ++i;
        }
    }

    private GridItem createGridItem(DATableDataFormat callstackTableData, CallStackUnit api) {
        GridItem gridItem = new GridItem(this.table, 0);
        gridItem.setData((Object)callstackTableData);
        gridItem.setData("address", (Object)api.getAddr());
        gridItem.setData("pid", (Object)api.getPid());
        gridItem.setData("time", (Object)api.getTime());
        gridItem.setData("libName", (Object)api.getPath());
        gridItem.setData("caller address", (Object)api.getCallerAddress());
        this.lastItem = gridItem;
        return gridItem;
    }

    private Object getMemAllocationDataByColumnIndex(List<Object> memAllocationData, int index) {
        if (memAllocationData != null && memAllocationData.get(index) != null) {
            return memAllocationData.get(index);
        }
        return null;
    }

    private long getCallerAddr(List<Object> memAllocationData, long seqNum) {
        List<Object> row = this.getAllocationInfo(seqNum);
        if (row != null) {
            return (Long)row.get(MemAllocDBTable.COLUMN.CALLER_PC_ADDRESS.index);
        }
        return -1L;
    }

    private List<Object> getAllocationInfo(long seqNum) {
        return HeapDataManager.getInstance().getAllocationRowBySeqFromDB(seqNum);
    }

    @Override
    protected List<TableInput> makeTableInput() {
        return null;
    }

    private String formatLongAddr(long addr) {
        return Formatter.toHexString(Long.toString(addr)).toLowerCase();
    }
}

