/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.notification;

import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.notification.DAPopupNotificationRenderer;
import org.tizen.dynamicanalyzer.widgets.notification.IPopupNotificationRenderer;

public class DAPopupNotification {
    private static final long NOTIFICATION_TIMEOUT_MILLIS = 3000L;
    private static final long FADE_OUT_STEP_MILLIS = 10L;
    private static final int VERTICAL_BOTTOM_OFFSET = 225;
    private static final int HEIGHT = 110;
    private static final int WIDTH = 320;
    private static final int DEFAULT_ALPHA = 230;
    private static final int FADE_OUT_STEPS = 100;
    private String title;
    private String message;
    private String details;
    private Shell shell = null;
    private IPopupNotificationRenderer renderer = new DAPopupNotificationRenderer();
    private MouseListener mouseListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            DAPopupNotification.this.close();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    };
    private PaintListener paintListener = e -> {
        if (this.title == null || this.title.isEmpty()) {
            Logger.warning((Object)"There is no title for notification!");
            this.close();
            return;
        }
        if (this.renderer == null) {
            Logger.warning((Object)"There is no render for notification!");
            this.shell.dispose();
            return;
        }
        this.renderer.draw(e.gc, this);
    };

    public DAPopupNotification(Shell parent, String title) {
        this(parent, title, null, null);
    }

    public DAPopupNotification(Shell parent, String title, String message) {
        this(parent, title, message, null);
    }

    public DAPopupNotification(Shell parent, String title, String message, String details) {
        this.title = title;
        this.message = message;
        this.details = details;
        this.shell = new Shell(parent, 524300);
        this.shell.setSize(320, 110);
        Point parentSize = parent.getSize();
        Point parentLoc = parent.getLocation();
        this.shell.setLocation((parentLoc.x + parentSize.x - 320) / 2, parentLoc.y + parentSize.y - 225);
        this.shell.addPaintListener(this.paintListener);
        this.shell.addMouseListener(this.mouseListener);
        this.shell.setAlpha(230);
        this.shell.setVisible(false);
        this.shell.setData((Object)this);
    }

    public void open() {
        if (this.shell == null || this.shell.isDisposed() || this.renderer == null) {
            return;
        }
        this.shell.setRegion(this.renderer.getVisibleRegion());
        this.shell.open();
        Thread closingThread = new Thread(() -> {
            block5: {
                try {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.warning((Object)"Interrupted while sleeping");
                        Thread.currentThread().interrupt();
                        Display.getDefault().syncExec(this::close);
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    Display.getDefault().syncExec(this::close);
                    throw throwable;
                }
                Display.getDefault().syncExec(this::close);
            }
        }, "DAPopupNotification closing thread");
        closingThread.start();
    }

    public void close() {
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        int curAlpha = this.shell.getAlpha();
        int alphaStep = curAlpha / 100;
        int i = 0;
        while (i < 100 && curAlpha > 0) {
            this.shell.setAlpha(curAlpha);
            this.shell.redraw();
            this.shell.update();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                Logger.warning((Object)"Interrupted while fading");
                Thread.currentThread().interrupt();
                break;
            }
            ++i;
            curAlpha -= alphaStep;
        }
        this.shell.close();
        this.shell.dispose();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title != null) {
            this.title = title;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void setRenderer(IPopupNotificationRenderer renderer) {
        if (renderer != null) {
            this.renderer = renderer;
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        this.shell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.shell.removeDisposeListener(listener);
    }

    public Point getLocation() {
        return this.shell.getLocation();
    }

    public void setLocation(Point location) {
        this.shell.setLocation(location);
    }

    public Point getSize() {
        return this.shell.getSize();
    }
}

