/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.common;

import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenshotDialog;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chart.DAScreenshotChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAUIEventChartPlot;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;
import org.tizen.dynamicanalyzer.widgets.timeline.MarkerManager;

public class TimelineChartMouseEventListener
extends MouseAdapter
implements MouseMoveListener {
    protected DAPopupMenu menu;
    protected DATimeline timeline;
    protected double baseTime = -1.0;
    protected String pageID;
    protected static final int SELECTION_MARKER_INDEX = 0;
    private static final int SCREENSHOT_DOT_WIDTH = 12;

    public TimelineChartMouseEventListener(DAPopupMenu menu, DATimeline timeline, String pageID) {
        this.menu = menu;
        this.timeline = timeline;
        this.pageID = pageID;
    }

    public void mouseDown(MouseEvent e) {
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartPlotMarker marker = (DAChartPlotMarker)plot.getMarkers().get(0);
        if (!(marker instanceof DAChartPlotIntervalMarker)) {
            return;
        }
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)marker;
        double eventTime = plot.getXFromXPixel(e.x);
        if (e.button == 3) {
            if (this.menu != null) {
                this.menu.getItems().forEach(item -> item.setDoubleData(eventTime));
            }
            return;
        }
        AnalyzerUtil.setLatestTraceMode(this.pageID, false);
        boolean bShift = false;
        if ((e.stateMask & 0x20000) != 0) {
            bShift = true;
        }
        if (plot instanceof DAScreenshotChartPlot) {
            DAChartSeries series;
            int screenshotIndex = this.getPointedScreenshotIndex(e);
            if (screenshotIndex != -1) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                ScreenshotDialog screenshotDialog = new ScreenshotDialog(shell);
                screenshotDialog.loadScreenshotData(screenshotIndex);
                screenshotDialog.open();
            }
            if ((series = chart.getSeries(0)) != null) {
                if (bShift && intervalMarker.getStartVal() != -1.0) {
                    if (this.baseTime > eventTime) {
                        intervalMarker.setInterval(eventTime, this.baseTime);
                    } else {
                        intervalMarker.setInterval(this.baseTime, eventTime);
                    }
                } else {
                    intervalMarker.setInterval(eventTime, eventTime);
                    this.baseTime = eventTime;
                }
            }
        } else if (bShift && intervalMarker.getStartVal() != -1.0) {
            if (this.baseTime > eventTime) {
                intervalMarker.setInterval(eventTime, this.baseTime);
            } else {
                intervalMarker.setInterval(this.baseTime, eventTime);
            }
        } else {
            intervalMarker.setInterval(eventTime, eventTime);
            this.baseTime = eventTime;
        }
        chart.redraw();
    }

    public void mouseUp(MouseEvent e) {
        double markerEndTime;
        double markerStartTime;
        int clickcount = e.count;
        if (e.button == 3) {
            return;
        }
        if (clickcount == 2) {
            return;
        }
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartPlotMarker marker = (DAChartPlotMarker)plot.getMarkers().get(0);
        if (!(marker instanceof DAChartPlotIntervalMarker)) {
            return;
        }
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)marker;
        double eventTime = plot.getXFromXPixel(e.x);
        if (intervalMarker.getStartVal() >= eventTime) {
            markerStartTime = eventTime;
            markerEndTime = intervalMarker.getEndVal();
        } else {
            markerStartTime = intervalMarker.getStartVal();
            markerEndTime = eventTime;
        }
        double toolbarTime = (double)Toolbar.INSTANCE.getTime() / 1000000.0;
        if (markerStartTime < 0.0) {
            markerStartTime = 0.0;
        } else if (markerStartTime > toolbarTime) {
            markerStartTime = toolbarTime;
        }
        if (markerEndTime > toolbarTime) {
            markerEndTime = toolbarTime;
        } else if (markerEndTime < 0.0) {
            markerEndTime = 0.0;
        }
        if (markerEndTime <= plot.getVisibleEndX()) {
            intervalMarker.setInterval(markerStartTime, markerEndTime);
        } else {
            intervalMarker.setInterval(markerStartTime, plot.getVisibleEndX());
        }
        this.sendSelectionTimes(intervalMarker.getStartVal(), intervalMarker.getEndVal());
    }

    public void mouseMove(MouseEvent e) {
        double newStartVal;
        double oldStartVal;
        double newYPosRatio;
        DAChartPlotTooltip tooltip;
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartPlotMarker marker = (DAChartPlotMarker)plot.getMarkers().get(0);
        if (!(marker instanceof DAChartPlotIntervalMarker)) {
            Logger.debug((Object)"mouseMove !IntervalMarker");
            return;
        }
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)marker;
        if ((e.stateMask & 0x80000) != 0) {
            double eventTime = plot.getXFromXPixel(e.x);
            if (this.baseTime > eventTime) {
                intervalMarker.setInterval(eventTime, this.baseTime);
            } else {
                intervalMarker.setInterval(this.baseTime, eventTime);
            }
        }
        if ((tooltip = plot.getTooltip()) == null) {
            return;
        }
        double oldYPosRatio = tooltip.getYPosRatio();
        if (Double.compare(oldYPosRatio, newYPosRatio = (double)e.y / (double)((Canvas)e.widget).getSize().y) != 0) {
            if (newYPosRatio < 0.0) {
                newYPosRatio = 0.01;
            } else if (newYPosRatio >= 1.0) {
                newYPosRatio = 0.99;
            }
            tooltip.setYPosRatio(newYPosRatio);
        }
        if ((oldStartVal = tooltip.getStartVal()) != (newStartVal = this.getTooltipStartX(plot, chart.getSeriesList(), e.x, newYPosRatio))) {
            tooltip.setStartVal(newStartVal);
        }
        if (plot instanceof DAScreenshotChartPlot) {
            if (this.getPointedScreenshotIndex(e) != -1) {
                Display.getCurrent().getCursorControl().setCursor(new Cursor((Device)Display.getCurrent(), 21));
            } else {
                Display.getCurrent().getCursorControl().setCursor(null);
            }
        } else if (plot instanceof DAUIEventChartPlot) {
            DAUIEventChartPlot uiEventChartPlot = (DAUIEventChartPlot)plot;
            int seriesIndex = (int)(newYPosRatio * (double)chart.getSeriesList().size());
            uiEventChartPlot.setHighlightedEventIndexX(((DAChartSeries)chart.getSeriesList().get(seriesIndex)).getPrevIndexByXvalue(plot.getXFromXPixel(e.x)));
            uiEventChartPlot.setHighlightedEventIndexY(seriesIndex);
            chart.redraw();
        }
        this.timeline.setDetailTime(plot.getXFromXPixel(e.x));
        this.timeline.setDetailTimePosition(e.x);
        this.timeline.setDrawDetailTime(true);
        this.timeline.redraw();
    }

    public void mouseDoubleClick(MouseEvent e) {
        DAChart daChart = (DAChart)e.widget;
        DAChartPlot plot = daChart.getPlot();
        double time = plot.getXFromXPixel(e.x);
        long longTime = (long)(time * 1000000.0);
        if (longTime <= Toolbar.INSTANCE.getTime()) {
            MarkerManager.INSTANCE.addMarker(time);
        }
    }

    private void sendSelectionTimes(double start, double end) {
        long endTime = (long)(end * 1000000.0);
        long startTime = (long)(start * 1000000.0);
        if (endTime < startTime) {
            long temp = startTime;
            startTime = endTime;
            endTime = temp;
        }
        if (startTime < 0L) {
            startTime = 0L;
        }
        Toolbar.INSTANCE.setChartDragStartTime(startTime);
        Toolbar.INSTANCE.setChartDragEndTime(endTime);
        Toolbar.INSTANCE.setDlogSelection(false);
        AnalyzerManager.getCurrentPage().updateView();
        AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(TimelinePage.timelineViewID, startTime, endTime, null, null));
    }

    protected int getHighlightedImageIndex(DAChartPlot plot, List<DAChartSeries> seriesList, int x) {
        if (plot instanceof DAScreenshotChartPlot) {
            DAChartSeries series = seriesList.get(0);
            return series.getPrevIndexByXvalue(plot.getXFromXPixel(x));
        }
        return -1;
    }

    private double getTooltipStartX(DAChartPlot plot, List<DAChartSeries> seriesList, int x, double yPosRatio) {
        double ret = -1.0;
        int i = 0;
        while (i < seriesList.size()) {
            DAChartSeries series;
            int index;
            if (plot instanceof DAUIEventChartPlot) {
                i = (int)((double)seriesList.size() * yPosRatio);
            }
            if (-1 == (index = (series = seriesList.get(i)).getPrevIndexByXvalue(plot.getXFromXPixel(x)))) {
                if (plot instanceof DAUIEventChartPlot) {
                    break;
                }
            } else {
                double startVal = ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getX();
                if (ret < startVal) {
                    ret = startVal;
                }
                if (plot instanceof DAUIEventChartPlot) break;
            }
            ++i;
        }
        return ret;
    }

    private int getHighlightedImageIndex(MouseEvent e) {
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartSeries series = (DAChartSeries)chart.getSeriesList().get(0);
        int index = series.getPrevIndexByXvalue(plot.getXFromXPixel(e.x));
        if (index < 0) {
            return -1;
        }
        DAChartSeriesItem item = (DAChartSeriesItem)series.getSeriesItemList().get(index);
        int screenshotWidth = item.getImage().getBounds().width;
        if (chart.getBounds().height != 79) {
            screenshotWidth /= 2;
        }
        if (e.x < plot.getXPixelFromX(item.getX()) + screenshotWidth && e.x >= plot.getXPixelFromX(item.getX())) {
            return index;
        }
        return -1;
    }

    private int getPointedScreenshotIndex(MouseEvent e) {
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartSeries series = (DAChartSeries)chart.getSeriesList().get(0);
        int index = -1;
        for (DAChartSeriesItem item : series.getSeriesItemList()) {
            if (e.x < plot.getXPixelFromX(item.getX()) - 12 || e.x > plot.getXPixelFromX(item.getX()) || e.y < 34 || e.y > 46) continue;
            index = series.getSeriesItemList().indexOf(item);
            break;
        }
        return index;
    }

    private Image getPointedScreenshotImage(MouseEvent e) {
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartSeries series = (DAChartSeries)chart.getSeriesList().get(0);
        int index = -1;
        for (DAChartSeriesItem item : series.getSeriesItemList()) {
            if (e.x < plot.getXPixelFromX(item.getX()) - 12 || e.x > plot.getXPixelFromX(item.getX()) || e.y < 34 || e.y > 46) continue;
            index = series.getSeriesItemList().indexOf(item);
        }
        if (index == -1) {
            return null;
        }
        return ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getImage();
    }

    private String getPointedScreenshotImagePath(MouseEvent e) {
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartSeries series = (DAChartSeries)chart.getSeriesList().get(0);
        int index = -1;
        for (DAChartSeriesItem item : series.getSeriesItemList()) {
            if (e.x < plot.getXPixelFromX(item.getX()) - 12 || e.x > plot.getXPixelFromX(item.getX()) || e.y < 34 || e.y > 46) continue;
            index = series.getSeriesItemList().indexOf(item);
        }
        if (index == -1) {
            return "Invalid Screenshot";
        }
        return ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getImagePath();
    }
}

