/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class TargetProcessDBTable
extends DBTable {
    private static final String TABLENAME = "TIMELINE_TARGET_PROCESS";
    public static final String SAMPLING_TIME = "SAMPLING_TIME";
    public static final String PID = "PID";
    public static final String CPU_LOAD = "CPU_LOAD";
    public static final String MEMORY_VIRTUAL = "MEMORY_VIRTUAL";
    public static final String MEMORY_RESIDENT = "MEMORY_RESIDENT";
    public static final String MEMORY_SHARED = "MEMORY_SHARED";
    public static final String MEMORY_PSS = "MEMORY_PSS";
    public static final String THREAD_COUNT = "THREAD_COUNT";
    public static final String HEAP_ALLOCATION_TOTAL_BYTE = "HEAP_ALLOCATION_TOTAL_BYTE";
    public static final String HEAP_ALLOCATION_BINARY_ID = "HEAP_ALLOCATION_BINARY_ID";
    public static final String HEAP_ALLOCATION_BYTE = "HEAP_ALLOCATION_BYTE";
    public static final String TID = "TID";
    public static final String THREAD_LOAD = "THREAD_LOAD";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public TargetProcessDBTable() {
        this.addColumn(new DBColumn(SAMPLING_TIME, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(PID, "", "INTEGER"));
        this.addColumn(new DBColumn(CPU_LOAD, "", "FLOAT"));
        this.addColumn(new DBColumn(MEMORY_VIRTUAL, "", "BIGINT"));
        this.addColumn(new DBColumn(MEMORY_RESIDENT, "", "BIGINT"));
        this.addColumn(new DBColumn(MEMORY_SHARED, "", "BIGINT"));
        this.addColumn(new DBColumn(MEMORY_PSS, "", "BIGINT"));
        this.addColumn(new DBColumn(THREAD_COUNT, "", "INTEGER"));
        this.addColumn(new DBColumn(HEAP_ALLOCATION_TOTAL_BYTE, "", "BIGINT"));
        this.addColumn(new DBColumn(HEAP_ALLOCATION_BINARY_ID, "", "INTEGER ARRAY"));
        this.addColumn(new DBColumn(HEAP_ALLOCATION_BYTE, "", "BIGINT ARRAY"));
        this.addColumn(new DBColumn(TID, "", "INTEGER ARRAY"));
        this.addColumn(new DBColumn(THREAD_LOAD, "", "DOUBLE ARRAY"));
        this.addIndex(COLUMN.SAMPLING_TIME.ordinal());
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                int index = 0;
                prep.setLong(++index, (Long)rowData.get(COLUMN.SAMPLING_TIME.ordinal()));
                prep.setInt(++index, (Integer)rowData.get(COLUMN.PID.ordinal()));
                prep.setFloat(++index, ((Float)rowData.get(COLUMN.CPU_LOAD.ordinal())).floatValue());
                prep.setLong(++index, (Long)rowData.get(COLUMN.MEMORY_VIRTUAL.ordinal()));
                prep.setLong(++index, (Long)rowData.get(COLUMN.MEMORY_RESIDENT.ordinal()));
                prep.setLong(++index, (Long)rowData.get(COLUMN.MEMORY_SHARED.ordinal()));
                prep.setLong(++index, (Long)rowData.get(COLUMN.MEMORY_PSS.ordinal()));
                prep.setInt(++index, (Integer)rowData.get(COLUMN.THREAD_COUNT.ordinal()));
                prep.setLong(++index, (Long)rowData.get(COLUMN.HEAP_ALLOCATION_TOTAL_BYTE.ordinal()));
                this.setArrayToPreparedStatement(COLUMN.HEAP_ALLOCATION_BINARY_ID.ordinal(), "INTEGER", prep, rowData);
                this.setArrayToPreparedStatement(COLUMN.HEAP_ALLOCATION_BYTE.ordinal(), "BIGINT", prep, rowData);
                this.setArrayToPreparedStatement(COLUMN.TID.ordinal(), "INTEGER", prep, rowData);
                this.setArrayToPreparedStatement(COLUMN.THREAD_LOAD.ordinal(), "FLOAT", prep, rowData);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getInt(2));
            row.add(Float.valueOf(rs.getFloat(3)));
            row.add(rs.getLong(4));
            row.add(rs.getLong(5));
            row.add(rs.getLong(6));
            row.add(rs.getLong(7));
            row.add(rs.getInt(8));
            row.add(rs.getLong(9));
            row.add(this.getArrayFromResultSet(rs, 10, 0));
            row.add(this.getArrayFromResultSet(rs, 11, 0L));
            row.add(this.getArrayFromResultSet(rs, 12, 0));
            row.add(this.getArrayFromResultSet(rs, 13, Float.valueOf(0.0f)));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SAMPLING_TIME,
        PID,
        CPU_LOAD,
        MEMORY_VIRTUAL,
        MEMORY_RESIDENT,
        MEMORY_SHARED,
        MEMORY_PSS,
        THREAD_COUNT,
        HEAP_ALLOCATION_TOTAL_BYTE,
        HEAP_ALLOCATION_BINARY_ID,
        HEAP_ALLOCATION_BYTE,
        TID,
        THREAD_LOAD;

    }
}

