/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.common;

import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.communicator.DeviceManager;
import org.tizen.dynamicanalyzer.handlers.CommandAction;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.UserErrorWarningLabels;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.workbench.SingletonFocusManager;

public class AutoStartManager
implements Runnable {
    private static final int MSG_INDEX_DEVICE = 1;
    private static final int MSG_INDEX_APPID = 2;
    private static final int MSG_INDEX_APPNAME = 3;
    private static final int MSG_INDEX_RESULTPATH = 4;
    private static final int MSG_INDEX_RESULTFILE = 5;
    private static final int MSG_LENGTH = 6;
    private static final int APPNAME_LENGTH = 20;
    private static boolean openWelcomeDlg = false;
    private static Boolean waitingWelcomeDlg = false;
    public static boolean isAutoClose = false;
    private static String[] strMsg = null;

    public static void autoStartApplication(String[] message) {
        strMsg = message;
        Thread thread = new Thread((Runnable)new AutoStartManager(), AutoStartManager.class.getSimpleName());
        thread.start();
    }

    public static boolean isOpenWelcomeDlg() {
        return openWelcomeDlg;
    }

    public static void setOpenWelcomeDlg(boolean data) {
        openWelcomeDlg = data;
    }

    public static Boolean getWaitingWelcomeDlg() {
        return waitingWelcomeDlg;
    }

    @Override
    public void run() {
        if (strMsg.length < 6) {
            Logger.debug((Object)"wrong message format!!");
            return;
        }
        if (strMsg[0].equals("AUTOCLOSE")) {
            isAutoClose = true;
        }
        Toolbar.INSTANCE.setAllControlState(false);
        final String deviceName = new String(strMsg[1].trim());
        final String appid = new String(strMsg[2].trim());
        String appName = new String(strMsg[3].trim());
        Logger.debug((Object)("auto start : " + appid));
        DeviceInfo device = DeviceManager.getDeviceByName(deviceName);
        Global.setCurrentDeviceInfo(device);
        if (device == null) {
            UIActionHolder.getUIAction().showWarning(UserErrorWarningLabels.ERROR_DEVICE_CONNECTION);
            Toolbar.INSTANCE.setAllControlState(true);
            return;
        }
        DACommunicator.updatePkgMapFromTarget();
        PackageInfo pkgInfo = device.getPkgInfoByAppID(appid);
        if (pkgInfo == null) {
            String name = appName;
            if (name.length() > 20) {
                name = String.valueOf(appName.substring(0, 19)) + "...";
            }
            UIActionHolder.getUIAction().showWarning(String.valueOf(name) + " " + UserErrorWarningLabels.ERROR_NONEXIST_APPLICATION);
            Toolbar.INSTANCE.setAllControlState(true);
            Logger.debug((Object)("invalid application name :" + appid));
            return;
        }
        Logger.debug((Object)("IDE recv - device: " + deviceName + " appid: " + appid));
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (Toolbar.INSTANCE.setDevice(deviceName)) {
                    if (Toolbar.INSTANCE.setApplicationByID(appid)) {
                        CommandAction.startTrace();
                    } else {
                        Logger.warning((Object)"Failed to set application to toolbar");
                    }
                } else {
                    Logger.warning((Object)"Failed to set device to toolbar");
                }
            }
        });
        SingletonFocusManager.setFocusToDA();
    }
}

