/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file.model;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.swap.model.data.FileData;

public class FileEvent
extends FileData {
    private int apiId = -1;
    private boolean target = false;
    private int lockType = -1;
    protected int fileId = -1;
    protected int accessorId = -1;

    public FileEvent() {
    }

    public FileEvent(long seq, int pid, int tid, long fd, String filePath, int apiType, long eventTime, long errNo, boolean target) {
        this.seq = seq;
        this.pid = pid;
        this.tid = tid;
        this.filePath = filePath;
        this.fdValue = fd;
        this.fdApiType = apiType;
        this.time = eventTime;
        this.target = target;
    }

    public FileEvent(long seq, String filePath, int pid, int tid, long fd, int apiType, int apiId, long eventTime, long fileSize, long size, String args, String returnVal, long errNo, boolean target) {
        this.seq = seq;
        this.filePath = filePath;
        this.pid = pid;
        this.tid = tid;
        this.fdValue = fd;
        this.fdApiType = apiType;
        this.apiId = apiId;
        this.time = eventTime;
        this.fileSize = fileSize;
        this.size = size;
        this.args = args;
        this.ret = returnVal;
        this.errno = errNo;
        this.target = target;
    }

    public FileEvent(long seq, String filePath, int pid, int tid, long fd, int apiType, int apiId, long eventTime, long fileSize, long size, String args, String returnVal, long errNo) {
        this.seq = seq;
        this.pid = pid;
        this.tid = tid;
        this.filePath = filePath;
        this.fdValue = fd;
        this.fdApiType = apiType;
        this.apiId = apiId;
        this.time = eventTime;
        this.fileSize = fileSize;
        this.size = size;
        this.args = args;
        this.ret = returnVal;
        this.errno = errNo;
    }

    public FileEvent(long seq, int accessorId, int fileId, long fd, int apiType, int apiId, long eventTime, long fileSize, long size, String args, String returnVal, long errNo) {
        this.seq = seq;
        this.fileId = fileId;
        this.accessorId = accessorId;
        this.fdValue = fd;
        this.fdApiType = apiType;
        this.apiId = apiId;
        this.time = eventTime;
        this.fileSize = fileSize;
        this.size = size;
        this.args = args;
        this.ret = returnVal;
        this.errno = errNo;
    }

    public List<Object> getDBData() {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(this.seq);
        data.add(this.fileId);
        data.add(this.accessorId);
        data.add(this.fdValue);
        data.add(this.fdApiType);
        data.add(this.time);
        data.add(this.apiId);
        data.add(this.errno);
        data.add(this.fileSize);
        data.add(this.size);
        data.add(this.ret);
        data.add(this.args);
        return data;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileName() {
        String[] splitPath = this.filePath.split("\\/");
        String fileName = new String(splitPath[splitPath.length - 1]);
        return fileName;
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    public void setPid(int pid) {
        this.pid = pid;
    }

    @Override
    public int getTid() {
        return this.tid;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public int getApiId() {
        return this.apiId;
    }

    @Override
    public void setApiId(int apiId) {
        this.apiId = apiId;
    }

    public boolean isTarget() {
        return this.target;
    }

    public void setTarget(boolean target) {
        this.target = target;
    }

    public void setLockType(int type) {
        this.lockType = type;
    }

    public int getLockType() {
        return this.lockType;
    }

    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    public int getFileId() {
        return this.fileId;
    }

    public int getAccessorId() {
        return this.accessorId;
    }

    public void setAccessorId(int accessorId) {
        this.accessorId = accessorId;
    }
}

