/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.failed;

import java.util.List;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;

public class FailedData {
    public static final int ID_INDEX = 1;
    public static final int SEQ_INDEX = 2;
    public static final int TIME_INDEX = 3;
    public static final int NAME_INDEX = 4;
    public static final int ARGS_INDEX = 5;
    public static final int RETURN_INDEX = 6;
    public static final int ERROR_INDEX = 7;
    public static final int CALLER_INDEX = 8;
    public static final int PID_INDEX = 9;
    public static final int LIB_NAME_INDEX = 10;
    private static int LogNum = 0;
    private LogData data;
    private int id = -1;
    private long seq = -1L;
    private long time = -1L;
    private String apiName = null;
    private String args = null;
    private String ret = null;
    private long err = -1L;
    private long callerPc = -1L;
    private int pid = -1;
    private String libName = null;

    public FailedData(LogData log) {
        this.id = log.getMsgID();
        this.seq = log.getSeq();
        this.time = log.getTime();
        ProbeCommonData plog = (ProbeCommonData)log;
        this.apiName = plog.getApiName();
        this.args = plog.getArgs();
        this.ret = plog.getReturn();
        this.err = plog.getErrno();
        this.callerPc = plog.getCallerPcAddr();
        this.data = log;
        this.pid = log.getPid();
        this.libName = plog.getLibName();
    }

    public FailedData(List<String> input) {
        if (input != null && !input.isEmpty()) {
            this.id = Integer.parseInt(input.get(1));
            this.seq = Long.parseLong(input.get(2));
            this.time = Long.parseLong(input.get(3));
            this.apiName = input.get(4);
            this.args = input.get(5);
            this.ret = input.get(6);
            this.err = Integer.parseInt(input.get(7));
            this.callerPc = Long.parseLong(input.get(8));
            this.pid = Integer.parseInt(input.get(9));
            this.libName = input.get(10);
        }
    }

    public static int getLogNum() {
        return LogNum++;
    }

    public int getId() {
        return this.id;
    }

    public long getSeq() {
        return this.seq;
    }

    public long getTime() {
        return this.time;
    }

    public String getName() {
        return this.apiName;
    }

    public String getArgs() {
        return this.args;
    }

    public String getReturn() {
        return this.ret;
    }

    public long getErrorCode() {
        return this.err;
    }

    public long getCallerPc() {
        return this.callerPc;
    }

    public LogData getData() {
        return this.data;
    }

    public void setData(LogData data) {
        this.data = data;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getLibName() {
        return this.libName;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }
}

