/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class ProfilingChildDataDBTable
extends DBTable {
    private static final String TABLENAME = "PROFILING_CHILD_DATA";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public ProfilingChildDataDBTable() {
        this.addColumn(new DBColumn(COLUMN.PROFILING_DATA_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.CHILD_SEQUENCE_ARRAY.name, "NOT NULL", "INTEGER ARRAY"));
    }

    public List<List<Object>> getProfilingChildDataFromDB() {
        return this.selectAllColumnData(null);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(COLUMN.PROFILING_DATA_ID.index + 1, (Integer)rowData.get(COLUMN.PROFILING_DATA_ID.index));
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                this.setArrayToPreparedStatement(COLUMN.CHILD_SEQUENCE_ARRAY.index, "INTEGER", prep, rowData);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getInt(1));
            row.add(rs.getInt(2));
            row.add(this.getArrayFromResultSet(rs, 3, 0));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        PROFILING_DATA_ID(0, "PROFILING_DATA_ID"),
        PID(1, "PID"),
        CHILD_SEQUENCE_ARRAY(2, "CHILD_SEQUENCE_ARRAY");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

