/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.tizen.dynamicanalyzer.util.Logger;

public class ImageUtil {
    public static void resize(String originFilePath, String newFilePath, int width, int height) {
        ImageUtil.resize(originFilePath, newFilePath, width, height, null);
    }

    public static void resize(String originFilePath, String newFilePath, int width, int height, Color color) {
        BufferedImage bufferedImage = null;
        BufferedImage targetBufferedImage = null;
        File image = new File(originFilePath);
        File destImage = new File(newFilePath);
        try {
            bufferedImage = ImageIO.read(image);
            if (bufferedImage == null) {
                return;
            }
            bufferedImage.getGraphics();
            Image scaledImage = bufferedImage.getScaledInstance(width, height, 1);
            targetBufferedImage = new BufferedImage(width, height, 1);
            Graphics g = targetBufferedImage.getGraphics();
            g.drawImage(scaledImage, 0, 0, null);
            if (color != null) {
                g.setColor(color);
                g.drawLine(0, 0, 0, 49);
                g.drawLine(0, 0, 49, 0);
                g.drawLine(49, 0, 49, 49);
                g.drawLine(0, 49, 49, 49);
            }
            g.dispose();
            ImageIO.write((RenderedImage)targetBufferedImage, "PNG", destImage);
        }
        catch (IOException io) {
            Logger.exception((Throwable)io);
        }
    }

    public static void transform(String originFilePath, String newFilePath, int width, int height, int angle) {
        BufferedImage bufferedImage = null;
        BufferedImage targetBufferedImage = null;
        File image = new File(originFilePath);
        File destImage = new File(newFilePath);
        try {
            bufferedImage = ImageIO.read(image);
            if (bufferedImage == null) {
                return;
            }
            bufferedImage.getGraphics();
            Image scaledImage = bufferedImage.getScaledInstance(width, height, 1);
            targetBufferedImage = new BufferedImage(width, height, 1);
            Graphics g = targetBufferedImage.getGraphics();
            g.drawImage(scaledImage, 0, 0, null);
            g.dispose();
            BufferedImage outputBufferedImage = targetBufferedImage;
            if (angle == 90) {
                outputBufferedImage = ImageUtil.rotateRight(targetBufferedImage);
            } else if (angle == 270) {
                outputBufferedImage = ImageUtil.rotateLeft(targetBufferedImage);
            } else if (angle == 180) {
                outputBufferedImage = ImageUtil.rotateRight(targetBufferedImage);
                outputBufferedImage = ImageUtil.rotateRight(outputBufferedImage);
            }
            ImageIO.write((RenderedImage)outputBufferedImage, "PNG", destImage);
        }
        catch (IOException io) {
            Logger.exception((Throwable)io);
        }
    }

    public static BufferedImage rotateRight(BufferedImage input) {
        int width = input.getWidth();
        int height = input.getHeight();
        BufferedImage output = new BufferedImage(height, width, input.getType());
        int i = 0;
        while (i < width) {
            int ii = 0;
            while (ii < height) {
                output.setRGB(height - ii - 1, i, input.getRGB(i, ii));
                ++ii;
            }
            ++i;
        }
        return output;
    }

    public static BufferedImage rotateLeft(BufferedImage input) {
        int width = input.getWidth();
        int height = input.getHeight();
        BufferedImage output = new BufferedImage(height, width, input.getType());
        int i = 0;
        while (i < width) {
            int ii = 0;
            while (ii < height) {
                output.setRGB(ii, width - i - 1, input.getRGB(i, ii));
                ++ii;
            }
            ++i;
        }
        return output;
    }
}

