/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.CompoundInstruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.symbols.ValueVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.TypeEngine;
import org.eclipse.core.runtime.CoreException;

public class OperatorCastValue
extends CompoundInstruction {
    private IASTCastExpression castExpr;
    private IType castType;

    public OperatorCastValue(int start, IType castType) {
        super(start);
        this.castType = castType;
    }

    public OperatorCastValue(int start, IASTCastExpression castExpr) {
        super(start);
        this.castExpr = castExpr;
    }

    @Override
    public void execute() throws CoreException {
        OperandValue value = this.fInterpreter.pop();
        if (value.getStringValue() != null) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.OperatorCast_CannotCastString);
        }
        this.castType = this.getCastType(this.fInterpreter.getTypeEngine());
        IVariableLocation location = value.getValueLocation();
        OperandValue castValue = new OperandValue(this.castType);
        if (location == null) {
            location = new ValueVariableLocation(value.getBigIntValue());
        }
        Number castedValue = castValue.getValueByType(this.castType, location);
        castValue.setValue(castedValue);
        castValue.setValueLocation(location);
        this.fInterpreter.push(castValue);
    }

    public IType getCastType(TypeEngine typeEngine) throws CoreException {
        if (this.castType == null) {
            IASTTypeId typeId = this.castExpr.getTypeId();
            this.castType = typeEngine.getTypeForTypeId(typeId);
        }
        return this.castType;
    }
}

