/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.tizen.common.util.ImageUtil;

public class HelpBrowser {
    private static final String HELP_PAGE_PREFIX = "help:/";
    private static final String BACK_ICON = "icons/back.gif";
    private static final String FORWARD_ICON = "icons/forward.gif";
    private Browser browser;

    public Browser getBrowser() {
        return this.browser;
    }

    public HelpBrowser(Composite parent, int style) {
        this(parent, style, false);
    }

    public HelpBrowser(Composite parent, int style, boolean hasToolbar) {
        if (hasToolbar) {
            this.generateToolBar(parent);
        }
        this.browser = new Browser(parent, style);
        GridData gd = new GridData(1808);
        this.browser.setLayoutData((Object)gd);
        this.enableHelpPage();
    }

    private void generateToolBar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0);
        ToolItem backButton = new ToolItem(toolbar, 8);
        Image backIcon = ImageUtil.getImage("org.tizen.common", BACK_ICON);
        backButton.setImage(backIcon);
        ToolItem forwardButton = new ToolItem(toolbar, 8);
        Image forwardIcon = ImageUtil.getImage("org.tizen.common", FORWARD_ICON);
        forwardButton.setImage(forwardIcon);
        forwardButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HelpBrowser.this.browser.forward();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        backButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HelpBrowser.this.browser.back();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void enableHelpPage() {
        this.getBrowser().addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                String url = event.location;
                if (url.startsWith(HelpBrowser.HELP_PAGE_PREFIX)) {
                    Browser browser = (Browser)event.widget;
                    String tempUrl = url.substring(HelpBrowser.HELP_PAGE_PREFIX.length(), url.length());
                    IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
                    browser.setUrl(helpSystem.resolve(tempUrl, false).toString());
                }
            }

            public void changed(LocationEvent event) {
            }
        });
    }
}

