/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.TizenAbstractButtonRenderer;
import org.eclipse.swt.custom.TizenArrowButtonRenderer;
import org.eclipse.swt.custom.TizenButtonAttribute;
import org.eclipse.swt.custom.TizenCheckBoxButtonRenderer;
import org.eclipse.swt.custom.TizenPushButtonRenderer;
import org.eclipse.swt.custom.TizenRadioButtonRenderer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class TizenButton
extends Canvas {
    protected TizenButtonAttribute attr = new TizenButtonAttribute();
    private TizenAbstractButtonRenderer buttonRenderer = null;

    public TizenButton(Composite parent, int style) {
        super(parent, style | 0x20000000);
        switch (this.getType(style)) {
            case 16: {
                this.buttonRenderer = new TizenRadioButtonRenderer(this, parent);
                break;
            }
            case 32: {
                this.buttonRenderer = new TizenCheckBoxButtonRenderer(this, parent);
                break;
            }
            case 4: {
                this.buttonRenderer = new TizenArrowButtonRenderer(this, parent, style);
                break;
            }
            case 8: {
                this.buttonRenderer = new TizenPushButtonRenderer(this, parent);
                break;
            }
            default: {
                this.buttonRenderer = new TizenPushButtonRenderer(this, parent);
            }
        }
        this.addEventListener(this.buttonRenderer.getMouseListener());
    }

    protected boolean isEqualsType(int style, int cmpStyle) {
        int bits = 62;
        return (style & bits) == cmpStyle;
    }

    protected int getType(int style) {
        int bits = 62;
        return style & bits;
    }

    public void addEventListener(Listener listener) {
        this.addListener(13, listener);
        this.addListener(6, listener);
        this.addListener(7, listener);
        this.addListener(4, listener);
        this.addListener(3, listener);
        this.addListener(9, listener);
        this.addListener(12, listener);
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 16: {
                        e.doit = true;
                    }
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                TizenButton.this.buttonRenderer.setFocus();
            }
        });
        this.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                TizenButton.this.buttonRenderer.removeFocus();
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                switch (e.character) {
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        TizenButton.this.redraw();
                        TizenButton.this.fireSelectionEvent();
                    }
                }
            }
        });
    }

    protected void fireSelectionEvent() {
        Event e = new Event();
        e.item = this;
        e.widget = this;
        e.type = 13;
        this.notifyListeners(13, e);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addListener(13, new TypedListener(listener));
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeListener(13, listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point computedSize = this.buttonRenderer.computeSize(this, wHint, hHint, changed);
        if (wHint != -1) {
            computedSize.x = wHint;
        }
        if (hHint != -1) {
            computedSize.y = hHint;
        }
        return computedSize;
    }

    protected void setButtonState(int state) {
        this.buttonRenderer.setButtonState(state);
    }

    protected TizenButtonAttribute getAttribute() {
        return this.attr;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.redraw();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.buttonRenderer.setEnabled(enabled);
    }

    public void setBackground(Color color) {
        this.buttonRenderer.setBackground(color);
    }

    public Color getBackground() {
        Color bgColor = this.attr.getBackGroundcolor(this.buttonRenderer.getButtonState());
        if (bgColor == null) {
            return super.getBackground();
        }
        return bgColor;
    }

    public void setForeground(Color color) {
        this.buttonRenderer.setForeground(color);
    }

    public Color getForeground() {
        return this.attr.getForeGroundcolor(this.buttonRenderer.getButtonState());
    }

    public String getText() {
        return this.attr.getText();
    }

    public void setText(String text) {
        this.attr.setText(text);
    }

    public void setImage(Image image) {
        this.attr.setImage(image);
        this.redraw();
    }

    public Image getImage() {
        return this.attr.getImage(this.buttonRenderer.getButtonState());
    }

    public void setBackgroundImage(Image image) {
        this.attr.setImage(image);
    }

    public void setFont(Font font) {
        this.attr.setFont(font);
    }

    public void setAlignment(int align) {
        this.attr.setAlign(align);
    }

    public int getAlignment() {
        return this.attr.getAlign();
    }

    public void setSelection(boolean selected) {
        this.buttonRenderer.setSelection(selected);
    }

    public boolean setFocus() {
        super.setFocus();
        return true;
    }

    public boolean getSelection() {
        return this.buttonRenderer.getSelection();
    }

    public void setDefault(boolean b) {
        super.setFocus();
    }

    public void click() {
    }

    public void setGrayed(boolean grayed) {
        if (!this.isEqualsType(this.getStyle(), 32)) {
            return;
        }
    }

    public boolean getGrayed() {
        return false;
    }
}

