/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;

public abstract class EFSExtensionProvider {
    public String getPathFromURI(URI locationURI) {
        return locationURI.getPath();
    }

    public URI getLinkedURI(URI locationURI) {
        return locationURI;
    }

    public URI createNewURIFromPath(URI locationOnSameFilesystem, String path) {
        URI uri = locationOnSameFilesystem;
        Path p = new Path(path);
        String pathString = p.toString();
        int length = pathString.length();
        StringBuffer pathBuf = new StringBuffer(length + 1);
        if (length > 0 && pathString.charAt(0) != '/') {
            pathBuf.append('/');
        }
        if (pathString.startsWith("//")) {
            pathBuf.append('/').append('/');
        }
        pathBuf.append(pathString);
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), pathBuf.toString(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public String getMappedPath(URI locationURI) {
        return this.getPathFromURI(locationURI);
    }

    public boolean isVirtual(URI locationURI) {
        return false;
    }

    public URI append(URI baseURI, String extension) {
        return URIUtil.append((URI)baseURI, (String)extension);
    }
}

