/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.ArrayList;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationCtx;
import org.eclipse.cdt.internal.core.parser.scanner.InactiveCodeToken;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeSearchPathElement;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.Token;
import org.eclipse.cdt.internal.core.parser.scanner.TokenList;

final class ScannerContext {
    private CodeState fInactiveState = CodeState.eSkipInactive;
    private final ILocationCtx fLocationCtx;
    private final ScannerContext fParent;
    private final Lexer fLexer;
    private Token fTokens;
    private ArrayList<Conditional> fConditionals = null;
    private CodeState fCurrentState = CodeState.eActive;
    private IncludeSearchPathElement fFoundOnPath;
    private String fFoundViaDirective;

    public ScannerContext(ILocationCtx ctx, ScannerContext parent, Lexer lexer) {
        this.fLocationCtx = ctx;
        this.fParent = parent;
        this.fLexer = lexer;
    }

    public ScannerContext(ILocationCtx ctx, ScannerContext parent, TokenList tokens) {
        this(ctx, parent, (Lexer)null);
        this.fTokens = tokens.first();
        this.fInactiveState = CodeState.eSkipInactive;
    }

    public void setParseInactiveCode(boolean val) {
        this.fInactiveState = val ? CodeState.eParseInactive : CodeState.eSkipInactive;
    }

    public final ILocationCtx getLocationCtx() {
        return this.fLocationCtx;
    }

    public final ScannerContext getParent() {
        return this.fParent;
    }

    public final Lexer getLexer() {
        return this.fLexer;
    }

    public final Conditional newBranch(BranchKind branchKind, boolean withinExpansion) {
        if (this.fConditionals == null) {
            this.fConditionals = new ArrayList();
        }
        if (branchKind == BranchKind.eIf) {
            Conditional result = new Conditional(this.fCurrentState);
            this.fConditionals.add(result);
            return result;
        }
        int pos = this.fConditionals.size() - 1;
        if (pos < 0) {
            return null;
        }
        if (branchKind == BranchKind.eEnd) {
            Conditional result = this.fConditionals.remove(pos);
            return result;
        }
        Conditional result = this.fConditionals.get(pos);
        if (result.fLast == BranchKind.eElse) {
            return null;
        }
        result.fLast = branchKind;
        return result;
    }

    private void changeState(CodeState state, BranchKind kind, boolean withinExpansion, int offset) {
        if (!withinExpansion) {
            block0 : switch (state) {
                case eActive: {
                    if (this.fCurrentState != CodeState.eParseInactive) break;
                    this.stopInactive(offset, kind);
                    break;
                }
                case eParseInactive: {
                    switch (this.fCurrentState) {
                        case eActive: {
                            this.startInactive(offset, kind);
                            break block0;
                        }
                        case eParseInactive: {
                            this.separateInactive(offset, kind);
                            break block0;
                        }
                        case eSkipInactive: {
                            assert (false);
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        this.fCurrentState = state;
    }

    private void startInactive(int offset, BranchKind kind) {
        int nesting = this.getCodeBranchNesting();
        int oldNesting = this.getOldNestingLevel(kind, nesting);
        this.fTokens = new InactiveCodeToken(145, oldNesting, nesting, offset);
    }

    private void separateInactive(int offset, BranchKind kind) {
        int nesting = this.getCodeBranchNesting();
        int oldNesting = this.getOldNestingLevel(kind, nesting);
        this.fTokens = new InactiveCodeToken(146, oldNesting, nesting, offset);
    }

    private int getOldNestingLevel(BranchKind kind, int nesting) {
        switch (kind) {
            case eIf: {
                return nesting - 1;
            }
            case eElif: 
            case eElse: {
                return nesting;
            }
            case eEnd: {
                return nesting + 1;
            }
        }
        return nesting;
    }

    private void stopInactive(int offset, BranchKind kind) {
        int nesting = this.getCodeBranchNesting();
        int oldNesting = this.getOldNestingLevel(kind, nesting);
        this.fTokens = new InactiveCodeToken(147, oldNesting, nesting, offset);
    }

    public CodeState getCodeState() {
        return this.fCurrentState;
    }

    public CodeState setBranchState(Conditional cond, boolean isActive, boolean withinExpansion, int offset) {
        CodeState newState;
        if (isActive) {
            cond.fTakeElse = false;
            newState = cond.fInitialState;
        } else {
            newState = withinExpansion ? CodeState.eParseInactive : this.fInactiveState;
        }
        this.changeState(newState, cond.fLast, withinExpansion, offset);
        return newState;
    }

    public CodeState setBranchEndState(Conditional cond, boolean withinExpansion, int offset) {
        CodeState newState = cond != null ? cond.fInitialState : CodeState.eActive;
        this.changeState(newState, BranchKind.eEnd, withinExpansion, offset);
        return newState;
    }

    public final Token currentLexerToken() {
        if (this.fTokens != null) {
            return this.fTokens;
        }
        if (this.fLexer != null) {
            return this.fLexer.currentToken();
        }
        return new Token(144, null, 0, 0);
    }

    public Token nextPPToken() throws OffsetLimitReachedException {
        if (this.fTokens != null) {
            this.fTokens = (Token)this.fTokens.getNext();
            return this.currentLexerToken();
        }
        if (this.fLexer != null) {
            return this.fLexer.nextToken();
        }
        return new Token(144, null, 0, 0);
    }

    public int consumeLine(int originPreprocessorDirective) throws OffsetLimitReachedException {
        if (this.fLexer != null) {
            return this.fLexer.consumeLine(originPreprocessorDirective);
        }
        return -1;
    }

    public void clearInactiveCodeMarkerToken() {
        this.fTokens = null;
    }

    public int getCodeBranchNesting() {
        if (this.fConditionals == null) {
            return 0;
        }
        return this.fConditionals.size();
    }

    public IncludeSearchPathElement getFoundOnPath() {
        return this.fFoundOnPath;
    }

    public String getFoundViaDirective() {
        return this.fFoundViaDirective;
    }

    public void setFoundOnPath(IncludeSearchPathElement foundOnPath, String viaDirective) {
        this.fFoundOnPath = foundOnPath;
        this.fFoundViaDirective = viaDirective;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BranchKind {
        eIf,
        eElif,
        eElse,
        eEnd;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CodeState {
        eActive,
        eParseInactive,
        eSkipInactive;

    }

    static final class Conditional {
        private CodeState fInitialState;
        private BranchKind fLast;
        private boolean fTakeElse = true;

        Conditional(CodeState state) {
            this.fInitialState = state;
            this.fLast = BranchKind.eIf;
        }

        boolean canHaveActiveBranch(boolean withinExpansion) {
            return this.fTakeElse && (this.fInitialState == CodeState.eActive || withinExpansion);
        }
    }
}

