/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.breadcrumb;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.BreadcrumbItem;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.BreadcrumbViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractBreadcrumb {
    private BreadcrumbViewer fBreadcrumbViewer;
    private boolean fHasFocus;
    private Composite fComposite;
    private Listener fDisplayFocusListener;
    private Listener fDisplayKeyListener;

    protected abstract Object getCurrentInput();

    protected abstract BreadcrumbViewer createViewer(Composite var1);

    protected abstract boolean open(ISelection var1);

    protected abstract void activateBreadcrumb();

    protected abstract void deactivateBreadcrumb();

    public ISelectionProvider getSelectionProvider() {
        return this.fBreadcrumbViewer;
    }

    public void setInput(Object element) {
        if (element == null || this.fBreadcrumbViewer == null || this.fBreadcrumbViewer.getControl().isDisposed()) {
            return;
        }
        Object input = this.fBreadcrumbViewer.getInput();
        if (input == element || element.equals(input)) {
            this.refresh();
            return;
        }
        this.fBreadcrumbViewer.setInput(element);
    }

    protected void refresh() {
        if (!this.fBreadcrumbViewer.getControl().isDisposed()) {
            this.fBreadcrumbViewer.refresh();
        }
    }

    public void activate() {
        if (this.fBreadcrumbViewer.getSelection().isEmpty()) {
            this.fBreadcrumbViewer.setSelection((ISelection)new StructuredSelection(this.fBreadcrumbViewer.getInput()));
        }
        this.fBreadcrumbViewer.setFocus();
    }

    public boolean isActive() {
        return true;
    }

    public Control createContent(Composite parent) {
        Assert.isTrue((this.fComposite == null ? 1 : 0) != 0, (String)"Content must only be created once.");
        boolean rtl = (parent.getShell().getStyle() & 0x4000000) != 0;
        this.fComposite = new Composite(parent, rtl ? 0x4000000 : 0);
        GridData data = new GridData(4, 128, true, false);
        this.fComposite.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.fComposite.setLayout((Layout)gridLayout);
        this.fDisplayFocusListener = new Listener(){

            public void handleEvent(Event event) {
                if (AbstractBreadcrumb.this.fComposite.isDisposed()) {
                    return;
                }
                if (AbstractBreadcrumb.this.isBreadcrumbEvent(event)) {
                    if (AbstractBreadcrumb.this.fHasFocus) {
                        return;
                    }
                    AbstractBreadcrumb.this.focusGained();
                } else {
                    if (!AbstractBreadcrumb.this.fHasFocus) {
                        return;
                    }
                    AbstractBreadcrumb.this.focusLost();
                }
            }
        };
        Display.getCurrent().addFilter(15, this.fDisplayFocusListener);
        this.fBreadcrumbViewer = this.createViewer(this.fComposite);
        this.fBreadcrumbViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element == null) {
                    return;
                }
                BreadcrumbItem item = (BreadcrumbItem)AbstractBreadcrumb.this.fBreadcrumbViewer.doFindItem(element);
                if (item == null) {
                    return;
                }
                item.openDropDownMenu();
            }
        });
        this.fBreadcrumbViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                AbstractBreadcrumb.this.doOpen(event.getSelection());
            }
        });
        return this.fComposite;
    }

    public void dispose() {
        if (this.fDisplayFocusListener != null) {
            Display.getDefault().removeFilter(15, this.fDisplayFocusListener);
        }
        this.deinstallDisplayListeners();
    }

    private void doOpen(ISelection selection) {
        if (this.open(selection)) {
            this.fBreadcrumbViewer.setInput(this.getCurrentInput());
        }
    }

    private void focusGained() {
        if (this.fHasFocus) {
            this.focusLost();
        }
        this.fHasFocus = true;
        this.installDisplayListeners();
        this.activateBreadcrumb();
    }

    private void focusLost() {
        this.fHasFocus = false;
        this.deinstallDisplayListeners();
        this.deactivateBreadcrumb();
    }

    private void installDisplayListeners() {
        this.deinstallDisplayListeners();
        this.fDisplayKeyListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode != 27) {
                    return;
                }
                if (!AbstractBreadcrumb.this.isBreadcrumbEvent(event)) {
                    return;
                }
            }
        };
        Display.getDefault().addFilter(1, this.fDisplayKeyListener);
    }

    private void deinstallDisplayListeners() {
        if (this.fDisplayKeyListener != null) {
            Display.getDefault().removeFilter(1, this.fDisplayKeyListener);
            this.fDisplayKeyListener = null;
        }
    }

    private boolean isBreadcrumbEvent(Event event) {
        if (this.fBreadcrumbViewer == null) {
            return false;
        }
        Widget item = event.widget;
        if (!(item instanceof Control)) {
            return false;
        }
        Shell dropDownShell = this.fBreadcrumbViewer.getDropDownShell();
        if (dropDownShell != null && this.isChild((Control)item, (Control)dropDownShell)) {
            return true;
        }
        return this.isChild((Control)item, this.fBreadcrumbViewer.getControl());
    }

    private boolean isChild(Control child, Control parent) {
        if (child == null) {
            return false;
        }
        if (child == parent) {
            return true;
        }
        return this.isChild((Control)child.getParent(), parent);
    }
}

