/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TizenResourceManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class TizenCombo
extends CCombo {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_PUSH = 1;
    private static final int STATE_HOVER = 2;
    private static final int STATE_DISABLE = 3;
    private int comboState = 0;
    private boolean isEnterWidget = false;
    public static final int LIMIT = 65535;

    public TizenCombo(Composite parent, int style) {
        super(parent, TizenCombo.removeBorderStyle(style | 0x20000000));
        super.setLayout(new GridLayout(2, false));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.text.setLayoutData(gridData);
        this.text.setFont(TizenResourceManager.NORMAL_FONT);
        this.arrow.setLayoutData(new GridData(4));
        this.addEventListener();
    }

    static int removeBorderStyle(int style) {
        if ((style & 0x800) != 0) {
            return style - 2048;
        }
        return style;
    }

    private void addEventListener() {
        this.addListener(6, new Listener(){

            public void handleEvent(Event e) {
                TizenCombo.this.comboState = 2;
                if (!TizenCombo.this.isEnterWidget) {
                    TizenCombo.this.redraw();
                }
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                TizenCombo.this.comboState = 1;
                TizenCombo.this.redraw();
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                TizenCombo.this.comboState = 0;
                TizenCombo.this.redraw();
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                TizenCombo.this.comboState = 1;
                TizenCombo.this.redraw();
            }
        });
        this.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                TizenCombo.this.comboState = 0;
                TizenCombo.this.redraw();
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TizenCombo.this.comboState = 2;
                TizenCombo.this.redraw();
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event e) {
                Point cursorLocationOfDisplay = Display.getCurrent().getCursorLocation();
                Point cursorLocationOfWidget = TizenCombo.this.getParent().toControl(cursorLocationOfDisplay);
                if (TizenCombo.this.getBounds().contains(cursorLocationOfWidget)) {
                    TizenCombo.this.isEnterWidget = true;
                }
            }
        });
        this.getParent().addListener(6, new Listener(){

            public void handleEvent(Event e) {
                if (TizenCombo.this.comboState == 2) {
                    TizenCombo.this.comboState = 0;
                    TizenCombo.this.redraw();
                }
            }
        });
        this.getParent().addListener(5, new Listener(){

            public void handleEvent(Event e) {
                Point cursorLocationOfDisplay = Display.getCurrent().getCursorLocation();
                Point cursorLocationOfWidget = TizenCombo.this.getParent().toControl(cursorLocationOfDisplay);
                if (!TizenCombo.this.getBounds().contains(cursorLocationOfWidget)) {
                    TizenCombo.this.isEnterWidget = false;
                }
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TizenCombo.this.paint(e);
            }
        });
    }

    private void paint(PaintEvent event) {
        GC gc = event.gc;
        Rectangle rect = this.getClientArea();
        this.changeWidgetColor();
        this.drawBorder(gc, rect);
    }

    private void drawBorder(GC gc, Rectangle rect) {
        Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
        this.setBorderColor(gc);
        gc.drawRectangle(r);
    }

    private void setBorderColor(GC gc) {
        switch (this.comboState) {
            case 0: {
                gc.setForeground(TizenResourceManager.COMBO_LINE_NORMAL_COLOR);
                break;
            }
            case 1: {
                gc.setForeground(TizenResourceManager.COMBO_LINE_PUSH_COLOR);
                break;
            }
            case 2: {
                gc.setForeground(TizenResourceManager.COMBO_LINE_HOVER_COLOR);
                break;
            }
            case 3: {
                gc.setForeground(TizenResourceManager.COMBO_LINE_DISABLE_COLOR);
            }
        }
    }

    private void changeWidgetColor() {
        switch (this.comboState) {
            case 0: {
                this.text.setBackground(this.getBackground());
                this.text.setForeground(TizenResourceManager.COMBO_FONT_NORMAL_COLOR);
                this.arrow.setBackground(this.getBackground());
                this.arrow.setForeground(TizenResourceManager.COMBO_LINE_NORMAL_COLOR);
                break;
            }
            case 1: {
                this.text.setBackground(this.getBackground());
                this.text.setForeground(TizenResourceManager.COMBO_FONT_PUSH_COLOR);
                this.arrow.setBackground(this.getBackground());
                this.arrow.setForeground(TizenResourceManager.COMBO_LINE_PUSH_COLOR);
                break;
            }
            case 2: {
                this.text.setBackground(this.getBackground());
                this.text.setForeground(TizenResourceManager.COMBO_FONT_HOVER_COLOR);
                this.arrow.setBackground(this.getBackground());
                this.arrow.setForeground(TizenResourceManager.COMBO_LINE_HOVER_COLOR);
                break;
            }
            case 3: {
                this.text.setBackground(this.getBackground());
                this.text.setForeground(TizenResourceManager.COMBO_FONT_DISABLE_COLOR);
                this.arrow.setBackground(this.getBackground());
                this.arrow.setForeground(TizenResourceManager.COMBO_LINE_DISABLE_COLOR);
            }
        }
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.getStyle() & 8) != 0) {
            return 0;
        }
        return this.text.getCaretLocation().x;
    }

    public void addSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener != null) {
            this.addListener(49, new TypedListener(listener));
        }
    }

    public void removeSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener != null) {
            this.removeListener(49, listener);
        }
    }
}

