/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.common;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;
import org.tizen.dynamicanalyzer.widgets.timeline.MarkerManager;

public class ChartPopupMenu
extends DAPopupMenu {
    public ChartPopupMenu(DAChart parent) {
        super((Composite)parent);
        DAPopupMenuItem selectRangeItem = new DAPopupMenuItem((DAPopupMenu)this);
        selectRangeItem.setText(AnalyzerLabels.SELECT_RANGE);
        selectRangeItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ChartPopupMenu.this.setRangeFromMarkerList(menuItem.getDoubleData());
            }
        });
    }

    private void setRangeFromMarkerList(double time) {
        double endTime;
        double startTime;
        List markers = MarkerManager.INSTANCE.getMarkerTimeList();
        if (markers.isEmpty() || markers.contains(time)) {
            return;
        }
        int findIndex = -1;
        int i = 0;
        while (i < markers.size()) {
            if ((Double)markers.get(i) > time) {
                findIndex = i;
                break;
            }
            ++i;
        }
        DAChart parentChart = (DAChart)this.getParent();
        if (findIndex == 0) {
            startTime = 0.0;
            endTime = (Double)markers.get(findIndex);
        } else if (findIndex == -1) {
            startTime = (Double)markers.get(markers.size() - 1);
            endTime = parentChart.getPlot().getValidEndX();
        } else {
            startTime = (Double)markers.get(findIndex - 1);
            endTime = (Double)markers.get(findIndex);
        }
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)parentChart.getPlot().getMarkers().get(0);
        intervalMarker.setInterval(startTime, endTime);
        AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData("", (long)(startTime * 1000000.0), (long)(endTime * 1000000.0), null, null));
    }
}

