/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataProcessor;
import org.tizen.dynamicanalyzer.ui.memory.data.util.Query;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.util.Logger;

public class MemoryStatisticsTable
extends DATreeComposite {
    private int[] columnSizes = new int[]{265, 140, 90, 90, 90, 110, 15};
    private int[] columnAlignment = new int[]{16384, 131072, 131072, 131072, 131072, 131072, 131072};
    private Long StartTime;
    private Long EndTime;
    Query lastPartQuery = null;
    CompletableFuture<List<TreeInput>> partStatisticsTask = null;
    CompletableFuture<List<TreeInput>> wholeStatisticsTask = null;
    List<TreeInput> processingStub;
    private String[] columnNames = new String[]{MemoryPageLabels.MEMORY_STATISTICS_VIEW_PATH, MemoryPageLabels.MEMORY_STATISTICS_VIEW_TOTAL, MemoryPageLabels.MEMORY_STATISTICS_VIEW_FREED, MemoryPageLabels.MEMORY_STATISTICS_VIEW_PERSISTENT, MemoryPageLabels.MEMORY_STATISTICS_VIEW_TOTAL_BYTE, MemoryPageLabels.MEMORY_STATISTICS_VIEW_PERSISTENT_BYTE, ""};
    private int[] sortTypes;

    public MemoryStatisticsTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        int[] nArray = new int[7];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        this.sortTypes = nArray;
        this.StartTime = 0L;
        this.EndTime = 0L;
        this.setTableName(MemoryPageLabels.MEMORY_STATISTICS_VIEW_TITLE);
        this.setComparator(new DefaultTableComparator());
        this.setTree(true);
        this.setSortTypes(this.sortTypes);
        this.setColumnAlignment(this.columnAlignment);
        this.setColumns(this.columnNames);
        this.setColumnSize(this.columnSizes);
        this.setTableToolTipEnable(false);
        this.comparator.setType(1);
        this.comparator.setColumn(1);
        this.processingStub = Arrays.asList(this.makeProcessingStub());
    }

    private TreeInput makeProcessingStub() {
        DATableDataFormat tableData = new DATableDataFormat(0L);
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        text.add(AnalyzerLabels.TABLE_PROCESSING_DATA);
        data.add("");
        text.add("");
        data.add(0);
        text.add("");
        data.add(0);
        text.add("");
        data.add(0);
        text.add("");
        data.add(0);
        text.add("");
        data.add(0);
        tableData.getData().addAll(data);
        tableData.setObject(AnalyzerLabels.TABLE_PROCESSING_DATA);
        TreeInput output = new TreeInput();
        output.setText(text);
        output.setData(tableData);
        return output;
    }

    public void setSelectionRange(Long start, Long end) {
        this.StartTime = start;
        this.EndTime = end;
    }

    public boolean isSelectionPerformed() {
        return this.StartTime != this.EndTime;
    }

    private List<TreeInput> makeIntervalTableInput() throws InterruptedException, ExecutionException {
        Query newQuery = new Query(this.StartTime, this.EndTime);
        if (newQuery.equals(this.lastPartQuery)) {
            if (this.partStatisticsTask.isDone()) {
                return this.partStatisticsTask.get();
            }
        } else {
            this.lastPartQuery = newQuery;
            if (this.partStatisticsTask != null) {
                this.partStatisticsTask.cancel(true);
            }
            this.partStatisticsTask = CompletableFuture.supplyAsync(() -> HeapDataProcessor.getInstance().getTreeInputStatisticsData(new Query(this.StartTime, this.EndTime)));
            this.partStatisticsTask.thenRun(() -> Display.getDefault().asyncExec(this::updateTree));
        }
        return this.processingStub;
    }

    private List<TreeInput> makeFullTableInput() throws InterruptedException, ExecutionException {
        if (DAState.isDone()) {
            if (this.wholeStatisticsTask == null) {
                this.wholeStatisticsTask = CompletableFuture.supplyAsync(() -> HeapDataProcessor.getInstance().getTreeInputStatisticsData(new Query(0L, 0L)));
                this.wholeStatisticsTask.thenRun(() -> Display.getDefault().asyncExec(this::updateTree));
            }
            if (this.wholeStatisticsTask.isDone()) {
                return this.wholeStatisticsTask.get();
            }
            return this.processingStub;
        }
        return Collections.emptyList();
    }

    @Override
    public List<TreeInput> makeTreeInput() {
        if (Global.getProject() == null) {
            return Collections.emptyList();
        }
        try {
            if (this.StartTime != 0L || this.EndTime != 0L) {
                return this.makeIntervalTableInput();
            }
            return this.makeFullTableInput();
        }
        catch (InterruptedException | ExecutionException e) {
            Logger.error((Object)e);
            return Collections.emptyList();
        }
    }

    public void removeSelection() {
        this.table.removeAll();
        this.updateTable();
    }

    @Override
    public void clear() {
        this.table.removeAll();
        this.getSelectionIndex().clear();
        this.getSelections().clear();
        this.StartTime = 0L;
        this.EndTime = 0L;
        this.lastPartQuery = null;
        this.partStatisticsTask = null;
        this.wholeStatisticsTask = null;
    }
}

