/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackUnit;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionSampleDBTable;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingChildData;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingData;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryDBTable;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;

public class ProfileDataMaker {
    private Map<Integer, CallstackTree> callstackTreeByTidMap = new HashMap<Integer, CallstackTree>();
    protected int totalSampleCount = 0;
    private int pid = 0;
    private Map<Integer, ProfilingData> profilingDataMap = null;
    private Map<String, String> symbolIDHash = null;
    private Map<String, ProfilingChildData> childListMap = null;
    private ProfilingData appBin = null;
    private ProfilingData dependentLib = null;
    private String appBinName = null;

    public void clear() {
        this.getProfilingDataMap().clear();
        this.getChildListMap().clear();
        this.appBin = null;
        this.dependentLib = null;
        this.appBinName = null;
        this.totalSampleCount = 0;
        this.getSymbolIDHash().clear();
        this.callstackTreeByTidMap.clear();
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getAppBinName() {
        return this.appBinName;
    }

    public ProfilingData getAppBin() {
        return this.appBin;
    }

    public ProfilingData getDependentLib() {
        return this.dependentLib;
    }

    public void setAppBin(ProfilingData appBin) {
        this.appBin = appBin;
    }

    public void setDependentLib(ProfilingData dependentLib) {
        this.dependentLib = dependentLib;
    }

    public void setTotalSampleCount(int count) {
        this.totalSampleCount = count;
    }

    public int getTotalSampleCount() {
        return this.totalSampleCount;
    }

    public ProfilingData getProfilingDataByKey(String key) {
        Map<String, String> hash = this.getSymbolIDHash();
        String profilingDataID = hash.get(key);
        if (profilingDataID != null) {
            return this.getProfilingDataMap().get(Integer.parseInt(profilingDataID));
        }
        return null;
    }

    public Map<Integer, ProfilingData> getProfilingDataMap() {
        if (this.profilingDataMap == null) {
            this.profilingDataMap = new ConcurrentHashMap<Integer, ProfilingData>();
        }
        return this.profilingDataMap;
    }

    public Map<String, ProfilingChildData> getChildListMap() {
        if (this.childListMap == null) {
            this.childListMap = new ConcurrentHashMap<String, ProfilingChildData>();
        }
        return this.childListMap;
    }

    public Map<String, String> getSymbolIDHash() {
        if (this.symbolIDHash == null) {
            this.symbolIDHash = new ConcurrentHashMap<String, String>();
        }
        return this.symbolIDHash;
    }

    public CallstackTree getCurrentCallstackTree(int tid) {
        return this.callstackTreeByTidMap.get(tid);
    }

    public void putCurrentCallstackTree(int tid, CallstackTree current) {
        this.callstackTreeByTidMap.put(tid, current);
    }

    public String getCpuRate(ProfilingData data, boolean exclusive) {
        double rate;
        if (exclusive) {
            int count = data.getExCount();
            rate = this.totalSampleCount == 0 ? 0.0 : (double)count / (double)this.totalSampleCount * 100.0;
        } else {
            int count = data.getInCount();
            rate = this.totalSampleCount == 0 ? 0.0 : (double)count / (double)this.totalSampleCount * 100.0;
        }
        return Formatter.toDoubleFormat2(rate);
    }

    public String getCpuTime(ProfilingData data, boolean exclusive) {
        int count = exclusive ? data.getExCount() : data.getInCount();
        return Long.toString((long)count * FunctionUsageProfiler.SAMPLE_TIME);
    }

    private void checkUserCall(CallStackUnit csu, ProfilingData parent) {
        AppInfo appInfo = Global.getProject().getApplicationInfo();
        BinaryInfo binfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(appInfo.getExecBinaryPath());
        if (binfo.getTargetBinaryPath() != null && binfo.getTargetBinaryPath().equals(csu.getPath())) {
            if (this.appBin == null) {
                CallStackUnit appBinCsa = new CallStackUnit(FunctionUsageProfiler.APPLICATION);
                this.appBin = this.makeNewProfilingData(appBinCsa, true);
                this.appBin.setKey("profiling_app_bin_key");
                this.appBinName = csu.getPath();
            }
            parent.setParent(this.appBin.getName());
            this.appBin.addChild(parent);
        } else {
            if (this.dependentLib == null) {
                CallStackUnit dependentLibBinCsa = new CallStackUnit(FunctionUsageProfiler.DEPENDENT_LIB);
                this.dependentLib = this.makeNewProfilingData(dependentLibBinCsa, true);
                this.dependentLib.setKey("profiling_dependent_lib_key");
            }
            parent.setParent(this.dependentLib.getName());
            this.dependentLib.addChild(parent);
        }
    }

    public void prepareFunctionUsageProfileData(ProfileData sampleLog) {
        String inputFuncName;
        ++this.totalSampleCount;
        long selfAddr = sampleLog.getPcAddr();
        int samplepid = sampleLog.getPid();
        int tid = sampleLog.getTid();
        long sampleTime = sampleLog.getTime();
        int binId = Global.getBinaryID(samplepid, sampleTime, selfAddr);
        String inputPath = Global.getLibraryName(binId);
        CallStackUnit callstackUnit = CallTraceDataManager.getInstance().getLastEntry(this.pid, tid, sampleTime);
        if (callstackUnit == null || callstackUnit.getBinaryID() != binId) {
            inputFuncName = "";
            callstackUnit = new CallStackUnit(selfAddr, 0L, samplepid, tid, sampleTime, 0);
        } else {
            inputFuncName = callstackUnit.getFunctionName();
        }
        ProfilingData parent = this.getProfilingDataByKey(inputPath);
        if (parent == null) {
            parent = this.makeNewProfilingData(callstackUnit, true);
            this.checkUserCall(callstackUnit, parent);
            if (inputFuncName.equals("")) {
                parent.addExCount();
            } else {
                ProfilingData child = this.makeNewProfilingData(callstackUnit, false);
                parent.addChild(child);
                child.addExCount();
                child.setParent(parent.getName());
            }
        } else if (inputFuncName.equals("")) {
            parent.addExCount();
        } else {
            ProfilingData child = this.getProfilingDataByKey(callstackUnit.getSymbol());
            if (child == null) {
                child = this.makeNewProfilingData(callstackUnit, false);
                parent.addChild(child);
                child.setParent(parent.getName());
            }
            child.addExCount();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void finalizeFunctionUsageProfileData(List<Object> dbrecord) {
        selfAddr = (Long)dbrecord.get(FunctionSampleDBTable.COLUMN.PC_ADDRESS.index);
        samplepid = (Integer)dbrecord.get(FunctionSampleDBTable.COLUMN.PID.index);
        tid = (Integer)dbrecord.get(FunctionSampleDBTable.COLUMN.TID.index);
        sampleTime = (Long)dbrecord.get(FunctionSampleDBTable.COLUMN.SAMPLE_TIME.index);
        binId = Global.getBinaryID(samplepid, sampleTime, selfAddr);
        inputPath = Global.getLibraryName(binId);
        callstackUnit = CallTraceDataManager.getInstance().getLastEntry(this.pid, tid, sampleTime);
        if (callstackUnit == null || callstackUnit.getBinaryID() != binId) {
            inputFuncName = "";
            callstackUnit = new CallStackUnit(selfAddr, 0L, samplepid, tid, sampleTime, 0);
        } else {
            inputFuncName = callstackUnit.getFunctionName();
        }
        parent = this.getProfilingDataByKey(inputPath);
        callstack = CallTraceDataManager.getInstance().getCallstackForTable(samplepid, tid, sampleTime);
        if (inputFuncName.equals("")) {
            if (parent != null) {
                parent.addInCount();
            }
        } else {
            Logger.warning((Object)("Unexpected occurence of " + CommonConstants.NEW_LINE + callstackUnit.getSymbol()));
            child = this.getProfilingDataByKey(callstackUnit.getSymbol());
            if (child == null) {
                child = this.makeNewProfilingData(callstackUnit, false);
            }
            child.addInCount();
        }
        i = 0;
        while (i < callstack.size()) {
            block15: {
                block16: {
                    block14: {
                        callstackCsa = callstack.get(i);
                        if (!callstackCsa.getFunctionName().equals("")) break block14;
                        inParent = this.getProfilingDataByKey(callstackCsa.getPath());
                        if (inParent == null) {
                            inParent = this.makeNewProfilingData(callstackCsa, true);
                            this.checkUserCall(callstackCsa, inParent);
                        }
                        inParent.addInCount();
                        if (inParent.getParent() != null && (pp = this.getProfilingDataByKey(pInParentName = inParent.getParent())) != null) {
                            pp.addInCount();
                        }
                        break block15;
                    }
                    fupData = this.getProfilingDataByKey(callstackCsa.getSymbol());
                    if (fupData != null) break block16;
                    inParent = this.getProfilingDataByKey(callstackCsa.getPath());
                    if (inParent == null) {
                        inParent = this.makeNewProfilingData(callstackCsa, true);
                        this.checkUserCall(callstackCsa, inParent);
                    }
                    fupData = this.makeNewProfilingData(callstackCsa, false);
                    fupData.setParent(inParent.getName());
                    inParent.addChild(fupData);
                    ** GOTO lbl-1000
                }
                pName = fupData.getParent();
                inParent = this.getProfilingDataByKey(pName);
                if (inParent == null) {
                    Logger.error((Object)"ProfilingData: function item without library item");
                } else lbl-1000:
                // 2 sources

                {
                    if (i == callstack.size() - 1) {
                        inParent.addInCount();
                        if (inParent.getParent() != null && (pp = this.getProfilingDataByKey(pInParentName = inParent.getParent())) != null) {
                            pp.addInCount();
                        }
                    }
                    fupData.addInCount();
                }
            }
            ++i;
        }
    }

    protected ProfilingData makeNewProfilingData(CallStackUnit inputData, boolean isParent) {
        ProfilingData newProfilingData = new ProfilingData(inputData, isParent, this);
        this.getProfilingDataMap().put(newProfilingData.getProfilingDataID(), newProfilingData);
        if (isParent) {
            this.getSymbolIDHash().put(inputData.getPath(), Integer.toString(newProfilingData.getProfilingDataID()));
        } else {
            this.getSymbolIDHash().put(inputData.getSymbol(), Integer.toString(newProfilingData.getProfilingDataID()));
        }
        return newProfilingData;
    }

    public void prepareFUPDataForCallTrace(ProfileData pData) {
        int type = pData.getMsgID();
        int binId = pData.getBinaryId();
        String path = Global.getLibraryName(binId);
        int functionID = pData.getApiId();
        String fName = Global.getFunctionName(functionID);
        CallStackUnit unit = new CallStackUnit(pData.getPcAddr(), pData.getCallerPcAddr(), pData.getPid(), pData.getTid(), pData.getTid(), functionID, binId, fName, path);
        if (type == 8) {
            ProfilingData parent = this.getProfilingDataByKey(path);
            if (parent == null) {
                parent = this.makeNewProfilingData(unit, true);
                this.checkUserCall(unit, parent);
                ProfilingData child = this.makeNewProfilingData(unit, false);
                parent.addChild(child);
                child.setParent(parent.getName());
                child.addCallCount();
            } else {
                ProfilingData child = this.getProfilingDataByKey(unit.getSymbol());
                if (child == null) {
                    child = this.makeNewProfilingData(unit, false);
                    parent.addChild(child);
                    child.setParent(parent.getName());
                }
                child.addCallCount();
            }
        }
    }

    public void finalizeFUPDataForCallTrace(List<Object> entry) {
        ProfilingData child;
        ProfilingData parent;
        long exeTime = 0L;
        long addr = (Long)entry.get(FunctionEntryDBTable.COLUMN.START_PC_ADDRESS.index);
        long callerAddr = (Long)entry.get(FunctionEntryDBTable.COLUMN.CALLER_PC_ADDRESS.index);
        int type = (Boolean)entry.get(FunctionEntryDBTable.COLUMN.IS_ENTRY.index) != false ? 8 : 9;
        int entrypid = (Integer)entry.get(FunctionEntryDBTable.COLUMN.PID.index);
        int tid = (Integer)entry.get(FunctionEntryDBTable.COLUMN.TID.index);
        long time = (Long)entry.get(FunctionEntryDBTable.COLUMN.START_TIME.index);
        int functionID = (Integer)entry.get(FunctionEntryDBTable.COLUMN.FUNCTION_ID.index);
        String fName = Global.getFunctionName(functionID);
        int binId = (Integer)entry.get(FunctionEntryDBTable.COLUMN.BINARY_ID.index);
        CallStackUnit unit = new CallStackUnit(addr, callerAddr, entrypid, tid, time, functionID, binId, fName, Global.getLibraryName(binId));
        if (type == 9) {
            List<CallStackUnit> callstack = CallTraceDataManager.getInstance().getCallstackForSampling(entrypid, tid, time);
            if (callstack == null || callstack.isEmpty() || callstack.get(0).getAddr() != addr) {
                return;
            }
            long startTime = callstack.get(0).getTime();
            if (startTime > 0L) {
                exeTime += time - startTime;
            }
            unit = callstack.get(0);
        }
        if ((parent = this.getProfilingDataByKey(unit.getPath())) == null) {
            Logger.warning((Object)("Unexpected occurence of library\n" + unit.getPath()));
            parent = this.makeNewProfilingData(unit, true);
            this.checkUserCall(unit, parent);
            child = this.makeNewProfilingData(unit, false);
            parent.addChild(child);
            child.setParent(parent.getName());
            child.addElapsedTime(exeTime);
        } else {
            child = this.getProfilingDataByKey(unit.getSymbol());
            if (child == null) {
                Logger.warning((Object)("Unexpected occurence of " + CommonConstants.NEW_LINE + unit.getSymbol()));
                child = this.makeNewProfilingData(unit, false);
                parent.addChild(child);
                child.setParent(parent.getName());
            }
            child.addElapsedTime(exeTime);
        }
        CallstackTree current = this.getCurrentCallstackTree(tid);
        if (type == 9) {
            if (current == null) {
                Logger.debug((Object)("exit without entry - range only :" + unit.getFunctionName()));
            } else {
                CallstackTree parentCt = current.getParent();
                if (parentCt != null) {
                    parentCt.addChildExeTime(exeTime);
                }
                child.addExclusiveElapsedTime(current.getExclusiveExeTime());
                this.putCurrentCallstackTree(tid, current.getParent());
            }
        } else if (current == null) {
            CallstackTree ct = new CallstackTree(child, null);
            this.putCurrentCallstackTree(tid, ct);
        } else {
            CallstackTree ct = new CallstackTree(child, current);
            this.putCurrentCallstackTree(tid, ct);
        }
    }

    static class CallstackTree {
        ProfilingData me;
        CallstackTree parent;
        int childExeTime = 0;

        public CallstackTree(ProfilingData me, CallstackTree parent) {
            this.me = me;
            this.parent = parent;
        }

        public void addChildExeTime(long time) {
            this.childExeTime = (int)((long)this.childExeTime + time);
        }

        public long getExclusiveExeTime() {
            return this.me.getLastElapsedTime() - (long)this.childExeTime;
        }

        public ProfilingData getThis() {
            return this.me;
        }

        public CallstackTree getParent() {
            return this.parent;
        }
    }
}

