/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class DAChartTooltip {
    private static DAChartTooltip instance = null;
    private Shell shell = null;
    Canvas contents = null;
    private static final int MAX_WIDTH = 100;
    private static final int MAX_HEIGHT = 100;
    private DACustomChartTooltipInfo tooltipInfo = null;

    private DAChartTooltip() {
    }

    public static DAChartTooltip getInstance() {
        if (instance == null) {
            instance = new DAChartTooltip();
        }
        return instance;
    }

    private void init(Shell parent) {
        if (this.shell == null) {
            this.shell = new Shell(parent, 524292);
            this.shell.setSize(100, 10);
            this.shell.setLayout((Layout)new FillLayout());
            this.contents = new Canvas((Composite)this.shell, 0);
            this.contents.setBackground(ColorResources.CHART_TOOLTIP_BACKGROUND_BACKGROUND);
            this.contents.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    DAChartTooltip.this.drawTooltip(e.gc);
                }
            });
        }
    }

    public void open(Shell parent, DAChartPlot plot) {
        boolean bInfo = this.makeTooltipInfo(plot.getChart());
        if (!bInfo) {
            return;
        }
        this.init(parent);
        Point pt = Display.getCurrent().getCursorLocation();
        this.shell.setBounds(pt.x + 10, pt.y - this.tooltipInfo.height - 10, this.tooltipInfo.width, this.tooltipInfo.height);
        this.shell.open();
    }

    public void move() {
        if (this.shell == null || this.tooltipInfo == null) {
            return;
        }
        DAChartPlotTooltip tooltip = this.tooltipInfo.chart.getPlot().getTooltip();
        if (this.tooltipInfo.xVal != tooltip.getStartVal()) {
            this.makeTooltipInfo(this.tooltipInfo.chart);
        }
        Point pt = Display.getCurrent().getCursorLocation();
        this.shell.setBounds(pt.x + 10, pt.y - this.tooltipInfo.height - 10, this.tooltipInfo.width, this.tooltipInfo.height);
    }

    private boolean makeTooltipInfo(DAChart chart) {
        if (this.tooltipInfo == null) {
            this.tooltipInfo = new DACustomChartTooltipInfo();
        } else {
            this.tooltipInfo.clear();
        }
        this.tooltipInfo.chart = chart;
        DAChartPlotTooltip tooltip = chart.getPlot().getTooltip();
        List<DAChartSeries> seriesList = chart.getSeriesList();
        if (tooltip == null || -1.0 == tooltip.getStartVal()) {
            return false;
        }
        this.tooltipInfo.height = seriesList.size() * 18 + 8;
        this.tooltipInfo.xVal = tooltip.getStartVal();
        Image image = new Image((Device)Display.getCurrent(), 100, 100);
        GC tempGC = new GC((Drawable)image);
        tempGC.setFont(tooltip.getFont());
        int i = 0;
        while (i < seriesList.size()) {
            DAChartSeries series = seriesList.get(i);
            int index = series.getPrevIndexByXvalue(this.tooltipInfo.xVal);
            String text = index >= 0 ? String.valueOf(series.getName()) + " : " + series.getSeriesItemList().get(index).getTooltipText() : series.getName();
            this.tooltipInfo.tooltipTexts.add(text);
            int textWidth = tempGC.textExtent((String)text).x;
            if (this.tooltipInfo.width < textWidth) {
                this.tooltipInfo.width = textWidth;
            }
            ++i;
        }
        this.tooltipInfo.width += 18;
        tempGC.dispose();
        image.dispose();
        return true;
    }

    private void drawTooltip(GC gc) {
        DAChartPlotTooltip tooltip = this.tooltipInfo.chart.getPlot().getTooltip();
        List<DAChartSeries> seriesList = this.tooltipInfo.chart.getSeriesList();
        if (tooltip == null || !tooltip.shouldBeDrawn() || -1.0 == tooltip.getStartVal()) {
            return;
        }
        gc.setFont(tooltip.getFont());
        int i = 0;
        while (i < seriesList.size()) {
            DAChartSeries series = seriesList.get(i);
            int y = 18 * i + 4;
            gc.setBackground(series.getColor());
            gc.fillRectangle(4, y + 6, 6, 6);
            gc.setBackground(tooltip.getBackgroundColor());
            gc.drawText(this.tooltipInfo.tooltipTexts.get(i), 14, y + 4);
            ++i;
        }
    }

    public void close() {
        if (this.tooltipInfo != null) {
            this.tooltipInfo.clear();
        }
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
    }

    private static class DACustomChartTooltipInfo {
        public int height = 0;
        public int width = 0;
        public List<String> tooltipTexts = new ArrayList<String>();
        public double xVal = 0.0;
        public DAChart chart;

        public void clear() {
            if (this.tooltipTexts != null) {
                this.tooltipTexts.clear();
            }
            this.height = 0;
            this.width = 0;
            this.xVal = 0.0;
        }
    }
}

