/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.chart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.memory.chart.MemoryChart;
import org.tizen.dynamicanalyzer.ui.memory.data.ProcessMemoryDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.SystemMemoryDBTable;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class SystemMemoryChart
extends MemoryChart {
    private DAChartSeries processSeries;
    private DAChartSeries systemSeries;

    public SystemMemoryChart(String pageID) {
        super(pageID);
        this.chartType = -106;
        this.chartName = MemoryPageLabels.MEMORY_CHART_SYSTEM_MEMORY;
        this.chartIcon = ImageResources.FEATURE_MEM_SYSTEM_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_MEM_SYSTEM_SMALL_NOR;
        this.processSeries = new DAChartSeries(TimelineChartLabels.SYSTEM_MEMORY_CHART_SERIES_NAME_PROC_RESIDENT, 3, ColorResources.CHART_SERIES_BLUE);
        this.systemSeries = new DAChartSeries(TimelineChartLabels.SYSTEM_MEMORY_CHART_SERIES_NAME_SYSTEM, 3, ColorResources.CHART_SERIES_EMERALD);
    }

    public SystemMemoryChart(String pageID, String chartName, DAChartBoardItem chartBoardItem, DAChart chart) {
        super(pageID, chartName, chartBoardItem, chart);
        this.chartType = -105;
        this.chartIcon = ImageResources.FEATURE_MEM_SYSTEM_SMALL;
        this.addIcon = ImageResources.FEATURE_MEM_SYSTEM_SMALL;
        this.systemSeries = new DAChartSeries(TimelineChartLabels.SYSTEM_MEMORY_CHART_SERIES_NAME_SYSTEM, 3, ColorResources.CHART_SERIES_EMERALD);
        this.processSeries = new DAChartSeries(TimelineChartLabels.SYSTEM_MEMORY_CHART_SERIES_NAME_PROC_RESIDENT, 3, ColorResources.CHART_SERIES_BLUE);
        chart.addSeries(this.systemSeries);
        chart.addSeries(this.processSeries);
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        this.processSeries.clear();
        this.systemSeries.clear();
        if (Global.getProject() == null) {
            return;
        }
        List systemData = (List)dataList.get(0);
        Map targetProcessDataMap = (Map)dataList.get(1);
        double maxTime = 0.0;
        int i = 0;
        while (i < systemData.size()) {
            List row = (List)systemData.get(i);
            double time = (double)((Long)row.get(SystemMemoryDBTable.COLUMN.SAMPLING_TIME.ordinal())).longValue() / 1000000.0;
            try {
                long systemMemoryUsage = (Long)row.get(SystemMemoryDBTable.COLUMN.MEMORY_USAGE_SYSTEM.ordinal());
                this.systemSeries.addSeriesItem(new DAChartSeriesItem(time, (double)systemMemoryUsage, Formatter.toByteFormat(systemMemoryUsage)));
            }
            catch (NumberFormatException ne) {
                Logger.exception((Throwable)ne);
            }
            maxTime = time;
            ++i;
        }
        Iterator iter = targetProcessDataMap.keySet().iterator();
        HashMap<Long, Long> processLoadSumMap = new HashMap<Long, Long>();
        while (iter.hasNext()) {
            Integer pid = (Integer)iter.next();
            List data = (List)targetProcessDataMap.get(pid);
            int i2 = 0;
            while (i2 < data.size()) {
                List oneTime = (List)data.get(i2);
                Long time = (Long)oneTime.get(ProcessMemoryDBTable.COLUMN.SAMPLING_TIME.index);
                Long processMemorySize = (Long)oneTime.get(ProcessMemoryDBTable.COLUMN.MEMORY_RESIDENT.index);
                Long processMemorySizeSum = (Long)processLoadSumMap.get(time);
                if (processMemorySizeSum == null) {
                    processLoadSumMap.put(time, processMemorySize);
                } else {
                    processLoadSumMap.put(time, processMemorySizeSum + processMemorySize);
                }
                ++i2;
            }
        }
        ArrayList timeSortedLoadList = new ArrayList(processLoadSumMap.keySet());
        Collections.sort(timeSortedLoadList);
        for (Long time : timeSortedLoadList) {
            Long processMemorySizeSum = (Long)processLoadSumMap.get(time);
            if (!(maxTime >= (double)time.longValue() / 1000000.0)) continue;
            this.processSeries.addSeriesItem(new DAChartSeriesItem((double)time.longValue() / 1000000.0, (double)processMemorySizeSum.longValue(), Formatter.toByteFormat(processMemorySizeSum)));
        }
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard board) {
        DAChartBoardItem item = super.createBoardItem(board);
        this.chart.addSeries(this.systemSeries);
        this.chart.addSeries(this.processSeries);
        this.chart.getPlot().setAxisUnit("B");
        this.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.BINARY);
        this.chart.getPlot().setShowAxis(true);
        return item;
    }
}

