/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.warning;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.nl.SummaryLabels;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningDetailView;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningListView;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class WarningDataView
extends DAViewComposite {
    WarningListView warningListView;
    WarningDetailView warningDetailView;
    SashForm baseForm;

    public WarningDataView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(SummaryLabels.WARNING_DATA_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WHITE);
        contents.setLayout((Layout)new FillLayout());
        this.baseForm = new SashForm(contents, 256);
        this.warningListView = new WarningListView((Composite)this.baseForm, 0);
        this.warningDetailView = new WarningDetailView((Composite)this.baseForm, 0);
        this.baseForm.setWeights(new int[]{65, 35});
    }

    public void updateView() {
        this.warningListView.updateView();
        this.warningDetailView.updateView();
    }

    public void updateView(DAViewData data) {
        this.warningListView.updateView(data);
        this.warningDetailView.updateView(data);
    }

    public void clear() {
        this.warningListView.clear();
        this.warningDetailView.clear();
    }

    public void updateWarningDetailMessage(String warningMessage) {
        this.warningDetailView.updateWarningMessage(warningMessage);
    }

    public Control getControl() {
        return this.warningListView.getControl();
    }
}

