/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.ModuleLineEntryProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.RangeList;
import org.eclipse.cdt.debug.edc.symbols.ICompileUnitScope;
import org.eclipse.cdt.debug.edc.symbols.IEnumerator;
import org.eclipse.cdt.debug.edc.symbols.IModuleScope;
import org.eclipse.cdt.debug.edc.symbols.IRangeList;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IVariable;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;

public abstract class Scope
implements IScope {
    protected String name;
    protected IAddress lowAddress;
    protected IAddress highAddress;
    protected IScope parent;
    protected List<IScope> children = new ArrayList<IScope>();
    protected List<IVariable> variables = new ArrayList<IVariable>();
    protected List<IEnumerator> enumerators = new ArrayList<IEnumerator>();
    private TreeMap<IRangeList.Entry, IScope> addressToScopeMap;
    protected IRangeList rangeList;

    public Scope(String name, IAddress lowAddress, IAddress highAddress, IScope parent) {
        this.name = name;
        this.lowAddress = lowAddress;
        this.highAddress = highAddress;
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IAddress getLowAddress() {
        return this.lowAddress;
    }

    @Override
    public IAddress getHighAddress() {
        return this.highAddress;
    }

    @Override
    public boolean hasEmptyRange() {
        return this.lowAddress == null || this.highAddress == null || this.lowAddress.isZero() && this.highAddress.isZero() || this.lowAddress.getValue().longValue() == -1L && this.highAddress.isZero();
    }

    @Override
    public IRangeList getRangeList() {
        return this.rangeList;
    }

    public void setLowAddress(IAddress lowAddress) {
        this.lowAddress = lowAddress;
    }

    public void setHighAddress(IAddress highAddress) {
        this.highAddress = highAddress;
    }

    public void setRangeList(IRangeList ranges) {
        this.rangeList = ranges;
        this.setLowAddress((IAddress)new Addr32(this.rangeList.getLowAddress()));
        this.setHighAddress((IAddress)new Addr32(this.rangeList.getHighAddress()));
    }

    @Override
    public IScope getParent() {
        return this.parent;
    }

    @Override
    public Collection<IScope> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    @Override
    public Collection<IVariable> getVariables() {
        return Collections.unmodifiableCollection(this.variables);
    }

    @Override
    public Collection<IEnumerator> getEnumerators() {
        return Collections.unmodifiableCollection(this.enumerators);
    }

    @Override
    public IScope getScopeAtAddress(IAddress linkAddress) {
        if (linkAddress.compareTo((Object)this.lowAddress) >= 0 && linkAddress.compareTo((Object)this.highAddress) < 0) {
            this.ensureScopeRangeLookup();
            long addr = linkAddress.getValue().longValue();
            IRangeList.Entry addressEntry = new IRangeList.Entry(addr, addr);
            SortedMap<IRangeList.Entry, IScope> tailMap = this.addressToScopeMap.tailMap(addressEntry);
            if (tailMap.isEmpty()) {
                return this;
            }
            IScope child = tailMap.values().iterator().next();
            if (linkAddress.compareTo((Object)child.getLowAddress()) >= 0 && linkAddress.compareTo((Object)child.getHighAddress()) < 0) {
                return child.getScopeAtAddress(linkAddress);
            }
            return this;
        }
        return null;
    }

    private void ensureScopeRangeLookup() {
        if (this.addressToScopeMap == null) {
            this.addressToScopeMap = new TreeMap();
            for (IScope scope : this.children) {
                this.addScopeRange(scope);
            }
        }
    }

    private void addScopeRange(IScope scope) {
        IRangeList ranges = scope.getRangeList();
        if (ranges != null) {
            for (IRangeList.Entry entry : ranges) {
                this.addressToScopeMap.put(entry, scope);
            }
        } else {
            this.addressToScopeMap.put(new IRangeList.Entry(scope.getLowAddress().getValue().longValue(), scope.getHighAddress().getValue().longValue()), scope);
        }
    }

    public void addChild(IScope scope) {
        this.children.add(scope);
        if (this.addressToScopeMap != null) {
            this.addScopeRange(scope);
        }
    }

    public void addVariable(IVariable variable) {
        this.variables.add(variable);
    }

    public void addEnumerator(IEnumerator enumerator) {
        this.enumerators.add(enumerator);
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof IScope) {
            return this.lowAddress.compareTo((Object)((IScope)o).getLowAddress());
        }
        if (o instanceof IAddress) {
            return this.lowAddress.compareTo(o);
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Scope [");
        if (this.rangeList != null) {
            builder.append("ranges=");
            builder.append(this.rangeList);
        } else {
            builder.append("lowAddress=");
            builder.append(this.lowAddress != null ? this.lowAddress.toHexAddressString() : "null");
            builder.append(", highAddress=");
            builder.append(this.highAddress != null ? this.highAddress.toHexAddressString() : "null");
        }
        builder.append(", ");
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    public void fixupRanges(IAddress baseAddress) {
        Addr64 newLowAddress = Addr64.MAX;
        Addr64 newHighAddress = Addr64.ZERO;
        boolean any = false;
        for (IScope kid : this.getChildren()) {
            if (kid.hasEmptyRange() || kid.getLowAddress().compareTo((Object)baseAddress) <= 0) continue;
            if (kid.getLowAddress().compareTo((Object)newLowAddress) < 0) {
                newLowAddress = kid.getLowAddress();
                any = true;
            }
            if (kid.getHighAddress().compareTo((Object)newHighAddress) <= 0) continue;
            newHighAddress = kid.getHighAddress();
            any = true;
        }
        if (any) {
            this.lowAddress = newLowAddress;
            this.highAddress = newHighAddress;
            this.rangeList = null;
        } else if (this.lowAddress == null) {
            this.lowAddress = this.highAddress = Addr32.ZERO;
        }
    }

    protected void mergeScopeRange(IScope scope) {
        if (this.hasEmptyRange()) {
            if (scope.getRangeList() != null) {
                this.setRangeList(scope.getRangeList());
            } else {
                this.setLowAddress(scope.getLowAddress());
                this.setHighAddress(scope.getHighAddress());
            }
        } else {
            if (scope.getLowAddress() != null && scope.getLowAddress().compareTo((Object)this.lowAddress) < 0 && !scope.getLowAddress().isZero()) {
                if (this.rangeList != null) {
                    if (scope.getRangeList() != null) {
                        this.rangeList = null;
                    } else {
                        ((RangeList)this.rangeList).addLowRange(scope.getLowAddress().getValue().longValue());
                    }
                }
                this.lowAddress = scope.getLowAddress();
            }
            if (scope.getHighAddress() != null && scope.getHighAddress().compareTo((Object)this.highAddress) > 0) {
                if (this.rangeList != null) {
                    if (scope.getRangeList() != null) {
                        this.rangeList = null;
                    } else {
                        ((RangeList)this.rangeList).addHighRange(scope.getHighAddress().getValue().longValue());
                    }
                }
                this.highAddress = scope.getHighAddress();
            }
        }
    }

    protected void addLineInfoToParent(IScope scope) {
        IScope cu = this.parent;
        while (cu != null) {
            if (cu instanceof ICompileUnitScope && cu.getParent() instanceof IModuleScope) {
                IModuleScope module = (IModuleScope)cu.getParent();
                ModuleLineEntryProvider provider = (ModuleLineEntryProvider)module.getModuleLineEntryProvider();
                provider.addCompileUnitChild((ICompileUnitScope)cu, scope);
                break;
            }
            cu = cu.getParent();
        }
    }

    @Override
    public void dispose() {
        for (IScope scope : this.children) {
            scope.dispose();
        }
        this.children.clear();
        for (IVariable var : this.variables) {
            var.dispose();
        }
        this.variables.clear();
        this.enumerators.clear();
        if (this.addressToScopeMap != null) {
            this.addressToScopeMap.clear();
        }
        this.rangeList = null;
    }
}

