/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUCache;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.impl.SimplePatternFormatter;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListFormatter {
    private final SimplePatternFormatter two;
    private final SimplePatternFormatter start;
    private final SimplePatternFormatter middle;
    private final SimplePatternFormatter end;
    private final ULocale locale;
    static Map<ULocale, ListFormatter> localeToData = new HashMap<ULocale, ListFormatter>();
    static Cache cache = new Cache();

    @Deprecated
    public ListFormatter(String two, String start, String middle, String end) {
        this(SimplePatternFormatter.compile(two), SimplePatternFormatter.compile(start), SimplePatternFormatter.compile(middle), SimplePatternFormatter.compile(end), null);
    }

    private ListFormatter(SimplePatternFormatter two, SimplePatternFormatter start, SimplePatternFormatter middle, SimplePatternFormatter end, ULocale locale) {
        this.two = two;
        this.start = start;
        this.middle = middle;
        this.end = end;
        this.locale = locale;
    }

    public static ListFormatter getInstance(ULocale locale) {
        return ListFormatter.getInstance(locale, Style.STANDARD);
    }

    public static ListFormatter getInstance(Locale locale) {
        return ListFormatter.getInstance(ULocale.forLocale(locale), Style.STANDARD);
    }

    @Deprecated
    public static ListFormatter getInstance(ULocale locale, Style style) {
        return cache.get(locale, style.getName());
    }

    public static ListFormatter getInstance() {
        return ListFormatter.getInstance(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public String format(Object ... items) {
        return this.format(Arrays.asList(items));
    }

    public String format(Collection<?> items) {
        return this.format(items, -1).toString();
    }

    FormattedListBuilder format(Collection<?> items, int index) {
        Iterator<?> it = items.iterator();
        int count = items.size();
        switch (count) {
            case 0: {
                return new FormattedListBuilder("", false);
            }
            case 1: {
                return new FormattedListBuilder(it.next(), index == 0);
            }
            case 2: {
                return new FormattedListBuilder(it.next(), index == 0).append(this.two, it.next(), index == 1);
            }
        }
        FormattedListBuilder builder = new FormattedListBuilder(it.next(), index == 0);
        builder.append(this.start, it.next(), index == 1);
        int idx = 2;
        while (idx < count - 1) {
            builder.append(this.middle, it.next(), index == idx);
            ++idx;
        }
        return builder.append(this.end, it.next(), index == count - 1);
    }

    public String getPatternForNumItems(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count must be > 0");
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < count) {
            list.add(String.format("{%d}", i));
            ++i;
        }
        return this.format(list);
    }

    @Deprecated
    public ULocale getLocale() {
        return this.locale;
    }

    static void add(String locale, String ... data) {
        localeToData.put(new ULocale(locale), new ListFormatter(data[0], data[1], data[2], data[3]));
    }

    /* synthetic */ ListFormatter(SimplePatternFormatter simplePatternFormatter, SimplePatternFormatter simplePatternFormatter2, SimplePatternFormatter simplePatternFormatter3, SimplePatternFormatter simplePatternFormatter4, ULocale uLocale, ListFormatter listFormatter) {
        this(simplePatternFormatter, simplePatternFormatter2, simplePatternFormatter3, simplePatternFormatter4, uLocale);
    }

    private static class Cache {
        private final ICUCache<String, ListFormatter> cache = new SimpleCache<String, ListFormatter>();

        private Cache() {
        }

        public ListFormatter get(ULocale locale, String style) {
            String key = String.format("%s:%s", locale.toString(), style);
            ListFormatter result = this.cache.get(key);
            if (result == null) {
                result = Cache.load(locale, style);
                this.cache.put(key, result);
            }
            return result;
        }

        private static ListFormatter load(ULocale ulocale, String style) {
            ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt54b", ulocale);
            try {
                return new ListFormatter(SimplePatternFormatter.compile(r.getWithFallback("listPattern/" + style + "/2").getString()), SimplePatternFormatter.compile(r.getWithFallback("listPattern/" + style + "/start").getString()), SimplePatternFormatter.compile(r.getWithFallback("listPattern/" + style + "/middle").getString()), SimplePatternFormatter.compile(r.getWithFallback("listPattern/" + style + "/end").getString()), ulocale, null);
            }
            catch (MissingResourceException missingResourceException) {
                return new ListFormatter(SimplePatternFormatter.compile(r.getWithFallback("listPattern/standard/2").getString()), SimplePatternFormatter.compile(r.getWithFallback("listPattern/standard/start").getString()), SimplePatternFormatter.compile(r.getWithFallback("listPattern/standard/middle").getString()), SimplePatternFormatter.compile(r.getWithFallback("listPattern/standard/end").getString()), ulocale, null);
            }
        }
    }

    static class FormattedListBuilder {
        private StringBuilder current;
        private int offset;

        public FormattedListBuilder(Object start, boolean recordOffset) {
            this.current = new StringBuilder(start.toString());
            this.offset = recordOffset ? 0 : -1;
        }

        public FormattedListBuilder append(SimplePatternFormatter pattern, Object next, boolean recordOffset) {
            if (pattern.getPlaceholderCount() != 2) {
                throw new IllegalArgumentException("Need {0} and {1} only in pattern " + pattern);
            }
            int[] offsets = (int[])(recordOffset || this.offsetRecorded() ? new int[2] : null);
            StringBuilder nextBuilder = pattern.startsWithPlaceholder(0) ? this.current : new StringBuilder();
            this.current = pattern.format(nextBuilder, offsets, this.current, next.toString());
            if (offsets != null) {
                if (offsets[0] == -1 || offsets[1] == -1) {
                    throw new IllegalArgumentException("{0} or {1} missing from pattern " + pattern);
                }
                this.offset = recordOffset ? offsets[1] : (this.offset += offsets[0]);
            }
            return this;
        }

        public String toString() {
            return this.current.toString();
        }

        public int getOffset() {
            return this.offset;
        }

        private boolean offsetRecorded() {
            return this.offset >= 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum Style {
        STANDARD("standard"),
        DURATION("unit"),
        DURATION_SHORT("unit-short"),
        DURATION_NARROW("unit-narrow");

        private final String name;

        private Style(String name) {
            this.name = name;
        }

        @Deprecated
        public String getName() {
            return this.name;
        }
    }
}

