/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.changegenerator;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.StatementWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ASTModificationHelper;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ModificationScopeStack;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class ModifiedASTStatementWriter
extends StatementWriter {
    private final ASTModificationHelper modificationHelper;

    public ModifiedASTStatementWriter(Scribe scribe, ASTVisitor visitor, ModificationScopeStack stack, NodeCommentMap commentMap) {
        super(scribe, visitor, commentMap);
        this.modificationHelper = new ASTModificationHelper(stack);
    }

    protected void writeBodyStatement(IASTStatement statement, boolean isDoStatement) {
        IASTStatement replacementNode = this.modificationHelper.getNodeAfterReplacement(statement);
        super.writeBodyStatement(replacementNode, isDoStatement);
    }

    protected void writeDeclarationWithoutSemicolon(IASTDeclaration declaration) {
        IASTDeclaration replacementNode = this.modificationHelper.getNodeAfterReplacement(declaration);
        super.writeDeclarationWithoutSemicolon(replacementNode);
    }

    protected IASTStatement[] getNestedStatements(IASTCompoundStatement compoundStatement) {
        return (IASTStatement[])this.modificationHelper.createModifiedChildArray(compoundStatement, compoundStatement.getStatements(), IASTStatement.class, this.commentMap);
    }
}

