/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.felix.scr.Component;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.CircularityException;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.Reference;
import org.eclipse.equinox.internal.ds.SCRManager;
import org.eclipse.equinox.internal.ds.WorkPerformer;
import org.eclipse.equinox.internal.ds.model.ComponentReference;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.component.ComponentException;

public final class Resolver
implements WorkPerformer {
    static final String[] WORK_TITLES = new String[]{"BUILD ", "DYNAMICBIND ", "DISPOSE "};
    public static final int BUILD = 1;
    public static final int DYNAMICBIND = 2;
    public static final int DISPOSE = 3;
    protected Vector scpEnabled;
    private InstanceProcess instanceProcess;
    private Object syncLock = new Object();
    private Hashtable serviceReferenceTable = new Hashtable();
    public SCRManager mgr;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.ds.Reference");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.equinox.internal.ds.SCRUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        clazz2.getName();
    }

    Resolver(SCRManager mgr) {
        this.scpEnabled = new Vector();
        this.instanceProcess = new InstanceProcess(this);
        this.mgr = mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void synchronizeServiceReferences() {
        Object object = this.syncLock;
        synchronized (object) {
            try {
                ServiceReference[] references = Activator.bc.getAllServiceReferences(null, null);
                this.serviceReferenceTable.clear();
                if (references != null) {
                    int i = 0;
                    while (i < references.length) {
                        this.serviceReferenceTable.put(references[i], Boolean.TRUE);
                        ++i;
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                Activator.log(Activator.bc, 2, "Resolver(): " + NLS.bind((String)Messages.INVALID_TARGET_FILTER, (Object)""), e);
            }
        }
    }

    public Object getSyncLock() {
        return this.syncLock;
    }

    void queueBlocked() {
        this.syncLock = new Object();
        this.instanceProcess = new InstanceProcess(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableComponents(Vector serviceComponents) {
        long start = 0L;
        if (Activator.DEBUG) {
            Activator.log.debug("Resolver.enableComponents(): " + (serviceComponents != null ? serviceComponents.toString() : "null"), null);
        }
        if (Activator.PERF) {
            start = System.currentTimeMillis();
        }
        Object object = this.syncLock;
        synchronized (object) {
            Configuration[] configs = null;
            if (serviceComponents != null) {
                int i = 0;
                while (i < serviceComponents.size()) {
                    ServiceComponent current = (ServiceComponent)serviceComponents.elementAt(i);
                    if (!current.enabled) {
                        if (Activator.DEBUG) {
                            Activator.log.debug("Resolver.enableComponents(): ignoring not enabled component " + current.name, null);
                        }
                    } else if (current.componentProps == null || current.componentProps.size() <= 0) {
                        current.setState(4);
                        if (current.getConfigurationPolicy() == "ignore") {
                            this.map(current, (Dictionary)null);
                        } else {
                            try {
                                String filter = "(|(service.pid=" + current.getConfigurationPID() + ")(" + "service.factoryPid" + '=' + current.getConfigurationPID() + "))";
                                configs = Activator.listConfigurations(filter);
                            }
                            catch (Exception e) {
                                Activator.log(null, 1, NLS.bind((String)Messages.CANT_LIST_CONFIGURATIONS, (Object)current.name), e);
                            }
                            if (configs == null || configs.length == 0) {
                                if (current.getConfigurationPolicy() != "require") {
                                    this.map(current, (Dictionary)null);
                                } else {
                                    String customReason;
                                    String string = customReason = Activator.configAdmin != null ? "" : Messages.CONFIG_ADMIN_SERVICE_NOT_AVAILABLE;
                                    if (Activator.DEBUG) {
                                        Activator.log.debug(String.valueOf(NLS.bind((String)Messages.COMPONENT_REQURES_CONFIGURATION_ACTIVATION, (Object)current.name)) + customReason, null);
                                    }
                                }
                            } else {
                                void config = configs[0];
                                if (config.getFactoryPid() != null && config.getFactoryPid().equals(current.getConfigurationPID())) {
                                    if (current.factory != null) {
                                        Activator.log(current.bc, 1, NLS.bind((String)Messages.REGISTERED_AS_COMPONENT_AND_MANAGED_SERVICE_FACORY, (Object)current.name), null);
                                    } else {
                                        if (Activator.DEBUG) {
                                            Activator.log.debug("[SCR - Resolver] Resolver.enableComponents(): " + current.name + " as *managed service factory*", null);
                                        }
                                        try {
                                            configs = Activator.listConfigurations("(service.factoryPid=" + config.getFactoryPid() + ")");
                                        }
                                        catch (Exception e) {
                                            Activator.log(null, 1, NLS.bind((String)Messages.CANT_LIST_CONFIGURATIONS, (Object)current.name), e);
                                        }
                                        if (configs != null) {
                                            int index = 0;
                                            while (index < configs.length) {
                                                this.map(current, configs[index]);
                                                ++index;
                                            }
                                        }
                                    }
                                } else {
                                    if (Activator.DEBUG) {
                                        Activator.log.debug("[SCR - Resolver] Resolver.enableComponents(): " + current.name + " as *service*", null);
                                    }
                                    this.map(current, (Configuration)config);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        this.buildNewlySatisfied(true);
        if (Activator.PERF) {
            start = System.currentTimeMillis() - start;
            Activator.log.info("[DS perf] " + (serviceComponents != null ? Integer.toString(serviceComponents.size()) : "") + " Components enabled for " + Long.toString(start) + "ms");
        }
    }

    protected ServiceComponentProp map(ServiceComponent component, Configuration config) {
        Dictionary configProps = null;
        if (config != null) {
            try {
                configProps = config.getProperties();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        ServiceComponentProp scp = this.map(component, configProps);
        if (config != null) {
            String pid = config.getPid();
            String fpid = config.getFactoryPid();
            if (pid != null) {
                scp.properties.put("service.pid", pid);
            }
            if (fpid != null) {
                scp.properties.put("service.factoryPid", fpid);
            }
        }
        return scp;
    }

    public ServiceComponentProp map(ServiceComponent component, Dictionary configProperties) {
        ServiceComponentProp scp = null;
        try {
            if (Activator.DEBUG) {
                Activator.log.debug("Resolver.map(): Creating SCP for component " + component.name, null);
            }
            scp = new ServiceComponentProp(component, configProperties, this.mgr);
            Vector referenceDescriptions = component.references;
            if (referenceDescriptions != null && !referenceDescriptions.isEmpty()) {
                Vector<Reference> references = new Vector<Reference>(referenceDescriptions.size());
                int i = 0;
                while (i < referenceDescriptions.size()) {
                    ComponentReference cRef = (ComponentReference)referenceDescriptions.elementAt(i);
                    Reference ref = new Reference(cRef, scp, scp.getProperties());
                    references.addElement(ref);
                    ++i;
                }
                scp.references = references;
            }
            component.addServiceComponentProp(scp);
            this.scpEnabled.addElement(scp);
        }
        catch (Throwable t) {
            Activator.log(component.bc, 1, NLS.bind((String)Messages.ERROR_CREATING_SCP, (Object)component), t);
        }
        return scp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getEligible(ServiceEvent event) {
        if (Activator.DEBUG) {
            Activator.log.debug("Resolver.getEligible(): processing service event " + event.toString(), null);
            String eventType = "";
            if (event.getType() == 4) {
                eventType = "UNREGISTERING";
            } else if (event.getType() == 1) {
                eventType = "REGISTERED";
            } else if (event.getType() == 2) {
                eventType = "MODIFIED";
            }
            Activator.log.debug("Service event type: " + eventType, null);
        }
        Cloneable target = null;
        Vector resolvedComponents = null;
        switch (event.getType()) {
            case 1: {
                Vector unboundRefs;
                Object object = this.syncLock;
                synchronized (object) {
                    this.serviceReferenceTable.put(event.getServiceReference(), Boolean.TRUE);
                    if (this.scpEnabled.isEmpty()) {
                        return;
                    }
                    target = this.selectStaticBind(this.scpEnabled, event.getServiceReference());
                }
                if (target != null) {
                    this.instanceProcess.disposeInstances((Vector)target, 2);
                }
                object = this.syncLock;
                synchronized (object) {
                    resolvedComponents = this.getComponentsToBuild();
                    target = this.selectDynamicBind(this.scpEnabled, event.getServiceReference());
                }
                if (target != null && (unboundRefs = this.instanceProcess.dynamicBind((Vector)target)) != null) {
                    this.mgr.enqueueWork(this, 2, unboundRefs, false);
                }
                if (resolvedComponents.isEmpty()) break;
                this.instanceProcess.buildComponents(resolvedComponents, false);
                break;
            }
            case 4: {
                Vector newlyUnsatisfiedSCPs;
                Vector componentsToDispose;
                Object object = this.syncLock;
                synchronized (object) {
                    componentsToDispose = this.selectStaticUnBind(this.scpEnabled, event.getServiceReference(), false);
                }
                if (componentsToDispose != null) {
                    this.instanceProcess.disposeInstances(componentsToDispose, 2);
                }
                Object object2 = this.syncLock;
                synchronized (object2) {
                    this.serviceReferenceTable.remove(event.getServiceReference());
                    if (this.scpEnabled.isEmpty()) {
                        return;
                    }
                    newlyUnsatisfiedSCPs = this.selectNewlyUnsatisfied(event.getServiceReference());
                }
                if (!newlyUnsatisfiedSCPs.isEmpty()) {
                    this.instanceProcess.disposeInstances(newlyUnsatisfiedSCPs, 2);
                }
                object2 = this.syncLock;
                synchronized (object2) {
                    target = this.selectDynamicUnBind(this.scpEnabled, event.getServiceReference(), false);
                    if (componentsToDispose != null || !newlyUnsatisfiedSCPs.isEmpty()) {
                        resolvedComponents = this.getComponentsToBuild();
                    }
                }
                this.instanceProcess.dynamicUnBind((Hashtable)target);
                if (resolvedComponents != null && !resolvedComponents.isEmpty()) {
                    this.instanceProcess.buildComponents(resolvedComponents, false);
                }
                return;
            }
            case 2: {
                Vector unboundRefs;
                Vector componentsToDispose;
                Vector newlyUnsatisfiedSCPs;
                Object object = this.syncLock;
                synchronized (object) {
                    if (this.scpEnabled.isEmpty()) {
                        return;
                    }
                    newlyUnsatisfiedSCPs = this.selectNewlyUnsatisfied(event.getServiceReference());
                }
                if (!newlyUnsatisfiedSCPs.isEmpty()) {
                    this.instanceProcess.disposeInstances(newlyUnsatisfiedSCPs, 2);
                }
                object = this.syncLock;
                synchronized (object) {
                    componentsToDispose = this.selectStaticUnBind(this.scpEnabled, event.getServiceReference(), true);
                }
                if (componentsToDispose != null) {
                    this.instanceProcess.disposeInstances(componentsToDispose, 2);
                }
                object = this.syncLock;
                synchronized (object) {
                    componentsToDispose = this.selectStaticBind(this.scpEnabled, event.getServiceReference());
                }
                if (componentsToDispose != null) {
                    this.instanceProcess.disposeInstances(componentsToDispose, 2);
                }
                Hashtable referencesToUpdate = null;
                Object object3 = this.syncLock;
                synchronized (object3) {
                    target = this.selectDynamicUnBind(this.scpEnabled, event.getServiceReference(), true);
                    referencesToUpdate = this.selectReferencesToUpdate(this.scpEnabled, event.getServiceReference());
                }
                if (target != null) {
                    this.instanceProcess.dynamicUnBind((Hashtable)target);
                }
                if (referencesToUpdate != null) {
                    this.instanceProcess.referencePropertiesUpdated(referencesToUpdate);
                }
                object3 = this.syncLock;
                synchronized (object3) {
                    target = this.selectDynamicBind(this.scpEnabled, event.getServiceReference());
                    resolvedComponents = this.getComponentsToBuild();
                }
                if (target != null && (unboundRefs = this.instanceProcess.dynamicBind((Vector)target)) != null) {
                    this.mgr.enqueueWork(this, 2, unboundRefs, false);
                }
                if (resolvedComponents.isEmpty()) break;
                this.instanceProcess.buildComponents(resolvedComponents, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildNewlySatisfied(boolean checkForDependencyCycles) {
        Vector resolvedComponents;
        Object object = this.syncLock;
        synchronized (object) {
            if (checkForDependencyCycles) {
                this.findDependencyCycles();
            }
            resolvedComponents = this.getComponentsToBuild();
        }
        if (!resolvedComponents.isEmpty()) {
            this.instanceProcess.buildComponents(resolvedComponents, false);
        }
    }

    private Vector getComponentsToBuild() {
        Vector resolvedComponents = this.resolveEligible();
        int i = resolvedComponents.size() - 1;
        while (i >= 0) {
            ServiceComponentProp scp = (ServiceComponentProp)resolvedComponents.elementAt(i);
            if (scp.getState() != 4) {
                resolvedComponents.removeElementAt(i);
            }
            --i;
        }
        return resolvedComponents;
    }

    public void componentDisposed(ServiceComponentProp scp) {
    }

    /*
     * Unable to fully structure code
     */
    private Vector resolveEligible() {
        try {
            enabledSCPs = (Vector)this.scpEnabled.clone();
            k = enabledSCPs.size() - 1;
            while (k >= 0) {
                block19: {
                    scp = (ServiceComponentProp)enabledSCPs.elementAt(k);
                    try {
                        refs = scp.references;
                        i = 0;
                        while (refs != null && i < refs.size()) {
                            reference = (Reference)refs.elementAt(i);
                            if (reference != null) {
                                v0 = resolved = reference.isRequiredFor(scp.serviceComponent) == false || reference.hasProviders(this.serviceReferenceTable) != false;
                                if (!resolved) {
                                    if (Activator.DEBUG) {
                                        Activator.log.debug("Resolver.resolveEligible(): reference '" + reference.reference.name + "' of component '" + scp.name + "' is not resolved", null);
                                    }
                                    enabledSCPs.removeElementAt(k);
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                    catch (IllegalStateException v1) {
                        this.scpEnabled.removeElement(scp);
                        enabledSCPs.removeElementAt(k);
                        break block19;
                    }
                    if (scp.serviceComponent.provides == null || System.getSecurityManager() == null) ** GOTO lbl-1000
                    provides = scp.serviceComponent.provides;
                    hasPermission = true;
                    i = 0;
                    while (i < provides.length) {
                        block20: {
                            try {
                                if (!scp.bc.getBundle().hasPermission((Object)new ServicePermission(provides[i], "register"))) {
                                    hasPermission = false;
                                }
                                break block20;
                            }
                            catch (IllegalStateException v2) {
                                hasPermission = false;
                            }
                            catch (Throwable v3) {
                                hasPermission = false;
                            }
                            break;
                        }
                        ++i;
                    }
                    if (!hasPermission) {
                        Activator.log(null, 2, NLS.bind((String)Messages.COMPONENT_LACKS_APPROPRIATE_PERMISSIONS, (Object)scp.name, (Object)provides[i]), null);
                        this.removeEnabledSCP(scp);
                        enabledSCPs.removeElementAt(k);
                    } else if (!scp.isBuilt() && scp.getState() != 128) {
                        scp.setState(4);
                    }
                }
                --k;
            }
            if (Activator.DEBUG) {
                Activator.log.debug("Resolver.resolveEligible(): resolved components = " + enabledSCPs.toString(), null);
            }
            return enabledSCPs;
        }
        catch (Throwable e) {
            Activator.log(null, 1, Messages.UNEXPECTED_EXCEPTION, e);
            return new Vector<E>();
        }
    }

    private Vector selectNewlyUnsatisfied(ServiceReference serviceRef) {
        try {
            Vector result = (Vector)this.scpEnabled.clone();
            int k = result.size() - 1;
            while (k >= 0) {
                try {
                    ServiceComponentProp scp = (ServiceComponentProp)result.elementAt(k);
                    Vector refs = scp.references;
                    boolean toDispose = false;
                    int i = 0;
                    while (refs != null && i < refs.size()) {
                        Reference reference = (Reference)refs.elementAt(i);
                        if (reference != null && (serviceRef == null || reference.reference.bind == null || scp.getState() != 16 || reference.dynamicUnbindReference(serviceRef) || reference.staticUnbindReference(serviceRef)) && (serviceRef == null || this.isPossibleMatch(reference, serviceRef))) {
                            boolean resolved;
                            boolean bl = resolved = !reference.isRequiredFor(scp.serviceComponent) || reference.hasProviders(this.serviceReferenceTable);
                            if (!resolved && scp.isBuilt()) {
                                if (Activator.DEBUG) {
                                    Activator.log.debug("Resolver.selectNewlyUnsatisfied(): reference '" + reference.reference.name + "' of component '" + scp.name + "' is not resolved", null);
                                }
                                toDispose = true;
                                break;
                            }
                        }
                        ++i;
                    }
                    if (!toDispose) {
                        result.removeElementAt(k);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    this.scpEnabled.removeElement(result.elementAt(k));
                    result.removeElementAt(k);
                }
                --k;
            }
            return result;
        }
        catch (Throwable e) {
            Activator.log(null, 1, Messages.UNEXPECTED_EXCEPTION, e);
            return new Vector(1);
        }
    }

    private boolean isPossibleMatch(Reference reference, ServiceReference serviceRef) {
        String[] serviceNames = (String[])serviceRef.getProperty("objectClass");
        boolean hasName = false;
        int i = 0;
        while (i < serviceNames.length) {
            if (serviceNames[i].equals(reference.interfaceName)) {
                hasName = true;
                break;
            }
            ++i;
        }
        if (!hasName) {
            return false;
        }
        try {
            Filter filter = FrameworkUtil.createFilter((String)reference.target);
            return filter.match(serviceRef);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    void disableComponents(Vector componentDescriptions, int deactivateReason) {
        long start = 0L;
        if (Activator.PERF) {
            start = System.currentTimeMillis();
        }
        Vector<ServiceComponentProp> removeList = null;
        if (componentDescriptions != null) {
            int i = 0;
            while (i < componentDescriptions.size()) {
                ServiceComponentProp scp;
                Vector scpList;
                ServiceComponent component = (ServiceComponent)componentDescriptions.elementAt(i);
                component.enabled = false;
                component.setState(1);
                if (Activator.DEBUG) {
                    Activator.log.debug("Resolver.disableComponents() " + component.name, null);
                }
                if ((scpList = component.componentProps) != null) {
                    int iter = 0;
                    while (iter < scpList.size()) {
                        scp = (ServiceComponentProp)scpList.elementAt(iter);
                        if (removeList == null) {
                            removeList = new Vector<ServiceComponentProp>();
                        }
                        removeList.addElement(scp);
                        ++iter;
                    }
                }
                if (removeList != null) {
                    this.disposeComponentConfigs(removeList, deactivateReason);
                    removeList.removeAllElements();
                }
                if (component.componentProps != null) {
                    int j = 0;
                    while (j < component.componentProps.size()) {
                        scp = (ServiceComponentProp)component.componentProps.elementAt(j);
                        scp.setState(256);
                        ++j;
                    }
                    component.componentProps.removeAllElements();
                }
                ++i;
            }
        }
        if (Activator.PERF) {
            start = System.currentTimeMillis() - start;
            Activator.log.info("[DS perf] " + Integer.toString(componentDescriptions.size()) + " Components disabled for " + Long.toString(start) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponentConfigs(Vector scps, int deactivateReason) {
        Object object = this.syncLock;
        synchronized (object) {
            this.removeAll(this.scpEnabled, scps);
        }
        this.instanceProcess.disposeInstances(scps, deactivateReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performWork(int workAction, Object workObject) {
        try {
            if (Activator.DEBUG) {
                String work = WORK_TITLES[workAction - 1];
                Activator.log.debug("Resolver.performWork(): " + work + workObject, null);
            }
            switch (workAction) {
                case 1: {
                    if (workObject != null) {
                        this.instanceProcess.buildComponents((Vector)workObject, false);
                    }
                    break;
                }
                case 2: {
                    if (workObject == null) break;
                    Vector toBind = (Vector)workObject;
                    Object object = this.syncLock;
                    synchronized (object) {
                        int i = toBind.size() - 1;
                        while (i >= 0) {
                            Reference ref = (Reference)toBind.elementAt(i);
                            if (ref.scp.isUnsatisfied()) {
                                toBind.removeElementAt(i);
                            }
                            --i;
                        }
                        if (toBind.isEmpty()) {
                            return;
                        }
                    }
                    this.instanceProcess.dynamicBind(toBind);
                    break;
                }
                case 3: {
                    if (workObject == null) break;
                    this.instanceProcess.disposeInstances((Vector)workObject, 0);
                }
                default: {
                    break;
                }
            }
        }
        catch (Throwable e) {
            Activator.log(null, 1, Messages.UNEXPECTED_EXCEPTION, e);
        }
    }

    private Vector selectDynamicBind(Vector scps, ServiceReference serviceReference) {
        try {
            Vector<Reference> toBind = null;
            int i = 0;
            int size = scps.size();
            while (i < size) {
                Vector references;
                ServiceComponentProp scp = (ServiceComponentProp)scps.elementAt(i);
                if (!scp.isUnsatisfied() && (references = scp.references) != null) {
                    int j = 0;
                    while (j < references.size()) {
                        Reference reference = (Reference)references.elementAt(j);
                        if (reference.bindNewReference(serviceReference, true)) {
                            if (toBind == null) {
                                toBind = new Vector<Reference>(2);
                            }
                            toBind.addElement(reference);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (toBind != null && Activator.DEBUG) {
                Activator.log.debug("Resolver.selectDynamicBind(): selected = " + toBind.toString(), null);
            }
            return toBind;
        }
        catch (Throwable t) {
            Activator.log(null, 1, Messages.UNEXPECTED_EXCEPTION, t);
            return null;
        }
    }

    private Vector selectStaticBind(Vector scps, ServiceReference serviceReference) {
        try {
            Vector<Reference> toBind = null;
            int i = 0;
            int size = scps.size();
            while (i < size) {
                Vector references;
                ServiceComponentProp scp = (ServiceComponentProp)scps.elementAt(i);
                if (!scp.isUnsatisfied() && (references = scp.references) != null) {
                    int j = 0;
                    while (j < references.size()) {
                        Reference reference = (Reference)references.elementAt(j);
                        if (reference.bindNewReference(serviceReference, false)) {
                            if (toBind == null) {
                                toBind = new Vector<Reference>(2);
                            }
                            toBind.addElement(reference);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            Vector<ServiceComponentProp> result = null;
            Reference ref = null;
            if (toBind != null) {
                result = new Vector<ServiceComponentProp>();
                int i2 = 0;
                while (i2 < toBind.size()) {
                    ref = (Reference)toBind.elementAt(i2);
                    if (!result.contains(ref.scp)) {
                        result.addElement(ref.scp);
                    }
                    ++i2;
                }
            }
            if (result != null && Activator.DEBUG) {
                Activator.log.debug("Resolver.selectStaticBind(): selected = " + result.toString(), null);
            }
            return result;
        }
        catch (Throwable t) {
            Activator.log(null, 1, Messages.UNEXPECTED_EXCEPTION, t);
            return null;
        }
    }

    private Vector selectStaticUnBind(Vector scpsToCheck, ServiceReference serviceReference, boolean checkSatisfied) {
        try {
            Vector<ServiceComponentProp> toUnbind = null;
            int i = 0;
            int size = scpsToCheck.size();
            while (i < size) {
                Vector references;
                ServiceComponentProp scp = (ServiceComponentProp)scpsToCheck.elementAt(i);
                if (!scp.isUnsatisfied() && (references = scp.references) != null) {
                    int j = 0;
                    while (j < references.size()) {
                        Reference reference = (Reference)references.elementAt(j);
                        if (!(!reference.staticUnbindReference(serviceReference) || checkSatisfied && reference.isInSatisfiedList(serviceReference))) {
                            if (toUnbind == null) {
                                toUnbind = new Vector<ServiceComponentProp>(2);
                            }
                            toUnbind.addElement(scp);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (toUnbind != null && Activator.DEBUG) {
                Activator.log.debug("Resolver.selectStaticUnBind(): selected = " + toUnbind.toString(), null);
            }
            return toUnbind;
        }
        catch (Throwable t) {
            Activator.log(null, 1, Messages.UNEXPECTED_EXCEPTION, t);
            return null;
        }
    }

    private Hashtable selectDynamicUnBind(Vector scps, ServiceReference serviceReference, boolean checkSatisfied) {
        try {
            if (Activator.DEBUG) {
                Activator.log.debug("Resolver.selectDynamicUnBind(): entered", null);
            }
            Hashtable unbindTable = null;
            int i = 0;
            while (i < scps.size()) {
                Vector references;
                Hashtable<ServiceComponentProp, ServiceReference> unbindSubTable = null;
                ServiceComponentProp scp = (ServiceComponentProp)scps.elementAt(i);
                if (!scp.isUnsatisfied() && (references = scp.references) != null) {
                    int j = 0;
                    while (j < references.size()) {
                        Reference reference = (Reference)references.elementAt(j);
                        if (reference.dynamicUnbindReference(serviceReference)) {
                            if (!checkSatisfied || !reference.isInSatisfiedList(serviceReference)) {
                                if (Activator.DEBUG) {
                                    Activator.log.debug("Resolver.selectDynamicUnBind(): unbinding " + scp.toString(), null);
                                }
                                if (unbindSubTable == null) {
                                    unbindSubTable = new Hashtable<ServiceComponentProp, ServiceReference>(11);
                                }
                                unbindSubTable.put(scp, serviceReference);
                                if (unbindTable == null) {
                                    unbindTable = new Hashtable(11);
                                }
                                unbindTable.put(reference, unbindSubTable);
                            }
                        } else if (Activator.DEBUG) {
                            Activator.log.debug("Resolver.selectDynamicUnBind(): not unbinding " + scp + " service ref=" + serviceReference, null);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (unbindTable != null && Activator.DEBUG) {
                Activator.log.debug("Resolver.selectDynamicUnBind(): unbindTable is " + unbindTable.toString(), null);
            }
            return unbindTable;
        }
        catch (Throwable t) {
            Activator.log(null, 1, Messages.UNEXPECTED_EXCEPTION, t);
            return null;
        }
    }

    private Hashtable selectReferencesToUpdate(Vector scps, ServiceReference serviceReference) {
        try {
            if (Activator.DEBUG) {
                Activator.log.debug("Resolver.selectReferencesToUpdate(): entered", null);
            }
            Hashtable referencesTable = null;
            int i = 0;
            while (i < scps.size()) {
                Vector references;
                Hashtable<ServiceComponentProp, ServiceReference> updateSubTable = null;
                ServiceComponentProp scp = (ServiceComponentProp)scps.elementAt(i);
                if (!scp.isUnsatisfied() && scp.serviceComponent.isNamespaceAtLeast12() && (references = scp.references) != null) {
                    int j = 0;
                    while (j < references.size()) {
                        Reference reference = (Reference)references.elementAt(j);
                        if (reference.reference.updated != null && (reference.isStatic() ? reference.staticUnbindReference(serviceReference) : reference.dynamicUnbindReference(serviceReference))) {
                            if (Activator.DEBUG) {
                                Activator.log.debug("Resolver.selectReferencesToUpdate(): selected for update reference " + reference.reference.name + " of component " + scp.toString(), null);
                            }
                            if (updateSubTable == null) {
                                updateSubTable = new Hashtable<ServiceComponentProp, ServiceReference>(11);
                            }
                            updateSubTable.put(scp, serviceReference);
                            if (referencesTable == null) {
                                referencesTable = new Hashtable(11);
                            }
                            referencesTable.put(reference, updateSubTable);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (referencesTable != null && Activator.DEBUG) {
                Activator.log.debug("Resolver.selectReferencesToUpdate(): referencesTable is " + referencesTable.toString(), null);
            }
            return referencesTable;
        }
        catch (Throwable t) {
            Activator.log(null, 1, Messages.UNEXPECTED_EXCEPTION, t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceComponentProp mapNewFactoryComponent(ServiceComponent component, Dictionary configProperties) {
        Object object = this.syncLock;
        synchronized (object) {
            ServiceComponentProp newSCP = this.map(component, configProperties);
            newSCP.setComponentFactory(false);
            this.findDependencyCycles();
            Vector eligibleSCPs = this.resolveEligible();
            if (!eligibleSCPs.contains(newSCP)) {
                this.removeEnabledSCP(newSCP);
                throw new ComponentException(NLS.bind((String)Messages.CANT_RESOLVE_COMPONENT_INSTANCE, (Object)newSCP, (Object)configProperties));
            }
            return newSCP;
        }
    }

    private void findDependencyCycles() {
        Vector emptyVector = new Vector();
        try {
            Hashtable dependencies = new Hashtable();
            int i = this.scpEnabled.size() - 1;
            while (i >= 0) {
                ServiceComponentProp enabledSCP = (ServiceComponentProp)this.scpEnabled.elementAt(i);
                if (enabledSCP.references != null) {
                    Vector<ReferenceSCPWrapper> dependencyVector = new Vector<ReferenceSCPWrapper>(1);
                    int j = 0;
                    while (j < enabledSCP.references.size()) {
                        Reference reference = (Reference)enabledSCP.references.elementAt(j);
                        ServiceComponentProp[] providerSCPs = reference.selectProviders(this.scpEnabled);
                        if (providerSCPs != null) {
                            int k = 0;
                            while (k < providerSCPs.length) {
                                dependencyVector.addElement(new ReferenceSCPWrapper(reference, providerSCPs[k]));
                                ++k;
                            }
                        }
                        ++j;
                    }
                    if (!dependencyVector.isEmpty()) {
                        dependencies.put(enabledSCP, dependencyVector);
                    } else {
                        dependencies.put(enabledSCP, emptyVector);
                    }
                }
                --i;
            }
            Hashtable visited = new Hashtable(11);
            Enumeration keys = dependencies.keys();
            while (keys.hasMoreElements()) {
                ServiceComponentProp scp = (ServiceComponentProp)keys.nextElement();
                if (visited.containsKey(scp)) continue;
                Vector currentStack = new Vector(2);
                this.checkDependencies(scp, visited, dependencies, currentStack);
            }
        }
        catch (CircularityException e) {
            Activator.log(e.getCausingComponent().serviceComponent.bc, 1, NLS.bind((String)Messages.CIRCULARITY_EXCEPTION_FOUND, (Object)e.getCausingComponent().serviceComponent), e);
            this.removeEnabledSCP(e.getCausingComponent());
            this.findDependencyCycles();
        }
    }

    private void checkDependencies(ServiceComponentProp scp, Hashtable visited, Hashtable dependencies, Vector currentStack) throws CircularityException {
        if (visited.containsKey(scp)) {
            return;
        }
        Vector refSCPs = (Vector)dependencies.get(scp);
        if (refSCPs != null) {
            int i = 0;
            while (i < refSCPs.size()) {
                ReferenceSCPWrapper refSCP = (ReferenceSCPWrapper)refSCPs.elementAt(i);
                if (currentStack.contains(refSCP)) {
                    this.processDependencyCycle(refSCP, currentStack);
                } else {
                    currentStack.addElement(refSCP);
                    this.checkDependencies(refSCP.producer, visited, dependencies, currentStack);
                    currentStack.removeElement(refSCP);
                }
                ++i;
            }
        }
        visited.put(scp, "");
    }

    private void processDependencyCycle(ReferenceSCPWrapper refSCP, Vector currentStack) throws CircularityException {
        ReferenceSCPWrapper optionalRefSCP = null;
        int i = currentStack.indexOf(refSCP);
        while (i < currentStack.size()) {
            ReferenceSCPWrapper cycleRefSCP = (ReferenceSCPWrapper)currentStack.elementAt(i);
            if (!cycleRefSCP.ref.isRequired()) {
                optionalRefSCP = cycleRefSCP;
                break;
            }
            ++i;
        }
        if (optionalRefSCP == null) {
            throw new CircularityException(refSCP.ref.scp);
        }
        if (optionalRefSCP.ref.policy == 0) {
            Activator.log(optionalRefSCP.ref.scp.bc, 1, NLS.bind((String)Messages.STATIC_OPTIONAL_REFERENCE_TO_BE_REMOVED, (Object)optionalRefSCP.ref.reference), null);
            optionalRefSCP.ref.scp.references.removeElement(optionalRefSCP.ref);
        }
        optionalRefSCP.ref.scp.setDelayActivateSCPName(optionalRefSCP.producer.serviceComponent.name);
    }

    private void removeAll(Vector src, Vector elementsToRemove) {
        int i = src.size() - 1;
        while (i >= 0) {
            if (elementsToRemove.contains(src.elementAt(i))) {
                src.removeElementAt(i);
            }
            --i;
        }
    }

    private void removeEnabledSCP(ServiceComponentProp scp) {
        this.scpEnabled.removeElement(scp);
        scp.serviceComponent.componentProps.remove(scp);
        scp.setState(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reorderSCP(ServiceComponentProp scp) {
        Object object = this.syncLock;
        synchronized (object) {
            if (this.scpEnabled.removeElement(scp)) {
                this.scpEnabled.addElement(scp);
            }
        }
    }

    public void removeFromSatisfiedList(ServiceComponentProp scp) {
        Vector<ServiceComponentProp> tmp = new Vector<ServiceComponentProp>();
        tmp.addElement(scp);
        this.mgr.enqueueWork(this, 3, tmp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent(long componentId) {
        Vector vector = this.scpEnabled;
        synchronized (vector) {
            int i = 0;
            while (i < this.scpEnabled.size()) {
                ServiceComponentProp scp = (ServiceComponentProp)this.scpEnabled.elementAt(i);
                if (scp.getId() == componentId) {
                    return scp;
                }
                ++i;
            }
        }
        return null;
    }

    private static class ReferenceSCPWrapper {
        public Reference ref;
        public ServiceComponentProp producer;

        protected ReferenceSCPWrapper(Reference ref, ServiceComponentProp producer) {
            this.ref = ref;
            this.producer = producer;
        }

        public String toString() {
            return "Reference : " + this.ref + " ::: SCP : " + this.producer;
        }
    }
}

