/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CEntriesSet;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;

public final class CExternalSetting
implements ICExternalSetting {
    private KindBasedStore<CEntriesSet> fStore = new KindBasedStore(false);
    private String[] fContentTypeIds;
    private String[] fLanguageIds;
    private String[] fExtensions;

    public CExternalSetting(ICExternalSetting base) {
        this.fLanguageIds = base.getCompatibleLanguageIds();
        this.fContentTypeIds = base.getCompatibleContentTypeIds();
        this.fExtensions = base.getCompatibleExtensions();
        this.initEntryStore(base.getEntries());
    }

    public CExternalSetting(ICExternalSetting base, ICSettingEntry[] entries) {
        this(base);
        this.initEntryStore(entries);
    }

    public CExternalSetting(String[] languageIDs, String[] contentTypeIds, String[] extensions, ICSettingEntry[] entries) {
        if (languageIDs != null) {
            this.fLanguageIds = (String[])languageIDs.clone();
        }
        if (contentTypeIds != null) {
            this.fContentTypeIds = (String[])contentTypeIds.clone();
        }
        if (extensions != null) {
            this.fExtensions = (String[])extensions.clone();
        }
        this.initEntryStore(entries);
    }

    private void initEntryStore(ICSettingEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            ICSettingEntry entry = entries[i];
            this.addEntry(entry);
            ++i;
        }
    }

    private void addEntry(ICSettingEntry entry) {
        this.getEntriesSet(entry.getKind(), true).addEntry(entry);
    }

    private CEntriesSet getEntriesSet(int kind, boolean create) {
        CEntriesSet set = this.fStore.get(kind);
        if (set == null && create) {
            set = new CEntriesSet();
            this.fStore.put(kind, set);
        }
        return set;
    }

    public String[] getCompatibleContentTypeIds() {
        if (this.fContentTypeIds != null) {
            return (String[])this.fContentTypeIds.clone();
        }
        return null;
    }

    public String[] getCompatibleExtensions() {
        if (this.fExtensions != null) {
            return (String[])this.fExtensions.clone();
        }
        return null;
    }

    public String[] getCompatibleLanguageIds() {
        if (this.fLanguageIds != null) {
            return (String[])this.fLanguageIds.clone();
        }
        return null;
    }

    public ICSettingEntry[] getEntries(int kind) {
        CEntriesSet set = this.getEntriesSet(kind, false);
        if (set != null) {
            return set.toArray();
        }
        return new ICSettingEntry[0];
    }

    public ICSettingEntry[] getEntries() {
        ArrayList<ICSettingEntry> result = new ArrayList<ICSettingEntry>();
        int[] kinds = KindBasedStore.getAllEntryKinds();
        int i = 0;
        while (i < kinds.length) {
            CEntriesSet list = this.getEntriesSet(kinds[i], false);
            if (list != null) {
                result.addAll(Arrays.asList(list.toArray()));
            }
            ++i;
        }
        return result.toArray(new ICSettingEntry[result.size()]);
    }
}

