/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.control;

import java.util.EnumMap;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.DAResult;

public class ProgressTable {
    private static STAGE[] traceStartProgress = new STAGE[]{STAGE.CHECK_DEV, STAGE.CHECK_APP, STAGE.CHECK_CONFIG, STAGE.CREATE_PROJECT, STAGE.ESTABLISH_DB, STAGE.CREATE_DBTABLE, STAGE.RESET_UI, STAGE.CREATE_DATATHREAD, STAGE.CREATE_MESSAGEPARSER, STAGE.CREATE_LOGPARSER, STAGE.CREATE_PAGEMANAGER, STAGE.CREATE_CALLSTACK_INSERTER, STAGE.START_RESOURCE_MONITOR, STAGE.SEND_STARTMSG, STAGE.WAIT_PROCINFO, STAGE.START_CLOCK, STAGE.CREATE_SCREENSHOT_TIMER, STAGE.CREATE_UPDATE_TIMER, STAGE.FINAL};
    private static STAGE[] cancelTraceStartProgress = new STAGE[]{STAGE.CREATE_UPDATE_TIMER, STAGE.CREATE_SCREENSHOT_TIMER, STAGE.START_CLOCK, STAGE.SEND_STARTMSG, STAGE.START_RESOURCE_MONITOR, STAGE.CREATE_CALLSTACK_INSERTER, STAGE.CREATE_PAGEMANAGER, STAGE.CREATE_LOGPARSER, STAGE.CREATE_MESSAGEPARSER, STAGE.CREATE_DATATHREAD, STAGE.CREATE_PROJECT, STAGE.FINAL};
    private static STAGE[] traceEndProgress = new STAGE[]{STAGE.STOP_RESOURCE_MONITOR, STAGE.SEND_STOPMSG, STAGE.STOP_CLOCK, STAGE.STOP_SCREENSHOT_TIMER, STAGE.STOP_UPDATE_TIMER, STAGE.STOP_DATATHREADS, STAGE.SUMMARIZE_UI, STAGE.FINAL};
    private static STAGE[] rangeAnalysisProgress = new STAGE[]{STAGE.FINAL};

    public static int getPercent(PHASE phase, STAGE stage) {
        Map<STAGE, Integer> progressMap = phase.accumMap;
        Integer accumVal = progressMap.get((Object)stage);
        if (accumVal != null) {
            return accumVal * 100 / progressMap.get((Object)STAGE.FINAL);
        }
        return 0;
    }

    static /* synthetic */ STAGE[] access$0() {
        return traceStartProgress;
    }

    static /* synthetic */ STAGE[] access$1() {
        return cancelTraceStartProgress;
    }

    static /* synthetic */ STAGE[] access$2() {
        return traceEndProgress;
    }

    static /* synthetic */ STAGE[] access$3() {
        return rangeAnalysisProgress;
    }

    public static enum PHASE {
        TRACE_START(ProgressTable.access$0()),
        CANCEL_TRACE_START(ProgressTable.access$1()),
        TRACE_END(ProgressTable.access$2()),
        RANGE_ANALYSIS(ProgressTable.access$3());

        protected STAGE[] stageArray;
        protected Map<STAGE, Integer> accumMap = new EnumMap<STAGE, Integer>(STAGE.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PHASE(STAGE[] array) {
            this.stageArray = array;
            Map<STAGE, Integer> map = this.accumMap;
            synchronized (map) {
                int total = 0;
                int i = 0;
                while (i < this.stageArray.length) {
                    this.accumMap.put(this.stageArray[i], total += this.stageArray[i].weight);
                    ++i;
                }
            }
        }
    }

    public static enum STAGE {
        NONE(0),
        CHECK_DEV(3, DAResult.ErrorCode.ERR_DISCONNECTED),
        CHECK_APP(3, DAResult.ErrorCode.ERR_INVALID_APP),
        CHECK_CONFIG(5, DAResult.ErrorCode.ERR_CONFIG_FAILED),
        CREATE_PROJECT(2),
        ESTABLISH_DB(5),
        CREATE_DBTABLE(20),
        RESET_UI(3),
        CREATE_DATATHREAD(3, DAResult.ErrorCode.ERR_START_DATA_CHANNEL),
        CREATE_MESSAGEPARSER(3, DAResult.ErrorCode.ERR_START_MESSAGE_PARSER),
        CREATE_LOGPARSER(3, DAResult.ErrorCode.ERR_START_LOG_PARSER),
        CREATE_PAGEMANAGER(10),
        CREATE_CALLSTACK_INSERTER(3),
        START_RESOURCE_MONITOR(2),
        SEND_STARTMSG(15),
        WAIT_PROCINFO(20, DAResult.ErrorCode.ERR_NO_PROCINFO),
        START_CLOCK(2),
        CREATE_SCREENSHOT_TIMER(2),
        CREATE_UPDATE_TIMER(2),
        STOP_RESOURCE_MONITOR(2),
        STOP_CLOCK(2),
        STOP_SCREENSHOT_TIMER(2),
        STOP_UPDATE_TIMER(2),
        SEND_STOPMSG(15),
        STOP_DATATHREADS(48),
        SUMMARIZE_UI(5),
        FINAL(0);

        protected int weight;
        protected DAResult.ErrorCode errCode;

        private STAGE(int weight) {
            this.weight = weight;
            this.errCode = DAResult.ErrorCode.ERR_UNKNOWN;
        }

        private STAGE(int weight, DAResult.ErrorCode errCode) {
            this.weight = weight;
            this.errCode = errCode;
        }
    }
}

