/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.error;

import java.util.Hashtable;
import org.tizen.dynamicanalyzer.error.DAErrorCode;
import org.tizen.dynamicanalyzer.util.Logger;

public class ErrorCodeManager {
    private static ErrorCodeManager instance = null;
    private Hashtable<Long, DAErrorCode> hash = new Hashtable();

    public static ErrorCodeManager getInatance() {
        if (instance == null) {
            instance = new ErrorCodeManager();
        }
        return instance;
    }

    public ErrorCodeManager() {
        this.initErrorCode();
    }

    public DAErrorCode getErrorCode(long errno) {
        return this.hash.get(errno);
    }

    public String getErrorCode(String strErr) {
        long errno = -1L;
        try {
            errno = Long.parseLong(strErr);
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
        }
        return this.hash.get(errno).name();
    }

    public String getErrorDescription(long errno) {
        return this.hash.get(errno).getMessage();
    }

    public void initErrorCode() {
        DAErrorCode[] cErrorCodes = DAErrorCode.values();
        int size = cErrorCodes.length;
        int i = 0;
        while (i < size) {
            this.hash.put(cErrorCodes[i].getErrno(), cErrorCodes[i]);
            ++i;
        }
    }
}

