/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data;

import java.util.Arrays;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.protocol.DebugLog;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProcessProfileData;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.UnsignedInt;

public class SystemData
extends LogData {
    double[] cpuFrequency = null;
    double[] cpuLoad = null;
    long systemMemoryUsed = 0L;
    int targetProcessCount = 0;
    ProcessProfileData[] processProfileDataList = null;
    int otherProcessCount = 0;
    String otherProcessLoad = null;
    UnsignedInt totalUsedDrive;
    UnsignedInt diskReadOpCount;
    UnsignedInt diskReadByteSize;
    UnsignedInt diskWriteOpCount;
    UnsignedInt diskWrittenByteSize;
    UnsignedInt networkSendSize;
    UnsignedInt networkReceiveSize;
    int wifi = 0;
    int btStatus = 0;
    int gpsStatus = 0;
    int brightness = 0;
    int camera = 0;
    int sound = 0;
    int audio = 0;
    int vibration = 0;
    int voltage = 0;
    int rssi = 0;
    int video = 0;
    int call = 0;
    int dnet = 0;
    UnsignedInt energyUsage;
    String deviceEnergyUsage = null;
    String applicationEnergyUsage = null;

    @Override
    public SystemData clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    protected boolean parse(DATime startTime) {
        super.parse(startTime);
        this.cpuFrequency = this.parseCpu();
        this.cpuLoad = this.parseCpu();
        this.systemMemoryUsed = this.getLong();
        this.targetProcessCount = this.getInt();
        if (DebugLog.isEnabled()) {
            DebugLog.printData1("CpuFreq(%s), CpuLoad(%s), sysMemUsed(%d), ProcCount(%d)\n", Arrays.toString(this.cpuFrequency), Arrays.toString(this.cpuLoad), this.systemMemoryUsed, this.targetProcessCount);
        }
        this.parseTargetProcessInfo(this.targetProcessCount);
        this.otherProcessCount = this.getInt();
        this.otherProcessLoad = this.parseLoad(this.otherProcessCount);
        this.totalUsedDrive = this.getUnsignedInt();
        this.diskReadOpCount = this.getUnsignedInt();
        this.diskReadByteSize = this.getUnsignedInt();
        this.diskWriteOpCount = this.getUnsignedInt();
        this.diskWrittenByteSize = this.getUnsignedInt();
        this.networkSendSize = this.getUnsignedInt();
        this.networkReceiveSize = this.getUnsignedInt();
        this.wifi = this.getInt();
        this.btStatus = this.getInt();
        this.gpsStatus = this.getInt();
        this.brightness = this.getInt();
        this.camera = this.getInt();
        this.sound = this.getInt();
        this.audio = this.getInt();
        this.vibration = this.getInt();
        this.voltage = this.getInt();
        this.rssi = this.getInt();
        this.video = this.getInt();
        this.call = this.getInt();
        this.dnet = this.getInt();
        this.energyUsage = this.getUnsignedInt();
        this.deviceEnergyUsage = this.parseUsage();
        this.applicationEnergyUsage = this.parseUsage();
        if (DebugLog.isEnabled()) {
            DebugLog.printData1("OtherProc(%d,%s)\n", this.otherProcessCount, this.otherProcessLoad);
            DebugLog.printData1("UsedDisk(%s), Read(%s,%s), Write(%s,%s), Send(%s), Recv(%s)\n", this.totalUsedDrive, this.diskReadOpCount, this.diskReadByteSize, this.diskWriteOpCount, this.diskWrittenByteSize, this.networkSendSize, this.networkReceiveSize);
            DebugLog.printData1("WF(%d), BT(%d), GPS(%d), BR(%d), CMR(%d), SND(%d), AD(%d)\n", this.wifi, this.btStatus, this.gpsStatus, this.brightness, this.camera, this.sound, this.audio);
            DebugLog.printData1("VBR(%d), VT(%d), RSSI(%d), VD(%d), CALL(%d), DNET(%d), ENG(%s)\n", this.vibration, this.voltage, this.rssi, this.video, this.call, this.dnet, this.energyUsage);
            DebugLog.printData1("DeviceEnergy(%s), AppEnergy(%s)\n", this.deviceEnergyUsage, this.applicationEnergyUsage);
        }
        return true;
    }

    private String parseLoad(int count) {
        StringBuffer outBuf = new StringBuffer();
        int ii = 0;
        while (ii < count) {
            block3: {
                try {
                    int tid = this.getInt();
                    outBuf.append(tid).append(",");
                    float f = this.getFloat();
                    outBuf.append(f);
                    if (ii + 1 == count) break block3;
                    outBuf.append(",");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Logger.exception((Throwable)e);
                    break;
                }
            }
            ++ii;
        }
        return outBuf.toString();
    }

    private double[] parseCpu() {
        int coreCount = Global.getProject().getDeviceStatusInfo().getCpuCount();
        double[] cpu = new double[coreCount];
        int i = 0;
        while (i < coreCount) {
            cpu[i] = this.getFloat();
            ++i;
        }
        return cpu;
    }

    private String parseUsage() {
        int count = Global.getProject().getDeviceStatusInfo().getDeviceCount();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < count) {
            UnsignedInt value = this.getUnsignedInt();
            buffer.append(value.getValue());
            if (i + 1 != count) {
                buffer.append(',');
            }
            ++i;
        }
        return buffer.toString();
    }

    private void parseTargetProcessInfo(int targetProcessCount) {
        this.processProfileDataList = new ProcessProfileData[targetProcessCount];
        int i = 0;
        while (i < targetProcessCount) {
            ProcessProfileData processData = new ProcessProfileData();
            processData.setPid(this.getInt());
            processData.setProcessLoad(this.getFloat());
            processData.setVirtualMemory(this.getLong());
            processData.setResidentMemory(this.getLong());
            processData.setSharedMemory(this.getLong());
            processData.setPssMemory(this.getLong());
            if (Global.getProject().getMempsAvailable()) {
                processData.setGemMemory(this.getLong());
                processData.setThreeDMemory(this.getLong());
            }
            processData.setTotalAllocSize(this.getLong());
            processData.setThreadCount(this.getInt());
            processData.setThreadLoad(this.parseLoad(processData.getThreadCount()));
            this.processProfileDataList[i] = processData;
            if (DebugLog.isEnabled()) {
                DebugLog.printData2("%d: pid(%d), Load(%f), V.R.S.P.A(%d,%d,%d,%d,%d), Thread(%d,%s)\n", i, processData.getPid(), Float.valueOf(processData.getProcessLoad()), processData.getVirtualMemory(), processData.getResidentMemory(), processData.getSharedMemory(), processData.getPssMemory(), processData.getTotalAllocSize(), processData.getThreadCount(), processData.getThreadLoad());
            }
            ++i;
        }
    }

    public UnsignedInt getEnergy() {
        return this.energyUsage;
    }

    public void setEnergy(UnsignedInt energy) {
        this.energyUsage = energy;
    }

    public int getWifi() {
        return this.wifi;
    }

    public void setWifi(int wifi) {
        this.wifi = wifi;
    }

    public int getBtStatus() {
        return this.btStatus;
    }

    public void setBtStatus(int btStatus) {
        this.btStatus = btStatus;
    }

    public int getGpsStatus() {
        return this.gpsStatus;
    }

    public void setGpsStatus(int gpsStatus) {
        this.gpsStatus = gpsStatus;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public void setBrightness(int brightness) {
        this.brightness = brightness;
    }

    public int getCamera() {
        return this.camera;
    }

    public void setCamera(int camera) {
        this.camera = camera;
    }

    public int getSound() {
        return this.sound;
    }

    public void setSound(int sound) {
        this.sound = sound;
    }

    public int getAudio() {
        return this.audio;
    }

    public void setAudio(int audio) {
        this.audio = audio;
    }

    public int getVibration() {
        return this.vibration;
    }

    public void setVibration(int vibration) {
        this.vibration = vibration;
    }

    public int getVoltage() {
        return this.voltage;
    }

    public void setVoltage(int voltage) {
        this.voltage = voltage;
    }

    public int getRssi() {
        return this.rssi;
    }

    public void setRssi(int rssi) {
        this.rssi = rssi;
    }

    public int getVideo() {
        return this.video;
    }

    public void setVideo(int video) {
        this.video = video;
    }

    public int getCall() {
        return this.call;
    }

    public void setCall(int call) {
        this.call = call;
    }

    public int getDnet() {
        return this.dnet;
    }

    public void setDnet(int dnet) {
        this.dnet = dnet;
    }

    public UnsignedInt getNetworkSendSize() {
        return this.networkSendSize;
    }

    public void setNetworkSendSize(UnsignedInt networkSendSize) {
        this.networkSendSize = networkSendSize;
    }

    public UnsignedInt getNetworkReceiveSize() {
        return this.networkReceiveSize;
    }

    public void setNetworkReceiveSize(UnsignedInt networkReceiveSize) {
        this.networkReceiveSize = networkReceiveSize;
    }

    public UnsignedInt getTotalUsedDrive() {
        return this.totalUsedDrive;
    }

    public void setTotalUsedDrive(UnsignedInt totalUsedDrive) {
        this.totalUsedDrive = totalUsedDrive;
    }

    public double[] getCpuFrequency() {
        return this.cpuFrequency;
    }

    public void setCpuFrequency(double[] cpuFrequency) {
        this.cpuFrequency = cpuFrequency;
    }

    public double[] getCpuLoad() {
        return this.cpuLoad;
    }

    public void setCpuLoad(double[] cpuLoad) {
        this.cpuLoad = cpuLoad;
    }

    public long getSystemMemoryUsed() {
        return this.systemMemoryUsed;
    }

    public void setSystemMemoryUsed(long systemMemoryUsed) {
        this.systemMemoryUsed = systemMemoryUsed;
    }

    public UnsignedInt getDiskReadOpCount() {
        return this.diskReadOpCount;
    }

    public void setDiskReadOpCount(UnsignedInt diskReadOpCount) {
        this.diskReadOpCount = diskReadOpCount;
    }

    public UnsignedInt getDiskReadByteSize() {
        return this.diskReadByteSize;
    }

    public void setDiskReadByteSize(UnsignedInt diskReadByteSize) {
        this.diskReadByteSize = diskReadByteSize;
    }

    public UnsignedInt getDiskWriteOpCount() {
        return this.diskWriteOpCount;
    }

    public void setDiskWriteSize(UnsignedInt diskWriteOpCount) {
        this.diskWriteOpCount = diskWriteOpCount;
    }

    public UnsignedInt getDiskWrittenByteSize() {
        return this.diskWrittenByteSize;
    }

    public void setDiskWrittenByteSize(UnsignedInt diskWrittenByteSize) {
        this.diskWrittenByteSize = diskWrittenByteSize;
    }

    public UnsignedInt getEnergyUsage() {
        return this.energyUsage;
    }

    public void setEnergyUsage(UnsignedInt energyUsage) {
        this.energyUsage = energyUsage;
    }

    public String getDeviceEnergyUsage() {
        return this.deviceEnergyUsage;
    }

    public void setDeviceEnergyUsage(String deviceEnergyUsage) {
        this.deviceEnergyUsage = deviceEnergyUsage;
    }

    public String getApplicationEnergyUsage() {
        return this.applicationEnergyUsage;
    }

    public void setApplicationEnergyUsage(String applicationEnergyUsage) {
        this.applicationEnergyUsage = applicationEnergyUsage;
    }

    public int getTargetProcessCount() {
        return this.targetProcessCount;
    }

    public void setTargetProcessCount(int targetProcessCount) {
        this.targetProcessCount = targetProcessCount;
    }

    public ProcessProfileData[] getProcessProfileDataList() {
        return this.processProfileDataList;
    }

    public void setProcessProfileDataList(ProcessProfileData[] processProfileDataList) {
        this.processProfileDataList = processProfileDataList;
    }

    public int getOtherProcessCount() {
        return this.otherProcessCount;
    }

    public void setOtherProcessCount(int otherProcessCount) {
        this.otherProcessCount = otherProcessCount;
    }

    public String getOtherProcessLoad() {
        return this.otherProcessLoad;
    }

    public void setOtherProcessLoad(String otherProcessLoad) {
        this.otherProcessLoad = otherProcessLoad;
    }

    public double getTotalCPULoad() {
        if (this.cpuLoad == null) {
            return 0.0;
        }
        double totalCPULoad = 0.0;
        int i = 0;
        while (i < this.cpuLoad.length) {
            totalCPULoad += this.cpuLoad[i];
            ++i;
        }
        double processCPULoad = this.getProcessCPULoad();
        if ((totalCPULoad /= (double)this.cpuLoad.length) < processCPULoad) {
            Logger.warning((Object)("totalCPULoad [" + totalCPULoad + "] is less than processCPULoad [ + " + processCPULoad + "]."));
            totalCPULoad = processCPULoad;
        }
        return totalCPULoad;
    }

    private double getProcessCPULoad() {
        double processCPULoad = 0.0;
        if (this.processProfileDataList != null) {
            int i = 0;
            while (i < this.processProfileDataList.length) {
                processCPULoad += (double)this.processProfileDataList[i].getProcessLoad();
                ++i;
            }
        }
        return processCPULoad;
    }

    @Override
    public int getPid() {
        return 0;
    }

    public static enum DEVICE_STATUS {
        WIFI,
        BLUETOOTH,
        GPS,
        BRIGHTNESS,
        DNET,
        CAMERA,
        SOUND,
        AUDIO,
        VIBRATION,
        VOLTAGE,
        RSSI,
        VIDEO,
        CALL;

    }
}

