/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmPopupProperties
extends HierarchyUIObjectProperties {
    private double hAlign;
    private double vAlign;
    private boolean allowEvents;
    private String contentTextWrapType;
    private String orient;
    private double timeout;

    public ElmPopupProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.hAlign = parser.getFloat();
        this.vAlign = parser.getFloat();
        this.allowEvents = parser.getBoolean();
        this.contentTextWrapType = this.getContextTextWrapTypeMessage(parser.getChar());
        this.orient = this.getOrientMessage(parser.getChar());
        this.timeout = parser.getFloat();
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("hAlign", Double.toString(this.hAlign)));
        properties.add(new PropertyValue("vAlign", Double.toString(this.vAlign)));
        properties.add(new PropertyValue("allowEvents", Boolean.toString(this.allowEvents)));
        properties.add(new PropertyValue("textWrapType", this.contentTextWrapType));
        properties.add(new PropertyValue("orient", this.orient));
        properties.add(new PropertyValue("timeout", Double.toString(this.timeout)));
        return properties;
    }

    private String getContextTextWrapTypeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_WRAP_NONE";
            }
            case 1: {
                return "ELM_WRAP_CHAR";
            }
            case 2: {
                return "ELM_WRAP_WORD";
            }
            case 3: {
                return "ELM_WRAP_MIXED";
            }
            case 4: {
                return "ELM_WRAP_LAST";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }

    private String getOrientMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_POPUP_ORIENT_TOP";
            }
            case 1: {
                return "ELM_POPUP_ORIENT_CENTER";
            }
            case 2: {
                return "ELM_POPUP_ORIENT_BOTTOM";
            }
            case 3: {
                return "ELM_POPUP_ORIENT_LEFT";
            }
            case 4: {
                return "ELM_POPUP_ORIENT_RIGHT";
            }
            case 5: {
                return "ELM_POPUP_ORIENT_TOP_LEFT";
            }
            case 6: {
                return "ELM_POPUP_ORIENT_TOP_RIGHT";
            }
            case 7: {
                return "ELM_POPUP_ORIENT_BOTTOM_LEFT";
            }
            case 8: {
                return "ELM_POPUP_ORIENT_BOTTOM_RIGHT";
            }
            case 9: {
                return "ELM_POPUP_ORIENT_LAST";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

