/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.network.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkSeriesType;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;

public class NetworkSeriesDBManager
extends DBTable {
    private static final String TABLENAME = "\tNETWORK_SERIES";
    private static final String DBTYPE_TEXT = "VARCHAR(256)";
    public static final String RID = "RID";
    public static final String DESTINATION_ADDRESS = "DESTINATION_ADDRESS";
    public static final String FD_VALUE = "NETWORK_FD";
    public static final String START_TIME = "START_TIME";
    public static final String END_TIME = "END_TIME";
    public static final String STATUS_TYPE = "STATUS_TYPE";
    public static final String API_ID = "API_ID";
    public static final String PID = "PID";
    public static final int DB_RID_INDEX = 0;
    public static final int DB_DESTINATION_ADDRESSINDEX = 1;
    public static final int DB_FD_VALUE_INDEX = 2;
    public static final int DB_START_TIME_INDEX = 3;
    public static final int DB_END_TIME_INDEX = 4;
    public static final int DB_STATUS_TYPE_INDEX = 5;
    public static final int DB_API_ID_INDEX = 6;
    public static final int DB_PID_INDEX = 7;
    private static final String SELECT_QUERY = "select RID,DESTINATION_ADDRESS,NETWORK_FD,START_TIME,END_TIME,STATUS_TYPE,API_ID,PID from \tNETWORK_SERIES";
    private static final String SELECT_PID_QUERY = "select RID,DESTINATION_ADDRESS,NETWORK_FD,START_TIME,END_TIME,STATUS_TYPE,API_ID,PID from \tNETWORK_SERIES where pid = '%s'";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public NetworkSeriesDBManager() {
        this.addColumn(new DBColumn(RID, "PRIMARY KEY", "INTEGER"));
        this.addColumn(new DBColumn(DESTINATION_ADDRESS, "NOT NULL", DBTYPE_TEXT));
        this.addColumn(new DBColumn(FD_VALUE, "NOT NULL", DBTYPE_TEXT));
        this.addColumn(new DBColumn(START_TIME, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(END_TIME, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(STATUS_TYPE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(API_ID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(PID, "NOT NULL", "INTEGER"));
    }

    public List<NetworkSeriesType> select(double visibleStartTime, double visibleEndTime) {
        String selectQuery = SELECT_QUERY;
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (selectedPid != 0) {
            selectQuery = String.format(SELECT_PID_QUERY, selectedPid);
        }
        double selectStartTime = visibleStartTime * 1000000.0;
        double selectEndTime = visibleEndTime * 1000000.0;
        String query = String.format(selectQuery, selectStartTime, selectEndTime);
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs == null) {
            SqlConnectionManager.releaseResultSet(rs);
            return null;
        }
        ArrayList<NetworkSeriesType> statusSeriesList = new ArrayList<NetworkSeriesType>();
        try {
            while (rs.next()) {
                NetworkSeriesType data = new NetworkSeriesType();
                data.setRid(rs.getInt(1));
                data.setDestinationAddress(rs.getString(2));
                data.setFdValue(rs.getString(3));
                data.setStartTime(rs.getLong(4));
                data.setEndTime(rs.getLong(5));
                data.setAPIType(rs.getInt(6));
                data.setApiID(rs.getInt(7));
                data.setpId(rs.getInt(8));
                statusSeriesList.add(data);
            }
            SqlConnectionManager.releaseResultSet(rs);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return statusSeriesList;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(1, (Integer)rowData.get(0));
                prep.setString(2, (String)rowData.get(1));
                prep.setString(3, (String)rowData.get(2));
                prep.setLong(4, (Long)rowData.get(3));
                prep.setLong(5, (Long)rowData.get(4));
                prep.setInt(6, (Integer)rowData.get(5));
                prep.setInt(7, (Integer)rowData.get(6));
                prep.setInt(8, (Integer)rowData.get(7));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }
}

