/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.data;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProcessProfileData;
import org.tizen.dynamicanalyzer.swap.model.data.SystemData;
import org.tizen.dynamicanalyzer.ui.thread.data.ThreadDataManager;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageThreadDataEvent;
import org.tizen.dynamicanalyzer.util.Logger;

public class ThreadLoadDataMaker {
    public void makeLoadData(List<LogData> loadInputs) {
        int logSize = loadInputs.size();
        int i = 0;
        while (i < logSize) {
            this.parseLoad(loadInputs.get(i));
            ++i;
        }
    }

    public void parseLoad(LogData input) {
        if (input == null) {
            return;
        }
        if (!(input instanceof SystemData)) {
            return;
        }
        ProcessProfileData[] processDataList = ((SystemData)input).getProcessProfileDataList();
        ArrayList<ThreadPageThreadDataEvent> insertThreadEventList = new ArrayList<ThreadPageThreadDataEvent>();
        int i = 0;
        while (i < processDataList.length) {
            String loads = processDataList[i].getThreadLoad();
            String[] temp = loads.split(",");
            int j = 0;
            while (j + 1 < temp.length) {
                String tid;
                try {
                    tid = temp[j];
                }
                catch (NumberFormatException numberFormatException) {
                    Logger.error((Object)"parseLoad - tid parsing");
                    break;
                }
                int load = (int)Double.parseDouble(temp[j + 1]);
                long time = input.getTime();
                ThreadPageThreadDataEvent event = new ThreadPageThreadDataEvent(2, load, -1, time, Integer.parseInt(tid), String.valueOf(String.valueOf(load)) + ThreadPageLabels.THREAD_CHART_ITEM_PERCENT, -1L, null);
                event.setThreadDataID(ThreadDataManager.getInstance().getThreadDataMaker().getThreadDataID(event.getTid()));
                insertThreadEventList.add(event);
                j += 2;
            }
            ++i;
        }
        ThreadDataManager.getInstance().insertThreadEventData(insertThreadEventList, true);
    }

    public void clear() {
    }
}

